#include "mbed.h"
#include "clubbing.h"
#include "UdpToScom.h"
#include "EthernetSetup.h"



struct S_EthernetAddress_Remote
/*{
  char ip[16];
  int port;   
}*/ s_EthAddRemote = {"192.168.1.14", 13000 }, *ps_ear = &s_EthAddRemote,
  s_EthAddBroadcast = {"0.0.0.0", 13000 }, *ps_eab = &s_EthAddBroadcast;

char lokaUdpPort[6] = "13000", localUdpPortFlash[6] = "65535";

#define SerialTxPin     PTC17
#define SerialRxPin     PTC16
char scomBaud[7] = "9600", scomBaudFlash[7] = "200000";


/* globalni pointeri*/


EthernetInterface *gp_eth;

UDPSocket *gp_udpSocket = NULL;
Thread *gp_udpRxThread = NULL;

Thread *gp_scomRxThread=NULL;
UARTSerial *gp_scom=NULL;


int get_baud( void )
{
  int a = atoi(scomBaudFlash), b = atoi(scomBaud), ret;
  if( (a > 90) && (a < 100000) ) ret = a;
  else if( (b > 90) && (b < 100000) ) ret = b;
  else ret = 96/*00*/;
  printf(" baud rates = %d %d  final %d\n\r", a, b, ret );
  return ret;  
}

/***************** Predaja na UDP  ****************************/
void sendUdp( struct S_EthernetAddress_Remote *ps_ear, char *buffer, int val )
{   
  if( gp_udpSocket )
  {
    printf(" UDPpaket ip=%s port=%d val=%d\n\r", ps_ear->ip, ps_ear->port, val);
    gp_udpSocket->sendto(ps_ear->ip, ps_ear->port, (const uint8_t*)buffer, val);
  }
  else printf("UDPsocket == NULL\n\r");
}

/****************  Predaja na Serial Com ********************************/

void sendScom( struct UARTSerial *p_scom, char *buffer, int val)
{
   if( p_scom )
   {
     int num;
        if(val>0)  num = p_scom->write( (const uint8_t*) buffer, val );
        printf(" Poslan serial com paket od %d bajtova", num);
    }
    else printf("Serial com neinicijalizovan\n\r");
}

/**************  Prijem na serial com i slanje na UDP  *********************/

void scomrx_fun( void )
{
    
    uint8_t readbuff[1500];
    int totno=0; 
    int noreaded=0;
//  if(gp_scom) delete gp_scom;
      gp_scom = new UARTSerial(SerialTxPin,SerialRxPin,get_baud());  //38400 za KSS
    
       printf("Rx serial com initialised\n\r");
       
       while( !(ThisThread::flags_get( ) & 1) )
      {
        if( gp_scom->readable() )   
        {
            noreaded = gp_scom->read( (uint8_t *)(readbuff+totno), 1500);
            totno += noreaded;
            wait(0.01);     
        }
        else if(totno) 
        {
            printf("PRIJEM na rs232 com   totno = %d  \n\r", totno);   
       //     if(readbuff[0] == 'q') {extern Thread udpBroadcast_thread; udpBroadcast_thread.terminate();}
    
            if(readbuff[0] == 'c'){ extern void udpBroadcast_fun( void );Thread *th = new Thread; th->start( udpBroadcast_fun);}
            if(readbuff[0] == 'r'){ extern void inic_1(void); extern PFV pfv; pfv = inic_1;  }
            if(readbuff[0] == 'q'){ if(gp_udpSocket)gp_udpSocket->close();gp_udpSocket=NULL;  }
            sendUdp( ps_ear, (char *)readbuff, totno); 
            totno = 0;      
        } 
  }
  if(gp_scom) {delete gp_scom; gp_scom = NULL;}
  printf(" Ugasen serial com Thread\n\r");
} 


/*******************  Broadcast thread  **********************/
Thread udpBroadcast_thread;
void udpBroadcast_fun( void )
{
    while(true)
    {
        sendUdp(  ps_eab, (char *)"test broadcast", 14);
        wait(5);
    }   
}

/***************  Prijem na UDP socket i predaja na Serial com ***************/

void udpRx_fun( void )
{
//int *p = (int*)pp;
   nsapi_error_t err;

    char inbuff[1500];

  //  if(gp_udpSocket == NULL)
    {
         gp_udpSocket = new UDPSocket;
        printf("___novi UDP socket %x\n\r", gp_udpSocket);
         if( (err = gp_udpSocket->open( gp_eth ))  != NSAPI_ERROR_OK )  
            { printf(" greska otvaranja soketa %d \n\r", err);  }
         gp_udpSocket->bind(ps_ear->port);
         gp_udpSocket->set_timeout(1000);
    }
    printf("UDPrx inicijalizovan \n\r");


signed int n=0;
    while( !(ThisThread::flags_get( ) & 1) )
   {
        SocketAddress sockAddr;
       if( (n>=0) && gp_udpSocket )
       {
        int n = gp_udpSocket->recvfrom(&sockAddr, &inbuff, sizeof(inbuff));
        if(n>0)  sendScom( gp_scom, inbuff, n);//gp_scom->write( (const uint8_t*) inbuff, n );
        else if(n==-3001)  n = 0;
        else break;
       }
       //else wait(0.1);
    } 
    
    if(gp_udpSocket) { delete gp_udpSocket; gp_udpSocket = NULL;}
    printf("udpSocket obrisan\n\r");
    fflush(stdout);
}



void inic_1(void)
{

  printf("\n\r --------  REINICIJALIZACIJA  ------------- \n\r");

     /* Gasenje UDP threada  */
     if( gp_udpRxThread->get_state( ) && gp_udpRxThread->get_state( )<16 )
        gp_udpRxThread->flags_set( 1 );
     gp_udpRxThread->join( );
     if(gp_udpRxThread) {delete gp_udpRxThread; gp_udpRxThread = NULL;}
     printf("udp thread zavrsio\n\r");
    
    /* gasenje serial com thread-a */
    int st = gp_scomRxThread->get_state();
    if( st && st<16 )gp_scomRxThread->flags_set(1);
    gp_scomRxThread->join();
    printf("ScomRx Thread upravo zavrsio\n\r");
    if(gp_scomRxThread) { delete gp_scomRxThread; gp_scomRxThread = NULL;}
    
     gp_eth->disconnect();           /* gasenje ethernta */
     
     gp_eth = ethernet_setup(  );    /*paljenje etherneta*/
     if(gp_eth == NULL) printf("ethernet greska\n\r"); 
     else printf("eth OK\n\r");
  
     /* paljenje UDP thread-a */
     gp_udpRxThread = new Thread( udpRx_fun );

    
    /* paljenje serial com thread-a */
    gp_scomRxThread = new Thread(scomrx_fun);

    
//    
    fflush(stdout);

}

void init_EthToScom( void )
{
 gp_eth = ethernet_setup(  );

 if(gp_eth == NULL) printf("ethernet greska"); 
 else printf("eth OK\n\r");
 

  if(gp_scomRxThread) delete gp_scomRxThread;
  gp_scomRxThread = new Thread(scomrx_fun);
 
    
    /*
    TCPSocket socket;        
    socket.open(&eth);
    socket.connect(
    */
   
    
    gp_udpRxThread = new Thread( udpRx_fun );

}