#include "dataFlash.h"

#include "flashDataBlock.h"
#include "EthernetSetup.h"
#include "clubbing.h"
#include "dataFlash.h"

#include "doHTML.h"




struct S_FlashData s_ramData,  *gps_rd = &s_ramData; //RAM podaci


/***********  upis/citanje na ram         */
void progDataIntoFlash( struct S_FlashData *ps_fd )
{
   write_niz_in_flash( 0, (char *)ps_fd, sizeof(S_FlashData) );
}

void readDataFromFlash( struct S_FlashData *ps_fd )
{
     read_fdb( 0, (char*)ps_fd, sizeof(struct S_FlashData) );
}


/*   upis citanje u RAM na koji pokazuje globalni pointer  gps_rd  */
void fillDataIntoFlash( void )
{
   progDataIntoFlash(  gps_rd );
  // write_niz_in_flash( 0, (char *)gps_rd, sizeof(S_FlashData) );
}
void refreshDataFromFlash( void )
{
     readDataFromFlash( gps_rd );
//     read_fdb( 0, (char*)gps_rd, sizeof(struct S_FlashData) );
}


void init_FlashData( void )
{
   init_fdb( );
   readDataFromFlash( gps_rd );

}


void deinit_FlashData( void )
{
   deinit_fdb( ); 
}

void showFlashData( void )
{
   P_str( "FLASH IP ", gps_rd->s_EthAdd.ip ); 
   P_str( "FLASH MASK ", gps_rd->s_EthAdd.mask ); 
   P_str( "FLASH GATE ", gps_rd->s_EthAdd.gate ); 

   P_str( "FLASH UDP PORT ", gps_rd->serverPortUdp ); 
   P_str( "FLASH TCP PORT ", gps_rd->serverPortTcp ); 
   
   P_str( "FLASH UDP IP[0] ", gps_rd->s_EthAddRemUdp[0].ip ); 
   P_int( "FLASH UDP PORT[0] ", gps_rd->s_EthAddRemUdp[0].port ); 
   P_str( "FLASH TCP IP[0] ", gps_rd->s_EthAddRemTcp[0].ip ); 
   P_int( "FLASH TCP PORT[0] ", gps_rd->s_EthAddRemTcp[0].port ); 
   
//   P_int( "FLASH SERIAL BAUD ", gps_rd->baudRate ); 
//   P_int( "FLASH SERIAL BAUD ", gps_rd->parity ); 
//   P_int( "FLASH SERIAL BAUD ", gps_rd->dataBits ); 
//   P_int( "FLASH SERIAL BAUD ", gps_rd->stopBits ); 
} 



void putHTMLintoFLASH( C_HTMLparse *pch )
{
    
    
    if( test_ip( pch->get_myIP( ) ) ) strncpy( gps_rd->s_EthAdd.ip, pch->get_myIP( ), 16 );
    if( test_ip( pch->get_myMASK( ) ) ) strncpy( gps_rd->s_EthAdd.mask, pch->get_myMASK(), 16 );
    if( test_ip( pch->get_myGATE( ) ) ) strncpy( gps_rd->s_EthAdd.gate, pch->get_myGATE(), 16 );

    strncpy( gps_rd->serverPortUdp, pch->get_myUdpPort(), 6 );
    strncpy( gps_rd->serverPortTcp, pch->get_myTcpPort(), 6 );
    
    if( test_ip( pch->get_UdpIP(1) ) )strncpy( gps_rd->s_EthAddRemUdp[0].ip, pch->get_UdpIP(1), 16 ); 
    gps_rd->s_EthAddRemUdp[0].port = atoi( pch->get_UdpPort(1) ); 

    if( test_ip( pch->get_TcpIP(1) ) )strncpy( gps_rd->s_EthAddRemTcp[0].ip, pch->get_TcpIP(1), 16 ); 
    gps_rd->s_EthAddRemTcp[0].port = atoi( pch->get_TcpPort(1) ); 

    fillDataIntoFlash( );
}


void putFLASHintoHTML( C_HTMLparse *pch )
{
    
   refreshDataFromFlash( );
    
    if( test_ip( gps_rd->s_EthAdd.ip ) ) pch->set_myIP( gps_rd->s_EthAdd.ip );
    if( test_ip( gps_rd->s_EthAdd.mask ) ) pch->set_myMASK( gps_rd->s_EthAdd.mask );
    if( test_ip( gps_rd->s_EthAdd.gate ) ) pch->set_myGATE( gps_rd->s_EthAdd.gate );

    if( test_num( gps_rd->serverPortUdp )) pch->set_myUdpPort(gps_rd->serverPortUdp);
    if( test_num( gps_rd->serverPortTcp )) pch->set_myTcpPort(gps_rd->serverPortTcp);
    
    if( test_ip( gps_rd->s_EthAddRemUdp[0].ip ) ) pch->set_UdpIP(1,gps_rd->s_EthAddRemUdp[0].ip); 
    
    char port[10];
    sprintf(port, "%d", gps_rd->s_EthAddRemUdp[0].port); 
    pch->set_UdpPort( 1, port ); 

    if( test_ip( gps_rd->s_EthAddRemTcp[0].ip ) ) pch->set_TcpIP(1, gps_rd->s_EthAddRemTcp[0].ip ); 
    sprintf( port, "%d", gps_rd->s_EthAddRemTcp[0].port);
    pch->set_TcpPort( 1, port ); 

}





//
//struct S_EthernetAddress
//{
//  char ip[16];
//  char mask[16];
//  char gate[16];
// // int port;    
//};
//
//struct S_EthernetAddress_Remote
//{
//  char ip[16];
//  int port;   
//};
//
//struct S_FlashData
//{
//    struct S_EthernetAddress s_EthAdd;
//    char serverPortUdp[6];
//    char serverPortTcp[6];
//    struct S_EthernetAddress_Remote s_EthAddRemUdp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemUDP;
//    struct S_EthernetAddress_Remote s_EthAddRemTcp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemTcp;
//    int baudRate, parity, dataBits, stopBits;
//};
//
//union U_FlashData
//{
//    struct S_FlashData s_flashData;
//    char data[sizeof( struct S_FlashData )];
//};