#include "clubbing.h"
#include "string.h"
#include "dxml.h"

#include "doHTML.h"
#include "dataFlash.h"
#include "HTMLpage.h"


char* p_HTMLpage;
dxml_t p_rootHTML;

static dxml_t html_body, html_form, html_table, /*html_*/tr;
 
static dxml_t front_row[3];
static dxml_t UDPs[10];
static dxml_t TCPs[10];
static dxml_t serial[4];


char *getHTML_free( void )
{
    return dxml_toxml(p_rootHTML);
}



static void load_front_row()
{
    int i = 0;
    for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
    {
        auto input = dxml_child(td, "input");
        front_row[i] = input;
        ++i;
    }
    
    tr = tr->next;
}
 
static void load_second_row()
{
    int i = 0;
    for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
    {
        auto input = dxml_child(td, "input");
        if (i == 0)
            UDPs[0] = input;
        else if(i == 1)
            TCPs[0] = input;
        ++i;
    }
    
    tr = tr->next;
}
 
static void load_udp_and_tcp(dxml_t& td)
{
    for (int i = 0; i < 4; td = td->next)
    {
        dxml_t inputs[5];
        int input_count = 0;
        for (auto input = dxml_child(td, "input"); input; input = input->next)
            inputs[input_count++] = input;
        
        if (i < 2) // Load inputs into UDPs
        {
            for (int k = 0; k < input_count; ++k)
                UDPs[i == 0 ? k + 1 : k + 6] = inputs[k];
        }
        else
        {
            for (int k = 0; k < input_count; ++k)
                TCPs[i == 2 ? k + 1 : k + 6] = inputs[k];
        }
                
        ++i;    
    }
}
 
void load_serial(dxml_t& td)
{
    auto select = dxml_child(td, "select");
    for (int i = 0; select; select = select->next)
        serial[i++] = select;
}
 

dxml_t get_serial_option(dxml_t s, int option_idx);
void init_html( void )
{
    
    p_HTMLpage = (char*)malloc(sizeof(HTMLpage));
    strcpy( p_HTMLpage, HTMLpage);
    P_int("ucitavam html", sizeof(HTMLpage));
    
    
    p_rootHTML = dxml_parse_str(p_HTMLpage, strlen(p_HTMLpage));
    html_body = dxml_child(p_rootHTML, "body");
    html_form = dxml_child(html_body, "form");
    html_table = dxml_child(html_form, "table");
    tr = dxml_child(html_table, "tr");
    
//    //load_first_row();
    load_front_row();
//    P_str("front 1", (char*)dxml_attr(front_row[0], "value"));
//    P_str("front 2", (char*)dxml_attr(front_row[1], "value"));
//    P_str("front 3", (char*)dxml_attr(front_row[2], "value"));
    
    load_second_row();
//    P_str("UDP[0]", (char*)dxml_attr(UDPs[0], "value"));
//    P_str("TCP[0]", (char*)dxml_attr(TCPs[0], "value")); 
    printf("\n\r");
    
    auto td = dxml_child(tr, "td");
    load_udp_and_tcp(td);
    load_serial(td);    

//    for( int i=0; i<10; i++ ) P_str("UDP", (char*)dxml_attr(UDPs[i], "value"));
//    for( int i=0; i<10; i++ ) P_str("TCP", (char*)dxml_attr(TCPs[i], "value"));


//    for( int i=0; i<4; i++ )
//    {
//        {
//             P_str("Serial", (char*)dxml_attr(serial[i], "name"));
//             for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)  
//               P_str( (char*)dxml_attr(serial[i], "name"), (char *)dxml_attr(get_serial_option(serial[i], j), "value"));
//        }
//    } 

extern const char *get_selected_option( const char *name_option );
extern const char * set_selected_option( const char* name_option, const char* value_option );

 P_str( "selected bit rate" ,  (char*)get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)get_selected_option( "data_bits" ) );

 P_str( "select bit rate 38400", set_selected_option( "baud_rate", "38400" ) );
 P_str( "select bit parity ODD", set_selected_option( "parity", "odd" ) );
 P_str( "select stop bits 1.5", set_selected_option( "stop_bits", "1.5" ) );
 P_str( "select data bits 7", set_selected_option( "data_bits", "7" ) );

P_str( "selected bit rate" ,  (char*)get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)get_selected_option( "data_bits" ) );


}

const char *get_selected_option( const char *name_option )
{
    for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
    {
       char *ret;  
         if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
         {
           for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
           {
              if( dxml_attr( get_serial_option(serial[i],j), "selected" ) ) 
                return  dxml_attr(get_serial_option(serial[i], j), "value");
            } 
           return  dxml_attr(get_serial_option(serial[i], 0), "value"); 
         }
    } 
    return NULL;
}

const char * set_selected_option( const char* name_option, const char* value_option )
{
    for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
    {
    //   printf(" i = %d  \n\r", i );
       char *ret;  
         if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
         {
           for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
           {
      //        printf("  j=%d \n\r", j);
              if( !strcmp( dxml_attr( get_serial_option(serial[i],j), "value"), value_option) )
              {
                if( !dxml_attr( get_serial_option(serial[i],j), "selected") )
                { 
                    for(int k=0; dxml_attr(get_serial_option(serial[i], k), "value") != NULL; k++)
                    {
    //                  printf("   k=%d\n\r",k);
                      if( !strcmp( dxml_attr( get_serial_option(serial[i],k), "value"), value_option) )
                             { printf("   kk=%d\n\r",k); dxml_set_attr( get_serial_option(serial[i],k), "selected", "ON" );}
                      else  {  printf("   k=%d\n\r",k); dxml_set_attr( get_serial_option(serial[i],k), "selected", "" );}
                    }
                }
                return value_option;
              }
            }  
         }
    } 
    
    return NULL;
    
}

 
//dxml_t[3] get_front_row()   
dxml_t* get_front_row()   
{
    return front_row;
}
 
//dxml_t[10] get_udp()
dxml_t* get_udp()
{
    return UDPs;
}
 
//dxml_t[10] get_tcp()
dxml_t* get_tcp()
{
    return TCPs;
}
 
//dxml_t[4] get_serial()
dxml_t* get_serial()
{
    return serial;
}
 
dxml_t get_serial_option(dxml_t s, int option_idx)
{
    auto rv = dxml_child(s, "option");
    for (int i = 0; i < option_idx; ++i)
    {
        if( rv->next == NULL ) return NULL;
        else rv = rv->next;
    }
    return rv;
}
 


extern struct S_FlashData *gps_fd;
//   P_str( "FLASH IP ", gps_fd->s_EthAdd.ip ); 
//   P_str( "FLASH MASK ", gps_fd->s_EthAdd.mask ); 
//   P_str( "FLASH GATE ", gps_fd->s_EthAdd.gate ); 
//
//   P_str( "FLASH UDP PORT ", gps_fd->serverPortUdp ); 
//   P_str( "FLASH TCP PORT ", gps_fd->serverPortTcp ); 
//   
//   P_str( "FLASH UDP IP[0] ", gps_fd->s_EthAddRemUdp[0].ip ); 
//   P_int( "FLASH UDP PORT[0] ", gps_fd->s_EthAddRemUdp[0].port ); 
//   P_str( "FLASH TCP IP[0] ", gps_fd->s_EthAddRemTcp[0].ip ); 
//   P_int( "FLASH TCP PORT[0] ", gps_fd->s_EthAddRemTcp[0].port ); 
//   
//   P_int( "FLASH SERIAL BAUD ", gps_fd->baudRate ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->parity ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->dataBits ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->stopBits ); 

void putHTMLintoFlash( void )
{
    strncpy( gps_fd->s_EthAdd.ip, dxml_attr(front_row[0], "value"), 16 );
    strncpy( gps_fd->s_EthAdd.mask, dxml_attr(front_row[1], "value"), 16 );
    strncpy( gps_fd->s_EthAdd.gate, dxml_attr(front_row[2], "value"), 16 );

    strncpy( gps_fd->serverPortUdp, dxml_attr(UDPs[0], "value"), 6 );
    strncpy( gps_fd->serverPortTcp, dxml_attr(TCPs[0], "value"), 6 );
    
    strncpy( gps_fd->s_EthAddRemUdp[0].ip, dxml_attr(UDPs[1], "value"), 16 ); 
    gps_fd->s_EthAddRemUdp[0].port = atoi( dxml_attr(UDPs[6], "value") ); 

    strncpy( gps_fd->s_EthAddRemTcp[0].ip, dxml_attr(TCPs[1], "value"), 16 ); 
    gps_fd->s_EthAddRemTcp[0].port = atoi( dxml_attr(TCPs[6], "value") ); 

    fillDataIntoFlash( );
}




