#include "mbed.h"
#include "string.h"

#include "EthernetSetup.h"
#include "dxml.h"
#include "TcpServerToFlash.h"
#include "doHTML.h"

#define SOCKET_PORT 11000

Semaphore s(1); /* semafor da ne dozvoli vise of 1 server thred-a, upravlja delet-ovanjem threda*/


extern EthernetInterface *gp_eth;

void tcpServerRx_fun( void );
Thread *gp_tcpServerThread = new Thread;
TCPSocket *gp_tcpSocket=NULL;
volatile Thread *gp_thr = NULL;


const char sendHTTPheader[]= "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE html>";

typedef void(*PF_PSTP)(struct SThreadParam *);

struct SThreadParam
{
  Thread *p_Thread; 
  void * p_param;  
  PF_PSTP pf_pstp;  
};

/******************  inicijalizacija u mainu  ************************/

void inic_TcpServerToFlash( void )
{
    gp_tcpServerThread->start(tcpServerRx_fun);

}

/*****************  periodicna prozivka u mainu *************************/

void cleanTcpServerToFlashThread( void )
{
        if(gp_thr) 
        { 
            printf("brisanje thread-a %d\n\r", gp_thr); 
            delete gp_thr; gp_thr = NULL; 
            s.release(); 
        } 
}


/**************  Trajni TCPServer thread *********************************/

extern void rcpServerInstance_fun( SThreadParam *ps_thr );
void tcpServerRx_fun( void )
{
   printf("Otvoren tcp server rx thread \n\r");   

   if( gp_tcpSocket == NULL )
   {
      gp_tcpSocket = new TCPSocket;
      gp_tcpSocket->open( gp_eth );
      if(gp_tcpSocket->bind(SOCKET_PORT) !=0) printf("greska bindovanja socketa\n\r");
    }
    if(gp_tcpSocket->listen(1) != 0 )  printf("greska listenovanja na socketu\n\r");;
 
    TCPSocket *p_soc;
    nsapi_error_t err=NULL;      
 
    while(   (p_soc = gp_tcpSocket->accept( &err)) || (err == NSAPI_ERROR_NO_SOCKET)  )
    {
        s.wait();

        Thread *p_thr = new Thread;
         struct SThreadParam *ps_thp = new struct SThreadParam;
         ps_thp->p_param = (void*)p_soc;
         ps_thp->p_Thread = p_thr;
         ps_thp->pf_pstp = rcpServerInstance_fun;
       
        printf("TCPThread: NOVA KONEKCIJA!  thread %d   socket  %d   struct Sst %d\n\r", ps_thp->p_Thread, p_soc, ps_thp);
        p_thr->start( callback( ps_thp->pf_pstp, ps_thp ));

    }

    if( gp_tcpSocket ) {delete gp_tcpSocket; gp_tcpSocket = NULL; } /* ima smisla ako se thread nasilno zatvara  */
}




/***************** privremeni TCPServer thread za klijenta  ******************/

void rcpServerInstance_fun( struct SThreadParam *ps_thp )
{
     TCPSocket *p_soc = (TCPSocket *)ps_thp->p_param;
     char inbuff[1500];

      int n, nr, nt;
      printf("thread:  Otvoren socket %d\n\r",(int)p_soc);   

    
        while(true)
       {        
            printf("\n\rcekam prijem od klijenta \n\r");
            SocketAddress sockAddr;
            p_soc->getpeername( &sockAddr );
            
            p_soc->set_timeout(10);
            n=0;
            do
            {
               nr = p_soc->recv( &(inbuff[n]), sizeof(inbuff)-n);
               if(nr > 0) n += nr;
               if(n>= sizeof(inbuff)) break;
            }
            while( (n==0) || (nr > 0) );
            if( (nr < 0) && (nr != NSAPI_ERROR_WOULD_BLOCK) )   break;
            
            if(n>0)
            {
              printf("PRIJEM: primljeno = %d bajtova \n\r",n);
//              {int i; for(i=0;i<n;i++)  printf("%c", inbuff[i] );}
//                printf("\n\r");
//                      fflush(stdout);
             }
    
            p_soc->set_timeout(-1);
            n = p_soc->send(sendHTTPheader, strlen(sendHTTPheader));
            printf("PREDAJA HTTPheader: posato bajtova = %d, %d \n\r", n, strlen(sendHTTPheader));
            
            auto c = getHTML_free( );
            n = p_soc->send(c, strlen(c));
            free(c);
            printf("PREDAJA dataBuffer: posato bajtova = %d, %d \n\r", n, strlen(c));
            
            
            p_soc->close();
           /* if(n<0)*/ {printf("BREAK posle predaje\n\r"); break;}
        }
    
      gp_thr = ps_thp->p_Thread;//   poslati pointer da se delete-uje
      delete ps_thp;
      
}

