#include "flashDataBlock.h"
#include "FlashIAPBlockDevice.h"

extern void printf_niz( char *s, char *niz, int val );
//{
//   printf("%s",s);
//   for( int i=0; i < val; i++)  printf("%c", niz[i]);
//   printf("\n\r");   
//}


FlashIAPBlockDevice bd((uint32_t)FLASH_ADDRESS,BLOCK_VALUE);

int device_size;
int read_size;
int program_size;
int erase_size;
int erase_value;
int buffer_dimension = buffer_dimension;
void init_fdb( )
{
    // Initialize the flash IAP block device and print the memory layout
    int err = bd.init();
    printf("init err=%d  \n\r", err);

    printf("Flash block device size: %llu\n\r",         device_size = bd.size());
    printf("Flash block device read size: %llu\n\r",    read_size = bd.get_read_size());
    printf("Flash block device program size: %llu\n\r", program_size = bd.get_program_size());
    printf("Flash block device erase size: %llu\n\r",   erase_size = bd.get_erase_size());
    printf("Flash block device geterase value: %x\n\r", erase_value =  bd.get_erase_value());

    if( bd.is_valid_read( 0, bd.get_read_size() ) )  printf(" read valid \n\r");
}

void deinit_fdb( void )
{
    bd.deinit();
}

int scale_buffer_dimension( int val )
{
    if( val > device_size ) { val = buffer_dimension = device_size; printf("buf_dim = %d\n\r", buffer_dimension);}
    else if( val > buffer_dimension ) { buffer_dimension = val; printf("buf_dim = %d\n\r", buffer_dimension);}
  return val;
}

 int read_fdb( int rel_adr, char *buffer, int val )
 {  
  int err;
    val = scale_buffer_dimension( rel_adr+val );
    err = bd.read(buffer, rel_adr, val);
    return (err == 0) ? val : 0 ;
 }

int write_byte_in_flash( int adr, char value )
{
  int err = 0;
  int prog_page = program_size;
  int adr_first = (adr/prog_page)*prog_page;
  int adr_last = adr_first + prog_page;

  scale_buffer_dimension( adr );

  char *buffer = (char*)malloc(buffer_dimension);
     
   if( !(err = bd.read(buffer, 0, buffer_dimension)))

        if( !(err = bd.erase(0, erase_size)))
        {
            buffer[adr] = value;
            err = bd.program(buffer, 0, (buffer_dimension % prog_page) ? buffer_dimension + prog_page - buffer_dimension % prog_page: buffer_dimension);
        }

    free(buffer);
    return err;   
}
int write_niz_in_flash( int adr, char *niz, int nizval )
{
 int err = 0;
  int prog_page = bd.get_program_size();
  int adr_first = (adr/prog_page)*prog_page;
  int adr_last = adr_first + prog_page;

  scale_buffer_dimension( adr + nizval );

  char *buffer = (char*)malloc(buffer_dimension);
     
   if(!(err = bd.read(buffer, 0, buffer_dimension)))
     if(!(err = bd.erase(0, bd.get_erase_size())))
     {   
        for( int i = adr; i<(adr+nizval); i++)  buffer[adr+i] = niz[i];
        err = bd.program(buffer, 0, (buffer_dimension % prog_page) ? buffer_dimension + prog_page - buffer_dimension % prog_page: buffer_dimension);
     }   
    free(buffer);
   return err;
}
