#ifndef dataFlash_h
#define dataFlash_h

#include "EthernetSetup.h"


struct S_FlashData
{
    struct S_EthernetAddress s_EthAdd;
    char serverPortUdp[6];
    char serverPortTcp[6];
    struct S_EthernetAddress_Remote s_EthAddRemUdp[3];
//    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemUDP;
    struct S_EthernetAddress_Remote s_EthAddRemTcp[3];
//    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemTcp;
    int baudRate, parity, dataBits, stopBits;
};

union U_FlashData
{
    struct S_FlashData s_flashData;
    char data[sizeof( struct S_FlashData )];
};



void progDataIntoFlash( struct S_FlashData *ps_fd );

void readDataFromFlash( struct S_FlashData *ps_fd );

void fillDataIntoFlash( void );

void refreshDataFromFlash( void );


void init_FlashData( void );

void deinit_FlashData( void );

void showFlashData( void );

#endif
