#include "dataFlash.h"

#include "flashDataBlock.h"
#include "EthernetSetup.h"
#include "clubbing.h"
#include "dataFlash.h"

//
//struct S_EthernetAddress
//{
//  char ip[16];
//  char mask[16];
//  char gate[16];
// // int port;    
//};
//
//struct S_EthernetAddress_Remote
//{
//  char ip[16];
//  int port;   
//};
//
//struct S_FlashData
//{
//    struct S_EthernetAddress s_EthAdd;
//    char serverPortUdp[6];
//    char serverPortTcp[6];
//    struct S_EthernetAddress_Remote s_EthAddRemUdp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemUDP;
//    struct S_EthernetAddress_Remote s_EthAddRemTcp[3];
////    struct S_EthernetAddress_RangeRemote s_EthAddRangeRemTcp;
//    int baudRate, parity, dataBits, stopBits;
//};
//
//union U_FlashData
//{
//    struct S_FlashData s_flashData;
//    char data[sizeof( struct S_FlashData )];
//};


struct S_FlashData s_flashData,  *gps_fd = &s_flashData;

void progDataIntoFlash( struct S_FlashData *ps_fd )
{
   write_niz_in_flash( 0, (char *)ps_fd, sizeof(S_FlashData) );
}

void readDataFromFlash( struct S_FlashData *ps_fd )
{
     read_fdb( 0, (char*)ps_fd, sizeof(struct S_FlashData) );
}

void fillDataIntoFlash( void )
{
   write_niz_in_flash( 0, (char *)gps_fd, sizeof(S_FlashData) );
}

void refreshDataFromFlash( void )
{
     read_fdb( 0, (char*)gps_fd, sizeof(struct S_FlashData) );
}


void init_FlashData( void )
{
   init_fdb( );
   readDataFromFlash( gps_fd );

}


void deinit_FlashData( void )
{
   deinit_fdb( ); 
}

void showFlashData( void )
{
   P_str( "FLASH IP ", gps_fd->s_EthAdd.ip ); 
   P_str( "FLASH MASK ", gps_fd->s_EthAdd.mask ); 
   P_str( "FLASH GATE ", gps_fd->s_EthAdd.gate ); 

   P_str( "FLASH UDP PORT ", gps_fd->serverPortUdp ); 
   P_str( "FLASH TCP PORT ", gps_fd->serverPortTcp ); 
   
   P_str( "FLASH UDP IP[0] ", gps_fd->s_EthAddRemUdp[0].ip ); 
   P_int( "FLASH UDP PORT[0] ", gps_fd->s_EthAddRemUdp[0].port ); 
   P_str( "FLASH TCP IP[0] ", gps_fd->s_EthAddRemTcp[0].ip ); 
   P_int( "FLASH TCP PORT[0] ", gps_fd->s_EthAddRemTcp[0].port ); 
   
//   P_int( "FLASH SERIAL BAUD ", gps_fd->baudRate ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->parity ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->dataBits ); 
//   P_int( "FLASH SERIAL BAUD ", gps_fd->stopBits ); 
} 
