#include "mbed.h"
#include "EthernetInterface.h"


struct S_EthernetAddress
{
  char ip[16];
  char mask[16];
  char gate[16];
  int port;    
} s_EthAdd = {"192.168.1.20", "255.255.255.0", "192.168.1.1", 13000};

struct S_EthernetAddress_Remote
{
  char ip[16];
  int port;   
} s_EthAddRemote = {"192.168.1.14", 13000 }, *ps_ear = &s_EthAddRemote,
  s_EthAddBroadcast = {"0.0.0.0", 13000 }, *ps_eab = &s_EthAddBroadcast;


EthernetInterface eth;

struct S_net
{
 struct S_EthernetAddress *ps_ea;
 EthernetInterface *p_eth;
} s_net = { &s_EthAdd, &eth};    

nsapi_error_t err;
void ethernet_setup( struct S_net * );

UDPSocket udpSocket;

void sendUdp( struct S_EthernetAddress_Remote *ps_ear, char *buffer, int val )
{
    printf(" UDPpaket ip=%s port=%d val=%d\n\r", ps_ear->ip, ps_ear->port, val);
    udpSocket.sendto(ps_ear->ip, ps_ear->port, (const uint8_t*)buffer, val);
}


//UARTSerial scom(PTC17, PTC16);//(PTC4, PTC3);//(PTC17, PTC16);

UARTSerial *pscom;


volatile uint8_t readbuff[1500];
volatile int totno=0; 
volatile int readflag = 0;
volatile int noreaded=0;

extern UARTSerial *pscom;
Thread thread_scomrx;
void scomrx_fun( void )
{
   while(true)
  {
    if( pscom->readable() )   
    {
        noreaded = pscom->read( (uint8_t *)(readbuff+totno), 1500);
        totno += noreaded;
        wait(0.01);     
    }
    else if(totno) 
    {
        printf("PRIJEM na rs232 com   totno = %d  \n\r", totno);   
        sendUdp( ps_ear, (char *)readbuff, totno); 
        totno = 0;      
    } 
  }
} 

Thread udpBroadcast_thread;
void udpBroadcast_fun( void )
{
    while(true)
    {
        sendUdp(  ps_eab, (char *)"test broadcast", 14);
        wait(5);
    }   
}

int main(void)
{
  
  printf("\n\r --------  POCETAK  ------------- \n\r");
 
  ethernet_setup( &s_net );
 
  UARTSerial _scom(PTC17, PTC16, 38400);   
  pscom = &_scom;
 
  thread_scomrx.start( scomrx_fun );
    
    /*
    TCPSocket socket;        
    socket.open(&eth);
    socket.connect(
    */
    
    if( (err = udpSocket.open( &eth ))  != NSAPI_ERROR_OK )  { printf(" greska otvaranja soketa %d \n\r", err);  return 1; }
    udpSocket.bind(ps_ear->port);

    int ret;

    char inbuff[1500];


    udpBroadcast_thread.start(udpBroadcast_fun);

    while(1)
   {
        printf("cekam prijem \n\r");

        SocketAddress sockAddr;
  
        int n = udpSocket.recvfrom(&sockAddr, &inbuff, sizeof(inbuff));
        printf(" primljeno = %d bajtova ",n);

          pscom->write( (const uint8_t*) inbuff, n );
    } 
}


void ethernet_setup( struct S_net *ps_net )
{
  //  if( (err = eth.disconnect()) != NSAPI_ERROR_OK )  { printf(" greska diskonekcije %d \n\r", err); return 1; } 
  //  ((NetworkInterface *)&eth)->set_network("192.168.1.11","255.255.255.0","192.168.1.1");
 
        if( (err = ps_net->p_eth->set_network(ps_net->ps_ea->ip, ps_net->ps_ea->mask, ps_net->ps_ea->gate))!= NSAPI_ERROR_OK )  { printf(" greska setovanja mreze %d \n\r", err);  } 
    
    
     if( (err = ps_net->p_eth->connect())  != NSAPI_ERROR_OK )  { printf(" greska konekcije %d \n\r", err);}
    
   
    
    printf( "MAC adresa: %s\n\r", ps_net->p_eth->get_mac_address() );
    printf( "IP adresa:  %s\n\r", ps_net->p_eth->get_ip_address() );
    printf( "net mask:   %s\n\r", ps_net->p_eth->get_netmask() );
    printf( "GW adresa:  %s\n\r", ps_net->p_eth->get_gateway() );
}



//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};