/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

#include "MiWiDrv.h"
#include "SerialCom.h"
// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    200

#define MINIMUM( A, B)  A<B ? A:B


DigitalIn b2(SW2);

//    DigitalOut led(LED1,1);
    DigitalOut ledB(LED3,1);
//  DigitalOut ledG(LED2,1);


char tx_niz[] = { 7,0,1,2,3, 4, 5 , 6, 7, 8};
char rx_niz[100];
int rx_br;

void consolafun( void );
Thread th_consola( consolafun );


int main()
{
    // Initialise the digital pin LED1 as an output
printf("\n\n\r ____________ POCETAK MiWI RX_______________\n\r");

    inic_MiWi( );
    



   setMiWimode( 3 );   //prijem
 
 
int b = b2;
 
   start_SerialCom( );   
   start_MiWiRx( );
   
    while (true) 
    {
         
        if( b!= b2)
        {
            b = b2;
        if( b ) {/*set_mode( 1 );*/ ledB = 1;}
        else    { /* ledB = 0; */txMiWi( tx_niz ); }
        }
 
        thread_sleep_for(BLINKING_RATE_MS);
    }
}



void consolafun( void )
{
    while( true )
    {
     
     char uc = getchar( );
     switch( (unsigned char) uc )
     {
         case 'r': case 'R':  
         
            printf("\n\rcitanje registra, unesi broj hex:\n\r");
            int r;
            scanf("%x", &r);
            printf( "\n\rregistar hex %x ima vrednost hex %x\n\r", r, readMiWiReg(r));
        
            break;
         case 'w': case 'W':  
         {
            printf("\n\rupis registra, unesi broj registra hex:");
            int r;
            scanf("%x", &r);
            printf( " %x", r );
            printf("\n\runesi vrednost registra hex:");
            int v;
            scanf("%x", &v);
            printf( " %x", v );
            printf( "\n\rregistar hex %x ima vrednost hex %x\n\r", r, readMiWiReg(r));
        }
            break;
        case 's': case 'S':
            printf("aktivacija serijala\n\r");
             start_SerialCom( );   
             break;
        case 'f': case 'F':
            printMiWiregs( );
            break;
     }
        
    }
}
