#include "MiWiApp.h"


#include "mbed.h"

#define MiWiADDRESS    0


const char _MIWI_DEV_CFG[ 32 ] = 
{
    0x20 | 0x10 | 0,   //0x08  //0x06,1
    0x80 | 0x04 | 0x00,
    0x04,
    0x07,
    0x0C,
    0xC0 | 0x02,
    0x77,
    95,     //0x64,
    1,      //0x32,
    0x74,
    0x62,
    0x32,  
    0x20 | 0x18,
    /*0xC0*/0x0 | 0x08,  //irq0=PLREADY  irq1=CRCOK  TXDONE
    0x20 | 0x09,   // TXDONE RSSI en, PLL en
    0x30, //0x00,  //// RSSI threshold = 50
    0xA0 | 0x03,
    0x08 | 0x30,
    0x20 | 0x18,
    0x7,      //0x07,  //reserved read only
    0,   //rssi read only
    0,   //  OOK config reg
    0x69,
    0x81,
    0x7E,
    0x96,
    0x78, //Tx polfv = 200KHz  Tx pow = 1dbm   ///0xF0,
    0,      //0x80,
    64,
    0x00,
    0x80 | 0x60 | 0x08, // variable packet, 4 byte preamble, CRC en
    0x00
};



SPI spi( PTD2, PTD3, PTD1 );
DigitalOut csdata( PTD0,1 );
DigitalOut csconfig( PTB2,1 );
DigitalOut MiWiReset( PTB11, 1 );

DigitalIn pin_irq0( PTB9 );
DigitalIn pin_irq1( PTC2 );



Mutex m;

char readMiWiReg( char reg )
{
 char c;
 m.lock();
   csconfig=0;
   spi.write( (reg)*2 + 0x40 );
   c = spi.write( 0 );
   csconfig = 1;
m.unlock();
   return c;
}
void writeMiWiReg( char reg, char data )
{
 char c;
 m.lock();
   csconfig=0;
   spi.write( (reg)*2 /*& ~0x40*/ );
   spi.write( data );
   csconfig = 1;
m.unlock();   
}

void writeMiWiData( char data )
{
 char c;
 m.lock();
   csdata=0;
   spi.write( data );
   csdata = 1;
m.unlock();
}
char readMiWiData( void )
{
 char c;
 m.lock();
   csdata=0;
   c = spi.write( 0x55 );
   csdata = 1;
m.unlock();
   return c;
}





void inic_MiWi( void )
{

   spi.format( 8, 0);
   spi.frequency(1000000);
   
   resetMiWi( );
   
   for(int i = 0; i<0x20; i++ )        writeMiWiReg(i, _MIWI_DEV_CFG[i]);   
   print_regs( );   

   lockPllMiWi( );
   printf("FTPRIREG = %x\n\r", readMiWiReg( 0xe));

}

void resetMiWi( void )
{
    MiWiReset = 1;   
    wait( 0.2 );
    MiWiReset = 0;
    wait( 0.1 );
}

void set_mode( char mode )
{
  union U_GCONFIG u_gc;
  u_gc.bajt = readMiWiReg( 0 );  // read GCONFIG
  u_gc.s_gc.CMOD = mode;
  writeMiWiReg( 0, u_gc.bajt );       // write  GCONFIG 
  printf("gconfig %x\n\r", readMiWiReg(0) );  
}
char get_mode( void )
{
  union U_GCONFIG u_gc;
  char c;
  u_gc.bajt = readMiWiReg( 0 );  // read GCONFIG
  c = u_gc.s_gc.CMOD;
  return c;  
}


void print_regs( void )
{
    
        char c;
        for(int i = 0; i<0x20; i++ )
        {              
            c = readMiWiReg(i);
            printf("%2x ", c );
        }
        printf(" irq0=%d  irq1=%d\n\r", pin_irq0.read(), pin_irq1.read() ); fflush(stdout);
}

void txMiWi( char *niz )
{
 char old_mode = get_mode();
  set_mode(1);
   for(int i=0; i<niz[0]; i++ )
  {
     writeMiWiData( niz[i] );   //  write FIFO
  }   
   set_mode( 4 );    //  predaja
    while( !(readMiWiReg( 0x0E ) & 0x20) );  // TXDONE ?
  set_mode( old_mode );
 //  wait(0.5);
//    printf("txdone = %x\n\r", readMiWiReg( 0x0E ));
//   printf("mode = %x\n\r", old_mode);  
//   printf("config = %x\n\r", readMiWiReg( 0 ));
   //      //  standby
}

char sendbuff[64];
void sendMiWi( char *buff, int len)
{
     sendbuff[0] = len+2; sendbuff[1]=MiWiADDRESS;
     
     memcpy((void*)&sendbuff[2], (void*)buff, len>62 ? 62:len );
      txMiWi( sendbuff );

}

bool lockPllMiWi( )
{
  char old_mode;
  
       union U_GCONFIG u;
       u.bajt = readMiWiReg( 0 );
       old_mode = u.s_gc.CMOD;

  set_mode(2);
       u.bajt = readMiWiReg( 0 );
  int i;
  for( i =0; i<4 ; i++)
  {
       u.s_gc.VCOT = i;
       writeMiWiReg( 0, u.bajt );
       wait(0.001 );

       printf("cofig[%d] = %x\n\r",i ,readMiWiReg( 0 )); 

       if( readMiWiReg( 0xe ) & 2 ) break;
   }
   set_mode( old_mode );
   if( readMiWiReg( 0xe ) & 2 ) return true;
   return false;

}

