/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <vector>

#include "Pinovi.h"
// #include "IOspiLed.h"
#include "ledControl.h"


// #include "IOgpiospi.h"
// #include "IOspitelegram.h"
#include "IOspiprotokol.h"

#include "ZeroCrossing.h"
#include "IOzcControl.h"


extern vector< S_logTelegram> s_log;





// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    200

DigitalOut ioTest(IO_TEST,0);

DigitalOut testPin(PTE24, 0 );


char verzija = 5;


DigitalIn b2(SW2);

DigitalOut ledB(LED3,1);




class C_data c_data;


C_ledControl c_ledControl(&c_data);//( &c_ledLight);

C_spiProtokol c_spiProtokol( &c_data, &c_ledControl );

C_zeroCrossing c_zeroCrossing( &c_data);
C_zeroCrossing& rc_zc = c_zeroCrossing;

C_zcControl c_zcControl( &c_zeroCrossing, &c_spiProtokol);

//DigitalOut pola( PTB20, 0);  //  test zero crossing ivica


Ticker test_RasaLed;
DigitalOut RasaLed(PTE0,1);

long t; int tz;
int v1, v2, v3, v4,v5,v6,f=0;
int time_delay = 0, time_flag=0;

int main()
{

    // Initialise the digital pin LED1 as an output

printf("\n\n\r ____________ POCETAK IOboard_______________\n\r");

s_log.resize(1000);
s_log.clear();

printf( " capacity %d max_size %d size %d\n\r", s_log.capacity(), s_log.max_size(), s_log.size());
test_RasaLed.attach_us([=]{ RasaLed = !RasaLed;}, 500000   );

/* postavljanje funkcija za komande i indikaciju sinhrono sa zero crossing-om */

        
        c_zeroCrossing.set_ontimeONfun( []()
            {
   //             testPin =! testPin;
              rc_zc.set_portOut(  c_data.get_command() );//   
              if( c_data.get_newcommand_flag() == true) {  time_delay = 1; t = (long)Kernel::get_ms_count(); }// vreme = time_delay * 20ms
              else if(time_delay) { time_delay--;   if( time_delay == 0 ) time_flag = 1; }
              else { c_data.set_messagge(); c_data.set_realIndication();}
             } 
        );
        c_zeroCrossing.set_ontimeOFFfun(  [](){ } );
        c_zeroCrossing.set_postponeONfun(  []()    // minimum mreze - rad sa indikacijama ispravnosti sijalica
            { 
                if(time_delay == 0 && (c_data.check_newcommand_flag()== false) )
                {
                    char p1 = rc_zc.get_portInMin();   // dva ocitavanja porta
                    wait_us(10);
                    char p2 = rc_zc.get_portInMin();
                    p1 &= p2;
                    c_data.set_pMin( p1 );  
                    c_data.set_indication();
                    c_data.set_corectness();
                    c_data.set_realIndication();

                    // ledB =!ledB; 
                    // static int i=0;
                    // if(i++ > 100) { i = 0; f = 1; 
                    //     v1 = c_data.pMin;
                    //     v2 = c_data.get_command(); 
                    //     v3 = c_data.get_indication();
                    //     }
                }
                else c_data.clear_pMin();
            } 
        );
        c_zeroCrossing.set_postponeOFFfun( []() // maximum mreze - rad sa neispravnim naponom - misem
            { 
                    static int i=0, j=0;
                if(time_delay == 0 && (c_data.check_newcommand_flag()== false))
                {    
                    ledB =!ledB; 
                    char p1 = rc_zc.get_portInMax(); // dva ocitavanja porta
                    wait_us(10);
                    char p2 = rc_zc.get_portInMax();
                    p1 |= p2;
                    v1 = c_data.set_pMax( v4 = p1 );      
                   c_data.set_faultVoltage();
                        v2 = c_data.get_command();
                        v3 = c_data.get_faultVoltage();
                    
                    if(time_flag)
                     {
testPin =! testPin;  
                         f = 1; time_flag--;
                        v1 = c_data.pMax;  
                         v6 = (long)Kernel::get_ms_count()-t;     
                     }
                }
                else c_data.clear_pMax();
                
            } );


int b = b2;
 
    /* konzolu napraciti kao klasu koja nasledjuje C_thread klasu */
    extern void consolafun( void );
    Thread th_consola;
    th_consola.start( consolafun);

    /* cekanje da se procita prva ispravna adresa  sa dip switch-a  */
    do       { ThisThread::sleep_for(10ms);;c_spiProtokol.inic_address( ); }
    while   ( c_data.get_address() == 0 );
                    printf(" adresa je = %d\n\r", c_data.get_address());

    //   postavljanje sopstvene adrese i prikaz na ledovima
    c_spiProtokol.set_myAddress(c_data.get_address());
    c_ledControl.set_colorTemplate_Green(); 
    c_ledControl.set_ledView(adresa);


    while (true) 
    {

/*        if(f==1)
        {
            f=0;
            printf( "det =    %x    %x   %x        %x    %d  vreme =  %d   %d\n\r", v1, v2, v3, v4, v5, v6, t);
        }
  */   

        if( b!= b2)
        {
            b = b2;
        if( b ) { ledB = 1;}
        else    { ledB = 0; //printf( " bitCount = %d, byteCount = %d\n\r", c_spiProtokol.get_bitCount(), c_spiProtokol.get_byteCount());  
                
                printf( " zerocrossing timer on = %d   off = %d \n\r", c_zeroCrossing.get_zcTimeON(), c_zeroCrossing.get_zcTimeOFF());
               // printf(" port in %x\n\r", rc_zc.s_portinMin.get_port() );
                printf(" adresa je = %d\n\r", c_data.get_address());
                }
        }
    
        c_spiProtokol.spi_monitor();


        thread_sleep_for(BLINKING_RATE_MS);
    }
}



void consolafun( void )
{
    while( true )
    {
        
     char uc = getchar( );
     switch( (unsigned char) uc )
     {
         case 'r': case 'R':  
         
            printf("\n\rcitanje registra, unesi broj:\n\r");
            int r;
            scanf("%x", &r);
   //         printf( "\n\rregistar %x ima vrednost %x\n\r", r, readMiWiReg(r));
        
            break;
         case 'w': case 'W':  
         {
            printf("\n\rupis registra, unesi broj registra:");
            int r;
            scanf("%x", &r);
            printf( " %x", r );
            printf("\n\runesi vrednost registra:");
            int v;
            scanf("%x", &v);
            printf( " %x", v );
  //          printf( "\n\rregistar %x ima vrednost %x\n\r", r, readMiWiReg(r));
        }
            break;
            case 's': case 'S':
       //        set_shiftspi_signal(  );
            break;
            
            case 'c':
                    s_log.clear();
            //break;
            case 'l':
                    printf( " capacity %d max_size %d size %d\n\r", s_log.capacity(), s_log.max_size(), s_log.size());
            break;
            case 'p':
            int i=1;
            if(s_log.size())
            {
                for( auto it = s_log.end()-1; it != s_log.begin(); it--)
                        printf( "%3d %s\n\r", i++, (*it).poruka);
                        auto it = s_log.begin();
                        printf( "%3d %s\n\r", i++, (*it).poruka );
            }
            break;
     }
     ThisThread::yield();   
      thread_sleep_for(100);
    }
}
