#include "ZeroCrossing.h"
#include "mbed.h"


#include "Pinovi.h"

// extern DigitalOut ledB;
// void ledOFF(void ){ ledB=1;};  void ledON(void) { ledB=0;}



InterruptIn zc( ZC_PIN );

DigitalOut dout6(PTB2, 1 );
DigitalOut dout5(PTB3, 1 );
DigitalOut dout4(PTB10, 1 );
DigitalOut dout3(PTB11, 1 );
DigitalOut dout2(PTC11, 1 );
DigitalOut dout1(PTC10, 1 );

// DigitalIn din1( PTC1, PullUp);
// DigitalIn din2( PTC2, PullUp);
// DigitalIn din3( PTC3, PullDown);
// DigitalIn din4( PTC4, PullUp);   // PROBLEM!!!!!
// DigitalIn din5( PTC8, PullDown);
// DigitalIn din6( PTC9, PullDown);

DigitalIn din6( PTC5, PullUp);
DigitalIn din5( PTC7, PullUp);
DigitalIn din4( PTC0, PullUp);
DigitalIn din3( PTC9, PullUp);   
DigitalIn din2( PTC8, PullUp);
DigitalIn din1( PTC1, PullUp);


/************************************************************************************************************************/

#define IB(b)   b?0:1   //invert bita
#define IB1(b)  ~b


void S_bitPortIn::portIn_refresh(  )    { d0 = din1; d1 = din2; d2 = din3; d3 = din4; d4 = din5; d5 = din6; d6 = d7 = 0;}

void S_bitPortOut::portOut_refresh( )    { dout1 = IB(d0); dout2 = IB(d1); dout3 = IB(d2); dout4 = IB(d3); dout5 = IB(d4); dout6 = IB(d5); }


/************************************************************************************************************************/


#define ZCtimeMeasurement( mtime )   t.stop(); unsigned int frct = t.elapsed_time().count(); if( frct > frc ) mtime = frct - frc; frc = frct; t.start();

// aktivacija postpone funkcije, mora da postoji pospone vreme, da bi se timer aktivirao
#define ATimer( atimer, atimerfun, atime)   \
    if( atime != 0 )   \
    atimer.attach_us([this](){ atimerfun();}, atime ); 


/* iniciranje vremena izvrsenja postponovane funkcije. Ako je bilo vreme 0, stavla je timeONOFF/2 - po defaultu, u suprotnom
   stavice se vreme postone_toutONOFFtime, koje su int atributi klase, i inicijalno su 0   */
#define POSTPONtime_initiate( ONOFF) \
{                                  \
    if( postpone_tout##ONOFF##time == 0 )   postpone_tout##ONOFF( time##ONOFF/2 );  \
    else postpone_tout##ONOFF( postpone_tout##ONOFF##time );  \
}


C_zeroCrossing::C_zeroCrossing( C_data *pc_data)
{
    this->pc_data = pc_data;

int *p;   

p = (int*)0x4004B0C8; // digital filter width register PTC
*p = *p | (10);   //  filter clocks number max 32

p = (int*)0x4004B0C4; // digital filter clock register PTC
*p = *p | (0<<12);   // 0 - bus clock 1 - lpo clock


p = (int*)0x4004B0C0; // digital filter enable register of PTC
*p = *p | (1<<12);   // filter enabled on pin PTC12

//   pasive filter jedino radi 

p = (int*)0x4004B030; // adresa control registra od PTC12
*p = *p | 0x10;   // pasive filter enabled

    /* handleri uzlazne i silazne ivice interrupt-a zero crossinga */
        zc.rise([this](){  ZCtimeMeasurement( timeOFF) ontime_toutONfun(); POSTPONtime_initiate(ON)  inc_zcCounter();});
        zc.fall([this](){  ZCtimeMeasurement( timeON)  ontime_toutOFFfun(); POSTPONtime_initiate(OFF) inc_zcCounter(); });

    // set_ontimeONfun( [](){ledOFF();} );
    // set_ontimeOFFfun(  [](){ledON();} );
    // set_postponeONfun( ([]() { ledON();   }) );
    // set_postponeOFFfun( []() { ledOFF();  } );

}

    void C_zeroCrossing::ontime_toutONfun( void) {  if( p_ontime_toutONfun != nullptr) p_ontime_toutONfun(); else {/*ledOFF();*/} }
    void C_zeroCrossing::ontime_toutOFFfun(void) {  if( p_ontime_toutOFFfun != nullptr) p_ontime_toutOFFfun(); else {/*ledON();*/} }

//  mora da postoji postone funkcija i postpone vreme da bi se funkcija izvrslia 
    void C_zeroCrossing::postpone_toutONfun( void) { if( (p_postpone_toutONfun !=nullptr) ) p_postpone_toutONfun(); /*else*//*{   ATimer( toutON, ledOFF, 10000 );}*/}
    void C_zeroCrossing::postpone_toutOFFfun( void) { if( (p_postpone_toutOFFfun !=nullptr) )p_postpone_toutOFFfun(); /*else*//*{ ATimer( toutOFF, ledON, 100000 );}*/}

    void C_zeroCrossing::postpone_toutON( unsigned int tim ) {  ATimer(toutON, postpone_toutONfun, tim )    }
    void C_zeroCrossing::postpone_toutOFF( unsigned int tim  ) {  ATimer(toutOFF, postpone_toutOFFfun, tim ) }



