#ifndef IOSPICONNECT_H
#define IOSPICONNECT_H

#include "IOgpiospi.h"
#include "SlaveSpi.h"

#include "IOspitelegram.h"

/******************************   C_spiConnect   ******************************************* */

class C_spiConnect:  /*public C_gpioSpi// */ public C_slaveSpi// public C_gpioSpi
{
    C_telegram c_tx, c_rx;
    char byteCount = 0;
    Timeout t_out;

    public:

  //  C_spiConnect( ): C_gpioSpi( PTD6, PTD7, PTD5){ byteCount = 0; clear_bitCount();  }
     C_spiConnect( /*PinName mosi, PinName miso, PinName clock*/);//: C_gpioSpi::C_gpioSpi{ PTD6, PTD7, PTD5};
   void spiByteTransfer( char *tx, char rx) override;

    void bytecountTimeout( void ){ t_out.attach( [this](){clear_byteCount();}, 100ms);}

    virtual void do_writeCommand( char writeCommand, char data) = 0;
    virtual char do_readCommand( char readCommand , char data)  = 0;

    char get_byteCount( void) {return byteCount;}
    void clear_byteCount( void ) { byteCount = 0;}

    void make_TxTelegram( char txcmnd, char rxcmnd, char data);
    char push_byte( char b );

    void set_myAddress( char a) { C_telegram::set_myAddress(a);}
    char get_myAddress( void) { return C_telegram::get_myAddress(); }

    void set_reset( bool r ) { c_tx.set_reset(r); }

// ako je zero crossing signal dobar (true) vracamo zero crossing bit u telegramu 0 (false nema greske - inverzna logika)
    void set_zeroCrossing( bool z ) {  c_tx.set_zeroCrossing( z==true? false: true ); } 


};
/************************************************************************* */





#endif