#include "IOspiConnect.h"
#include "mbed.h"
#include "IOspitelegram.h"


#include "Pinovi.h"



static DigitalOut tast(IO_TELEGRAM_TAS_PIN,0);


/******************************   C_spiConnect   ******************************************* */
    C_spiConnect::C_spiConnect( ):  /*C_gpioSpi()*/ C_slaveSpi() // C_gpioSpi()
    { byteCount = 0; clear_bitCount();  }

    void C_spiConnect::spiByteTransfer( char *tx, char rx)
     {  *tx = push_byte(rx);   }

    void C_spiConnect::make_TxTelegram( char txcmnd, char rxcmnd, char data)   
    {    c_tx.make_telegram( txcmnd, rxcmnd, data);   }

   char C_spiConnect::push_byte( char b )
   {
       char spiWriteData = 0x66;

       if(byteCount != 3 )  bytecountTimeout();
       
        if(!tast)
        {
            c_rx.set_byte(byteCount++, b);

            if(byteCount == 2)   // priprema adresnog bajta predajnog telegrama
            {
                c_tx.set_address( );
                spiWriteData = c_tx.get_byte( 0 );   // IOadresa
            }  
            else if(byteCount == 3)  // predajnog bajta komande read-a telegrama  
            {
                c_tx.set_readCommand(c_rx.get_readCommand());
                c_tx.set_writeCommand( 0 );
                spiWriteData = c_tx.get_byte( 1 );   // IOadresa
            }  
            else if(byteCount == 4)   // analiza celog predajnog telegrama
            {                                

loguj_telegram( "prijem  = ", c_rx.get_telegram() ); 

                    if( c_rx.check_sum() )   // provera ispravnosti
                    {
                        if( c_rx.check_addressValidy( ))   // da li je pojedinacna ili grupna adresa validna
                        {
                                if( c_rx.get_readCommand( ))  // da li ima upit za citanje ?
                                {
                                    if( !c_rx.check_groupAddressValidy() )  // ako ima, da li je pojedinacna adresa ispravna
                                    {
 
                                        // pakujemo odgovor na upit
                                        char readCommandResult =  do_readCommand( c_rx.get_readCommand(), c_rx.get_data() ); 
                                        c_tx.set_data( readCommandResult);   
                                        c_tx.set_sum();            
                                        spiWriteData = c_tx.get_data();   
                                        tast = 1;

loguj_telegram( "priprema predaje = ", c_tx.get_telegram() ); 

                                    }
                                    else c_rx.do_readGroupCommand( c_rx.get_readCommand() ); 
                                } // treba vremenska zastita tastovanja !!!

                                if( c_rx.get_writeCommand() )    // da li ima upis ?
                                            do_writeCommand( c_rx.get_writeCommand(), c_rx.get_data() );
                        }
                   }
                    else { byteCount = 0;  clear_bitCount(); loguj_poruku((const char*)"checksum wrong\n\r"); }

                byteCount = 0;
            }  // buteCount == 4
            else if(byteCount > 4 )  { byteCount = 0; clear_bitCount(); loguj_poruku((const char*)"broj bajtova > 4\n\r");}

        }
        else   /* Predaja tast = 1  */
        {
            if( byteCount++ == 0 )    spiWriteData = c_tx.get_byte( 3 ); // byteCount krenuo od nule
            else
            {
                spiWriteData = 0x0;
             
                if(byteCount > 3)      
                { 
                    tast = 0; 
//                    spiWriteData = 0x7;                
                    byteCount = 0;
    loguj_telegram( "predaja = ", c_tx.get_telegram() );            
                }
            }
        }

        

   //     loguj_string_broj( "predajni bajt:", spiWriteData);
        return spiWriteData;
   }

/************************************************************************* */
