#ifndef SLAVESPI_H
#define SLAVESPI_H


#include "mbed.h"
#include "Pinovi.h"
#include "ClassThreadAbstract.h"

//typedef void (*pf_pc_c)(char* tx, char rx);

//static DigitalOut ledG(LED2,1);
//static DigitalOut ledC(LED1,1);

static DigitalOut _CS( SpiSel_out,1);


typedef void (*pfv)(void);

#define _SPI_BASE   SPI1_BASE
#define _SPI_IRQn   SPI1_IRQn


static char readData, writeData=0x7e;
static volatile char _transferFlag;// = false;

static EventFlags ef;


class C_slaveSpi: public SPISlave
{

public: 


    static int spiReadRegister( int ar ){    return *(int*)( _SPI_BASE +  ar);}
    static void spiWriteRegister( int ar, int d ){    *(int*)( _SPI_BASE + ar) = d;}

    static void inic_slaveSpi( void )
    {
        NVIC_DisableIRQ( _SPI_IRQn );  
        _CS = 1;
        wait_us(10);
        _CS = 0;
            spiWriteRegister(0, spiReadRegister(0) | 0x3c00);   /* 0x00000C00 = ciscenje rx i tx buffer-a*/
        //!    spiWriteRegister(0x2c, spiReadRegister(0x2c) | 0x80000000);  /* TCF clear */
        //!    spiWriteRegister(0x30, spiReadRegister(0x30) | 0x80000000);  /* transfer interrupt enable */

         spiWriteRegister(0x34, writeData);  /* data for transmit */  
     }

    static void ff(void )
    {
        if( ( spiReadRegister(0x2c)) & 0x80000000 )
        {
            spiWriteRegister(0x2c, spiReadRegister(0x2c) | 0x80000000);
            readData = spiReadRegister(0x38);   /* data register read */
        spiWriteRegister(0x34, writeData);  /* data for transmit */    
    
        
        _transferFlag = 1;
        ef.set(1);
        }

    //   else { ledG =! ledG; inic_slaveSpi(  );  set_slaveSpiInterrupt(ff);}
    // ledC =! ledC;
    //    spiByteTransfer( &writeData, readData );
    }

    static void set_slaveSpiInterrupt( pfv p_fun )
    {
        NVIC_SetVector( _SPI_IRQn, (int)p_fun );   // varijanta sa static ff()
        NVIC_EnableIRQ( _SPI_IRQn );  

    }

// class C_slaveSpi: SPISlave, C_thread
// {
    private:

        char bitCount = 0;
    Thread *p_t;


    void (*pfv) (void);
    void spiClockCount_fun(void);
 
   Callback<void(void)> cbfun;

    public:

    C_slaveSpi(  ):  SPISlave(Mosi, Miso, SpiClock, SpiSel ) 
    {
   //     transferFlag = false;
  
        inic_slaveSpi(  );
        format(8,3);
        set_slaveSpiInterrupt( ff );

        p_t = new Thread( osPriorityAboveNormal, 1000 );
        p_t->start( [this](){thread_fun();} );

    //    cbfun = &(this->clear_bitCount);
    }
 //   void attach( pf_pc_c fun) { transfer_fun = fun;}
    virtual void spiByteTransfer( char * tx, char rx) =0;
    void thread_fun( void ) 
    {
extern volatile char _transferFlag;
        while( true )
        {
 //           ledC =! ledC;
           // if( _transferFlag )
           while(ef.wait_any(1) )
            {
      //          ledC =! ledC;
                spiByteTransfer(&writeData, readData);
 //printf(" %x %x \n\r",readData, writeData);
                _transferFlag = 0;
           }
        }
    }



    char get_bitCount( void ) { return bitCount;}
    void clear_bitCount( void ) { /*ledG =! ledG;*/ 
    bitCount = 0; 
    inic_slaveSpi(  );  
    set_slaveSpiInterrupt(ff);
    }

    void spi_monitor( void ){};

};



#endif
