#ifndef IOSPITELEGRAM_H
#define IOSPITELEGRAM_H

//#define Adresa  1

union S_logTelegram
{
    char poruka[100];
};



void loguj_telegram( const char* opis, const char *niz );
void loguj_poruku( const char *p );
void loguj_broj( int i);
void loguj_string_broj( char *s,int i);

class C_telegram
{
    static char myAddress;
    union
    {
        struct
        {
            struct //S_address
            {
                unsigned char address :6;
                unsigned char zero_crossing: 1;
                unsigned char reset: 1;
            };
            struct
            {
                unsigned char cmd_read: 4;
                unsigned char cmd_write: 4;
            };
            unsigned char data;
            unsigned char sum;
        };
        unsigned char niz[4];
    };

    char calc_sum( void )  { return niz[0]+niz[1]+niz[2]; }
    public:

    static void set_myAddress( char a ) { myAddress = a; }
    static char get_myAddress( void ) { return myAddress; }

    C_telegram( );
    bool check_addressValidy( void );
    bool check_groupAddressValidy( void );

    void set_reset( bool r ) { reset = r; }

    void set_zeroCrossing( bool z ) { zero_crossing = z; }


    virtual void do_writeCommand( const char command, const char data) {}
    virtual char do_readCommand( const char command){ return 0;}
    virtual void do_readGroupCommand( const char command){ }

    char get_address( void ) {       return address;}
    void set_address( void ) { address = myAddress;}

    char get_readCommand() { return cmd_read;}
    void set_readCommand( char cmd ) { cmd_read = cmd; }

    char get_writeCommand() { return cmd_write;}
    void set_writeCommand( char cmd ) { cmd_write = cmd; }

    void set_data( char d ) { data = d;}
    char get_data( void ) { return data; }

    void set_sum( void ) { sum = calc_sum();}
    char get_sum( void ) { return sum;}
    bool check_sum( void ) { return (sum == calc_sum()) ? true: false;}


    const char *get_telegram( void );
    const char * make_telegram( char cmd_write, char cmd_read, char data );
    
    void set_byte( int i, char c)    { if( i >=0 && i < 4) niz[i] = c;  }
    char get_byte( int i)    { return niz[i];  }
}; 


#endif
