
#include "mbed.h"
#include <vector>

//#include "thread_class.h"
#include "IOspitelegram.h"
#include "Pinovi.h"


/*
  ok  - inicijalni test set telegram
  ok  - povezati sa spibyte
  odustao  - uneti thread u class-u
 */



vector< S_logTelegram> s_log;

void loguj_telegram( const char* opis, const char *niz )
{
    S_logTelegram s_l;
    sprintf(s_l.poruka,"%s %10ld    %2x %2x %2x %2x", opis, (long)Kernel::get_ms_count(), niz[0], niz[1], niz[2], niz[3]);

    if( s_log.size() < 150 )
    {
     // u_log.push_back( u_l);
       s_log.insert(s_log.begin(), s_l);
    }
}
void loguj_poruku( const char *p )
{
    S_logTelegram s_l;
    memcpy(s_l.poruka, p, strlen(p) );

    if( s_log.size() < 150 )
    {
       s_log.insert(s_log.begin(), s_l);
    }
}

void loguj_broj( int i)
{
    S_logTelegram s_l;
    sprintf(s_l.poruka," %10ld %x", (long)Kernel::get_ms_count(), i );

    if( s_log.size() < 150 )
    {
     // u_log.push_back( u_l);
       s_log.insert(s_log.begin(), s_l);
    }

}

void loguj_string_broj( char *s,int i)
{
    S_logTelegram s_l;
    sprintf(s_l.poruka,"%s %10ld %x", s, (long)Kernel::get_ms_count(), i );

    if( s_log.size() < 150 )
    {
     // u_log.push_back( u_l);
       s_log.insert(s_log.begin(), s_l);
    }

}

/**************************************   C_telegram   ************************************************ */
    
    C_telegram::C_telegram(  )      
    {   
        reset = 1;          //  desio se reset
        zero_crossing = 1;  //  zero crossing po resetu dobar, by default;  Ovo je sporno ???/
        cmd_read = cmd_write = data = 0; 
    }

    bool C_telegram::check_addressValidy( void ) { return (( myAddress == (unsigned char)address)||(niz[0]==BROADCASTADDRESS)) ? true : false; }
    bool C_telegram::check_groupAddressValidy( void ) { return (niz[0]==BROADCASTADDRESS) ? true : false; }

    const char *C_telegram::get_telegram( void ) { return (char*)niz; }
    const char * C_telegram::make_telegram( char cmd_write, char cmd_read, char data )
    {
        this->address = myAddress;
        this->cmd_read = cmd_read;
        this->cmd_write = cmd_write;
        this->data = data;
        set_sum();
        return get_telegram();
    }

    char C_telegram::myAddress = 1;
/************************************************************************* */
