#ifndef LEDCONTROL_H
#define LEDCONTROL_H

#include "LedLight.h"
#include "IOdata.h"
//#include <functional>


#define NO_BULB 6


enum E_blinkPatern { offBlink, onBlink, faultBlink, mouseBlink};

enum E_ledView { jednokratni_prikaz, komanda, indikacija, ispravnost, mis, poruka, validnost, podatak, adresa, aktuelna_indikacija};

    union U_ledBulb
    {
        struct
        {
            char color: 2;
            char led: 3;
            char bulb: 3;
        };
        char command;
    };

class C_ledControl: public C_ledLight
{
    char bulb[NO_BULB] = {1, 2, 3, 4, 5, 6};
//    char fault, mouse;

    C_data *pc_data;

    volatile E_ledView e_ledView = jednokratni_prikaz;

    E_ledColor e_colorTemplate[NO_LED] = { ledOff, ledOff, ledOff, ledOff, ledOff, ledOff };


    void apply_colorTemplate( const E_ledColor *p_lcniz);
    void set_ledBlinker( char no, const E_blinkPatern bp );
    void insert_ledInColorTemplate( char noled, E_ledColor c);

public:

    C_ledControl( C_data *pc_data ) { this->pc_data = pc_data; }; 

    void set_byte( char b ){ set_ledLightByte( b); }


    void set_ledView( E_ledView e ) { e_ledView = e; }
    E_ledView get_ledView( void ) {return e_ledView;}

    void unpack_ledBulb( char b );
    void clear_ledBulbTable( void ); 
    void execute_indications( char indication );


    void set_colorTemplate( void ) {apply_colorTemplate( e_colorTemplate);}
    void set_colorTemplate_Red( void );
    void set_colorTemplate_Green( void );
    void set_colorTemplate_Yellow( void );
    void set_colorTemplate_Example( void );

    void set_led( char no ) { set_ledBlinker( no, onBlink );}            /* paljenje leda */
    void res_led( char no ) { set_ledBlinker( no, offBlink );}          /* gasenje leda */
    void fault_led( char no ) { set_ledBlinker( no, faultBlink );}      /* blinkanje neispravne sijalice */
    void mouse_led( char no ) { set_ledBlinker( no, mouseBlink );}      /* blinkanje misa  */
    void set_ledPort( char port ) { set_ledLightByte(port);}            /* ukljucenje celog porta da stabilno svetli */

    // void set_fault( char bit ) { fault |= bit;}
    // void res_fault( char bit ) { fault &= ~bit;}
    // void clear_faults( void ) { fault = 0;}

    // void set_mouse( char bit ) { mouse |= bit;}
    // void res_mouse( char bit ) { mouse &= ~bit;}
    // void clear_mouses( void ) { mouse = 0;}



// pregazi refreash iz C_ledLight, izvrsava se u ugradjenom threadu u C_ledLight

    void _refresh( void ) override
    {
         //  DigitalOut ledG(LED2,1);

        while( true )
        { 
             pc_data->set_address( (/*C_spiled::*/get_received()>>8) & 0x0f);
           // ledG = 0;
 //          if(pf != nullptr)   { pf(); ledG = ! ledG; }
            if( e_ledView == komanda )  { set_ledPort(pc_data->get_command_uncut());  }
            else if( e_ledView == indikacija )  { set_ledPort(pc_data->get_indication());  }
            else if( e_ledView == ispravnost )  { set_ledPort(pc_data->get_correctness());  }
            else if( e_ledView == mis )  { set_ledPort(pc_data->get_faultVoltage());  }
            else if( e_ledView == poruka )  { set_ledPort(pc_data->get_message());  }
           else if( e_ledView == validnost )  { set_ledPort(pc_data->get_validity());  }
           else if( e_ledView == podatak )  { set_ledPort(pc_data->get_data());  }
           else if( e_ledView == adresa )  { set_ledPort(pc_data->get_address());  }

            else if( e_ledView == aktuelna_indikacija   ) execute_indications( pc_data->get_raelIndication() );  
            
       //     else ledG = 1;
           C_ledLight::_refresh();
        }
    }

};


#endif