#include "ledControl.h"


    const E_ledColor e_colorTemplateRed[NO_LED] = { ledRed, ledRed, ledRed, ledRed, ledRed, ledRed };
    const E_ledColor e_colorTemplateGreen[NO_LED] = { ledGreen, ledGreen, ledGreen, ledGreen, ledGreen, ledGreen };
    const E_ledColor e_colorTemplateYellow[NO_LED] = { ledYellow, ledYellow, ledYellow, ledYellow, ledYellow, ledYellow };
    const E_ledColor e_colorTemplateExample[NO_LED] = { ledRed, ledRed, ledYellow, ledGreen, ledRed, ledGreen };

    void C_ledControl::set_colorTemplate_Red( void ) {apply_colorTemplate( e_colorTemplateRed);}
    void C_ledControl::set_colorTemplate_Green( void ) {apply_colorTemplate( e_colorTemplateGreen);}
    void C_ledControl::set_colorTemplate_Yellow( void ) {apply_colorTemplate( e_colorTemplateYellow);}
    void C_ledControl::set_colorTemplate_Example( void ) {apply_colorTemplate( e_colorTemplateExample);}

    void C_ledControl::apply_colorTemplate( const E_ledColor *p_lcniz)
    {
        apply_ledColorTemplate(p_lcniz);
    }
    void C_ledControl::set_ledBlinker( char no, const E_blinkPatern bp )
    { 
        switch( bp )
        {
            case offBlink:  set_ledLightTickPatern(no, 0); break;
            case onBlink:   set_ledLightTickPatern(no, 0xff); break; 
            case faultBlink:   set_ledLightTickPatern(no, 0x72); break;
            case mouseBlink:   set_ledLightTickPatern(no, 0x0f); break;
        }
    }


    void C_ledControl::insert_ledInColorTemplate( char noled, E_ledColor c)
    {
        if( noled < NO_LED ) e_colorTemplate[noled] = c; 
    }

    
    void C_ledControl::unpack_ledBulb( char b )
    {
        U_ledBulb u;
        u.command = b;
        insert_ledInColorTemplate(u.led, (E_ledColor)u.color);
//        e_colorTemplate[u.led] = (E_ledColor) (u.color);
        if( (u.bulb < NO_BULB) && (u.led < NO_LED)) 
        {    
            bulb[u.bulb] = u.led+1;
//            pc_data->set_validity((pc_data->get_validity()) | (1<<u.bulb));  // AKTIVIRATI NAKNADNO
        }
    }
    void C_ledControl::clear_ledBulbTable( void ) 
    {
        for(int i=0; i<NO_LED; i++)  
        {
            insert_ledInColorTemplate( i, ledOff );
           // e_colorTemplate[i] = ledOff;
        }
        for(int i=0; i<NO_BULB; i++)  
        {
            bulb[i] = 0xff;
        }
//        pc_data->set_validity(0);    // AKTIVIRATI NAKNADNO
    }
    void C_ledControl::execute_indications( char indication)
    {
        for( char i=1, j=0; j<NO_BULB; i<<=1, j++ )
        {
            if( pc_data->get_faultVoltage() & i )   mouse_led( bulb[j]);
            else if( (~(pc_data->get_correctness())) & i )  fault_led( bulb[j]);        
            else if(pc_data->get_indication() & i) set_led( bulb[j] );
            else            res_led( bulb[j] );
        }
    }


