#include "LedLight.h"
#include "ClassThreadAbstract.h"

#include "mbed.h"

#include "Pinovi.h"

// DigitalOut led(LED1,3);

/**************************************   class C_spi   ******************************************* */
    C_spi::C_spi( PinName mosi, PinName miso, PinName sclk, PinName pin_csdata ): SPI( mosi,  miso,  sclk)  //SPI( PTD2, PTD3, PTD1 )
    {
        p_csdata = new DigitalOut( pin_csdata,1);
         format( 16, 0);
         frequency(10000000);
    }
    unsigned short C_spi::transfer( unsigned short tx )
    {
  //  led = 0;
        *p_csdata = 0;
        *p_csdata = 1;
        unsigned short rx = write( tx ); 
        *p_csdata = 0;
        *p_csdata = 1;
//    led = 1;
    return rx;
    }
/********************************************************************************** */



/********************************************************************************** */


//    C_spiled::C_spiled():C_spi(  PTD2, PTD3, PTD1, PTC4)//, C_thread()
    C_spiled::C_spiled():C_spi(  Led_mosi, Led_miso, Led_sclk, Led_cs)//, C_thread()
    {
 
    }

    void C_spiled::do_Sifter( void )    
    {  
        sifter = u_ledovi.ledovi<<2;          
        received = transfer(sifter);   
    }

    void C_spiled::set_led( char no, E_ledColor ct )
    {
        switch( no )
        {
            case 1: u_ledovi.ledpar1 = ct; break;
            case 2: u_ledovi.ledpar2 = ct; break;
            case 3: u_ledovi.ledpar3 = ct; break;
            case 4: u_ledovi.ledpar4 = ct; break;
            case 5: u_ledovi.ledpar5 = ct; break;
            case 6: u_ledovi.ledpar6 = ct; break;
        }
    }
    E_ledColor C_spiled::get_led( char no )
    {
      E_ledColor ct;
        switch( no )
        {
            case 1: ct = (E_ledColor)u_ledovi.ledpar1; break;
            case 2: ct = (E_ledColor)u_ledovi.ledpar2; break;
            case 3: ct = (E_ledColor)u_ledovi.ledpar3; break;
            case 4: ct = (E_ledColor)u_ledovi.ledpar4; break;
            case 5: ct = (E_ledColor)u_ledovi.ledpar5; break;
            case 6: ct = (E_ledColor)u_ledovi.ledpar6; break;
        }
        return ct;

    }

/********************************************************************************** */

// refresh beskonacna funkcija se poziva u C_threadu
   

    C_ledLight::C_ledLight(  ) { }
    C_ledLight::C_ledLight( int stack ):C_thread( stack) { }

    void C_ledLight::set_ledLight( char no, E_ledColor c, char t) 
    { 
        if( no && no<=NO_LED ) {s_ledLight[no-1].ct = c; s_ledLight[no-1].tickPatern= t; }
    }

    void C_ledLight::set_ledLight( char no, E_ledColor c ) { if( no && no<=NO_LED ) {s_ledLight[no-1].ct = c;} }
    void C_ledLight::set_ledLightTickPatern( char no, char t ) { if( no && no<=NO_LED ) {s_ledLight[no-1].tickPatern = t;} }
//    void set_ledLight( char no, bool on ) { if( no && no<=NO_LED ) {s_ledLight[no-1].tickPatern = ((on==true) ? 0xff : 0);} }
    void C_ledLight::set_ledLightByte( char Port ) 
    { 
        for( char i=0, j=1; i<NO_LED; i++, j<<=1 ) { s_ledLight[ i ].tickPatern = ((Port & j) ? 0xff : 0); } 
    }


    S_ledLight C_ledLight::get_ledLight( char no ) { return s_ledLight[no-1];}
    char C_ledLight::get_ledLightTickPatern( char no ) { return s_ledLight[no-1].tickPatern;}
    E_ledColor C_ledLight::get_ledLightColor( char no ) { return s_ledLight[no-1].ct;}

    void C_ledLight::apply_ledColorTemplate( const E_ledColor *e_ct )
    {
        for( int i = 0; i<NO_LED; i++)  s_ledLight[i].ct = e_ct[i];
    }

    void C_ledLight::_refresh( void)
    {    
               static char j=1;
            
             set_led( 1,  (E_ledColor)( (get_ledLightTickPatern(1) & j) ? ((get_ledLightColor(1))) : 0 ) );
             set_led( 2,  (E_ledColor)( (get_ledLightTickPatern(2) & j) ? ((get_ledLightColor(2))) : 0 ) );
             set_led( 3,  (E_ledColor)( (get_ledLightTickPatern(3) & j) ? ((get_ledLightColor(3))) : 0 ) );
             set_led( 4,  (E_ledColor)( (get_ledLightTickPatern(4) & j) ? ((get_ledLightColor(4))) : 0 ) );
             set_led( 5,  (E_ledColor)( (get_ledLightTickPatern(5) & j) ? ((get_ledLightColor(5))) : 0 ) );
             set_led( 6,  (E_ledColor)( (get_ledLightTickPatern(6) & j) ? ((get_ledLightColor(6))) : 0 ) );

             do_Sifter();

            if( !(j<<=1) ) j = 1;
            
            ThisThread::sleep_for(125ms);   

   }
   
//     void C_ledLight::refresh( void)
//     {    

//         // set_ledLight(0, ledRed, 0xff);
//         // set_ledLight(2, ledGreen, 0b01110010);

// //         apply_ledColorTemplate(e_colorTemplate);
// // set_ledLightTickPatern(3, 0xf);


//  //       set_ledLight(3, ledOff);

//         //set_ledLightByte(0x1f);

//         while(true)
//         {
           
//  _refresh();

// //printf(" max_stack %d  ratio %d\n\r", get_max_stack(), get_stack_ratio());
                 
//         }
//     }

 


