#ifndef CLASSTHREADABSTRACT_H
#define CLASSTHREADABSTRACT_H

#include "mbed.h"

class C_thread
{
    Thread *p_t;
    public:

    C_thread(  )
    {
        p_t = new Thread( osPriorityNormal, 1000 );
        p_t ->start( [this](){thread_fun();});
    }
    C_thread(  uint32_t s  )
    {
        p_t = new Thread( osPriorityNormal, s);
        p_t ->start( [this](){thread_fun();});
    }
    C_thread( osPriority_t p, uint32_t s  )
    {
        p_t = new Thread( p, s);
        p_t ->start( [this](){thread_fun();});
    }
    virtual void thread_fun( void ) = 0;

    int get_max_stack( void ) { return p_t->max_stack();}
    int get_stack_ratio( void )  { return p_t->max_stack() * 100 / p_t->stack_size();}
};




#endif
