#ifndef LEDLIGHT_H
#define LEDLIGHT_H

#include "mbed.h"
#include "ClassThreadAbstract.h"


#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"
#define BYTE_TO_BINARY(byte)  \
  (byte & 0x80 ? '1' : '0'), \
  (byte & 0x40 ? '1' : '0'), \
  (byte & 0x20 ? '1' : '0'), \
  (byte & 0x10 ? '1' : '0'), \
  (byte & 0x08 ? '1' : '0'), \
  (byte & 0x04 ? '1' : '0'), \
  (byte & 0x02 ? '1' : '0'), \
  (byte & 0x01 ? '1' : '0') 
//  printf("Leading text "BYTE_TO_BINARY_PATTERN, BYTE_TO_BINARY(byte));
  //      printf(" leading text"BYTE_TO_BINARY_PATTERN" "BYTE_TO_BINARY_PATTERN"\n\r", j, BYTE_TO_BINARY(byte>>8),BYTE_TO_BINARY(byte) );




/******************************  class C_spi   ***************************************** */
//extern DigitalOut led;
class C_spi: public SPI
{
    DigitalOut *p_csdata;
public:

     C_spi( PinName mosi, PinName miso, PinName sclk, PinName pin_csdata ); 
     unsigned short transfer( unsigned short tx );

};

/*********************************  class C_spiled  ********************************************* */
#define NO_LED 6

enum E_ledColor { ledOff, ledRed, ledGreen, ledYellow};

union U_ledovi 
{
    unsigned short ledovi =0;
    struct 
    {
        char ledpar1 : 2;
        char ledpar2 : 2;
        char ledpar3 : 2;
        char ledpar4 : 2;
        char ledpar5 : 2;
        char ledpar6 : 2;
    };
};



class C_spiled: public C_spi
{
    unsigned short sifter;
    U_ledovi u_ledovi;
    unsigned short received;
    public:

    C_spiled();

    void do_Sifter( void );
    unsigned short get_received( void ){ return received;};

    void set_led( char no, E_ledColor ct );

    E_ledColor get_led( char no );

 };

/*************************  C_ledLight  ***************************** */

// stuktura svakog pojedinacnog led-a: boja i binarni tickPatern  tj, ako je patern 10101010 znaci blinkanje 4 puta u ciklusu, ili 11001100 bva puta u ciklusu 
struct S_ledLight { E_ledColor ct; char tickPatern; };


// klasa osvezavanja prikaza funkcija. Aktivira sopstveni C_thread i periodicno salje novo stanje ledova 

class C_ledLight : public  C_thread, public C_spiled
{
    char tickCounter =1;
    S_ledLight s_ledLight[NO_LED] = {{ledOff,0},{ledOff,0},{ledOff,0},{ledOff,0},{ledOff,0},{ledOff,0}};
 
    public:

virtual void _refresh( void);
   
     void thread_fun(void) override { _refresh(); }
 
    C_ledLight(  );// { }
    C_ledLight( int stack );//:C_thread( stack) { }

    void set_ledLight( char no, E_ledColor c, char t); 

    void set_ledLight( char no, E_ledColor c );
    void set_ledLightTickPatern( char no, char t );
//    void set_ledLight( char no, bool on ) { if( no && no<=NO_LED ) {s_ledLight[no-1].tickPatern = ((on==true) ? 0xff : 0);} }
    void set_ledLightByte( char Port ); 


    S_ledLight get_ledLight( char no );
    char get_ledLightTickPatern( char no );
    E_ledColor get_ledLightColor( char no );

    void apply_ledColorTemplate( const E_ledColor *e_ct );

  


};






#endif
