#include "IOgpiospi.h"

#include "Pinovi.h"
/*************************************************************************************************************************************** */
//   mosi = PTD6, miso = PTD7, clock = PTD5



C_gpioSpi::C_gpioSpi( /*PinName Mosi, PinName Miso, PinName spiClock*/)
{
    p_MOSI = new DigitalIn( Mosi, PullUp);
    p_MISO = new DigitalOut( Miso, 1);
    p_SpiClock = new InterruptIn( SpiClock, PullUp);
     

     
     bitCount = 0;
    p_SpiClock->fall( [this](){ spiClockCount_fun(); } );
}

void C_gpioSpi::spi_monitor( void )
{
    static char old_bit=0;
    if( old_bit && bitCount && (old_bit == bitCount) ) { bitCount=0;}
    old_bit = bitCount;

}

void C_gpioSpi::spiClockCount_fun(void)
{

   bitCount++;

    readData <<= 1;
    if( p_MOSI->read() )  readData |= 1;
    else readData &= (~1);

    if( writeData & 0x80 ) p_MISO->write(1);
    else p_MISO->write(0);
    writeData <<= 1;

    if(bitCount>=8) 
    {
        bitCount = 0;
 //       if(transfer_fun) transfer_fun( &writeData, readData );



        spiByteTransfer( &writeData, readData);
     
    }

 }



