#ifndef ZEROCROSSING_H
#define ZEROCROSSING_H

#include "mbed.h"

#include "IOdata.h"

/************************ port clase ***************************/
struct S_bitPortIn
{
    union
    {
        struct
        {
            char d0: 1; char d1: 1; char d2: 1; char d3: 1; char d4: 1; char d5: 1; char d6: 1; char d7: 1;
        };
        char port;
    };
    public:
    void portIn_refresh( void );
    char get_port( void ) { portIn_refresh( ); return port;}
};
struct S_bitPortOut
{
    union
    {
        struct
        {
            char d0: 1; char d1: 1; char d2: 1; char d3: 1; char d4: 1; char d5: 1; char d6: 1; char d7: 1;
        };
        char port;
    };
    public:
    void set_port( char port ) { this->port = port; portOut_refresh(); }
    void portOut_refresh(  );
};

class C_zeroCrossing
{
   Timer t;                 // timer meri vreme trajanja zero crossing impulsa
   
   int zcCounter = 0;     // brojac zero crossing impulsa 
   void inc_zcCounter( void )  { zcCounter ++; }


   unsigned int frc;     // free running counter za merenje vremena trajanja impulsazero crossinga
   unsigned int timeON, timeOFF;         // vreme trajanja nivoa ON i OFF zero crossinga u mikrosekundama
    Timeout toutON, toutOFF;
    void toutONfun( void);      // obavezna funkcija uzlazne ivice, meri trajanje 0 zero crossinga
    void toutOFFfun(void);      // obavezna funkcija silazne ivice, meri trajanje 1 zero crossinga

    void (*p_ontime_toutONfun)(void) = nullptr ;  // pointer na korisnicku funkciju uzlazne ivice
    void ontime_toutONfun(void);  // korisnicka funkcija uzlazne ivice
    void (*p_ontime_toutOFFfun)(void) = nullptr ;  // pointer na korisnicku funkciju silazne ivice
    void ontime_toutOFFfun(void) ; //   korisnicka funkcija silazne ivice


    void (*p_postpone_toutONfun)(void);  // odlozena korisnicka funkcija od uzlazne ivice 
    void postpone_toutONfun(void);  // odlozena korisnicka funkcija od uzlazne ivice 
    int postpone_toutONtime = 0;        // odlaganje u mikrosekundama
    void postpone_toutON( unsigned int tim );// {  toutON.attach_us( [this](){postpone_toutONfun();}, postpone_toutONtime );   }

    void postpone_toutOFFfun(void);   // odlozena korisnicka funkcija silazne ivice
    void (*p_postpone_toutOFFfun)(void);   // odlozena korisnicka funkcija silazne ivice
    int postpone_toutOFFtime = 0;       // vreme odlaganja u mikrosekundama
    void postpone_toutOFF( unsigned int tim );// {  toutOFF.attach_us( [this](){postpone_toutOFFfun();}, postpone_toutOFFtime );}

     S_bitPortOut s_portout;
     S_bitPortIn s_portinMin, s_portinMax;

public:


    C_data *pc_data;


    C_zeroCrossing( C_data *);

    int get_zcCounter( void ) { int temp = zcCounter; zcCounter = 0; return temp;}

    int get_zcTimeON( void ) {return timeON;}
    int get_zcTimeOFF( void ) {return timeOFF;}

    void set_ontimeONfun( void (*pf)(void))  {p_ontime_toutONfun = pf;}
    void set_ontimeOFFfun( void (*pf)(void))  {p_ontime_toutOFFfun = pf;}

    void set_postponeONfun( void (*pf)(void))  {p_postpone_toutONfun = pf;}
    void set_postponeOFFfun( void (*pf)(void))  {p_postpone_toutOFFfun = pf;}

    void set_portOut( char data ) { s_portout.set_port(data);}
    char get_portInMin( void )  { return s_portinMin.get_port();}
    char get_portInMax( void )  { return s_portinMax.get_port();}
};



#endif