#ifndef IOZCCONTROL_H
#define IOZCCONTROL_H

#include "ZeroCrossing.h"
#include "IOspiprotokol.h"


#define LOWER_THEN( val, max)   (val < max ? true : false)
#define HIGHER_THEN( val, min)  (val > min ? true : false)
#define IN_RANGE( val, min, max) (LOWER_THEN( val, max ) && HIGHER_THEN(val, min)) ? true : false 

#define CHECK_PERIOD 1000000 // 1S = 1.000.000 uS
#define LOW_FREQ   40  // Hz
#define HIGH_FREQ  70


#define NO_IMP_MAX (HIGH_FREQ * 2 * CHECK_PERIOD / 1000000)
#define NO_IMP_MIN ( LOW_FREQ * 2 * CHECK_PERIOD / 1000000)


//  extern void ledON(void);
// extern void ledOFF(void);

/** Class C_zcControl kontrolise zero crossing sinhronizaciju 
* komande i citanja indikacija. 
*/

class C_zcControl
{

/**Ticker t je tajmer periode 1 sec koji prebojava 
* broj impulsa zero crossinga u periodi
*/ 
    Ticker t;
    C_zeroCrossing *p_zeroCrossing;
    C_spiProtokol *p_spiProtokol;
    bool zc;
    public:

    C_zcControl( C_zeroCrossing *p_zc, C_spiProtokol *p_sp)
    {
        p_zeroCrossing = p_zc;
        p_spiProtokol = p_sp;
        t.attach_us([this](){check_zc();}, CHECK_PERIOD);
    }

    void check_zc( void )
    {
        int zcCount = p_zeroCrossing->get_zcCounter();
        zc = IN_RANGE(zcCount, NO_IMP_MIN, NO_IMP_MAX);
        p_spiProtokol->set_zeroCrossing( zc);   //  zc == true => zero crrossing je dobar!

        // if( zc == true ) ledON();
        // else ledOFF();
    }
    bool get_zerocrossing( void ) { return zc; }

};


#endif