#include "IOspiprotokol.h"

#include <functional>

// extern DigitalOut ioTest;
 static DigitalOut ledB(LED2,1);



extern volatile char ext_command, ext_data;

extern char verzija, reset_flag;

void C_spiProtokol::do_writeCommand( const char command, const char data)
{
//ledB =!ledB;

//pc_data->set_validity(0x3f);
//ioTest =! ioTest;
    switch( command )
    {
        case 1: pc_data->set_command(data);   /* ioTest =! ioTest;*/ /* ext_command = command; ext_data = data; */  break;
        case 2: pc_data->set_validity(data);  set_reset(false);  // brisanje reset flaga
             /*ext_command = command; ext_data = data;*/ /*ioTest =! ioTest;*/  break;
        case 3: pc_ledControl->unpack_ledBulb(data);   break;  // formiranje tabele sijalica
        // prikazi na shift ledove
        case 4: pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(komanda);/*  set_byte(pc_data->get_command()); */   break;
        case 5: pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(indikacija);/*set_byte(pc_data->get_indication());*/ break;
        case 6: pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(ispravnost);/*set_byte(pc_data->get_correctness());*/ break;
        case 7: pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(mis);/*set_byte(pc_data->get_faultVoltage());*/ break;
        case 8: pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(poruka);/* set_byte(pc_data->get_message());*/ break;
        case 9: pc_ledControl->set_colorTemplate_Yellow(); pc_ledControl->set_ledView(validnost);/* set_byte(pc_data->get_validity());*/ break;
        case 10: pc_ledControl->set_colorTemplate_Red(); pc_data->set_data(data); pc_ledControl->set_ledView(podatak);/* set_byte(pc_data->get_data());*/ break;
        case 11: pc_data->clear_correctness( ); pc_data->clear_faultVoltage(); break;
        case 12: pc_ledControl->set_colorTemplate_Green(); pc_ledControl->set_ledView(adresa);/*set_byte(pc_data->get_address());*/ break;
        case 13: pc_ledControl->set_ledView(aktuelna_indikacija);pc_ledControl->set_colorTemplate(); pc_ledControl->set_ledView(aktuelna_indikacija);/* set_byte(pc_data->get_raelIndication());*/ break;

        case 14: /* brisanje look-up tabele sijalica */  break;
        case 15: /* reset ploce */NVIC_SystemReset(); break;
   }
}

char C_spiProtokol::do_readCommand( const char command, const char data)
{ 
    switch( command )
    {
        case 0: return 0;
        case 1: return data;
        case 2: return pc_data->get_message();
        case 3: return verzija;
        case 4: return pc_data->get_command();      // komanda paljenja sijalica
        case 5: return pc_data->get_indication();   // indikacije sa sijalica
        case 6: return pc_data->get_correctness();  //ispravnost sijalica
        case 7: return pc_data->get_faultVoltage(); //detkcija misa
        case 8: return pc_data->get_validity();     // validni izlazi
        case 9: /* ne znam sta je - neki LED_IND - TREBA PROVERIti !!!! */ return 9;
        case 10: /* bajt sa adrese na koju pokazuje polje data - nemoguce je realizovati */ return 10;
        case 11: return pc_data->get_address();  // POTPUNA GLUPOST !!!
        case 12: return pc_data->get_raelIndication();  // aktuelna indikacija
        case 13: return pc_data->get_roughIndication();   // treba da bude (sirova indikacija | sirovi mis) - nepotrebno
        case 14: return 14;   // treba da bude sirova indikacija - Pa_min - nepotrebno 
    }
    
    return 15;
}

Timeout tout;


void C_spiProtokol::do_readGroupCommand( const char command)
{
    //ledB=!ledB;
    switch( command )
    {
        case 1:  /* aktiviranje timera na 4 sekunde za gasenja IO */
        ledB=!ledB;
         tout.attach([this](){pc_data->set_command(0); NVIC_SystemReset();}, 4.0);
         break;
        case 2: /* gasenje timera */ tout.detach(); /*ledB=1;*/break;
    }
 }








