/* -------------------------------------------------------------------------- */
/* Name : e_epics.h

	 Definition der Ein-Ausgabeschnittstelle zwischen EPICS und EON-Kern.
	 Daten und Datenstrukturen.

	 Autor : Joachim Mertz

	 Version 1.03 fuer TABASCO Feldversuch

	 Erstellt:  19.03.97

	 Letzte Aenderung:   30.09.97   Mertz
*/
/* -------------------------------------------------------------------------- */


#include "e_eon.h"
#include "e_eondef.h"

#ifndef __E_EPICS_H
#define __E_EPICS_H

/* -------------------------------------------------------------------------- */


/* -------------------------------------------------------------------------- */
/* Strukturen und Typen des Verkehrsmodells */

typedef struct					  			/* Struktur zur Definition eines OEV Fahrzeugs */
{	long			fzID;					/* Fahrzeug-ID */
	ushort			relGewicht,				/* relative Gewichtung des V-Fahrzeugs [1/128] */
					tan,					/* Annaeherungszeitzaehler des MPP [sec], aber nur bis DOUBLETH-1	 Zaehlerwert = 0, falls keine Anforderung */
					TimeSinceRegistration;	/* Annaeherungszeitzaehler des MPP [sec]							 Zaehlerwert = 0, falls keine Anforderung */
	uchar			priority;
} oevFz_t;


/* -------------------------------------------------------------------------- */
/* Struktur zur bergabe des Balance-Rahmensignalplans (entspricht einem Feld ber alle Signalgruppen von dieser Struktur) */
/* analog zu AnwurfTypSG von VS-PLUS */
typedef struct 
{
	short primalStart;						/* frhester Beginn Phasenbergang, eigentlich nicht verwendet, da der von Balance optimierte Zeitpunkt immer der spteste ist. */
	short latestStart;						/* sptester Beginn Phasenbergang */
} PueStart_t;


typedef struct 
{
	short firstSecondGreen;					/* Zeitpunkt zu dem Sg gem Balance eingeschaltet werden soll */
	short lastSecondGreen;					/* Zeitpunkt zu dem Sg gem Balance ausgeschaltet werden soll - 1 */
} SGAnwurf_t;


typedef struct							  	/* Struktur zur Definition eines Meldepunktpaares */
{	unsigned short	anzFz;	 				/* Anzahl der eingezhlten Fahrzeuge im MPP */
	oevFz_t			fz[MAXMPPTIEFE];		/* Definition der Fahrzeuge */
											/* Zaehlerwert = 0, falls keine Anforderung */
} mpp_status_t;


typedef struct							  	/* Struktur zur Definition des Detektorstatus */
{	
	short			gestoert,				/* liegt eine Strung des Detektors vor? */
					anf,					/* Anforderung des Detektors */
					bel,					/* Belegungsgrad des Detektors */
// die folgenden Felder werden fr den Rckstauschtzer gebraucht:
					freiSeit,				/* Seit wieviel Sekunden ist Detektor ununterbrochen frei? Dient zur Renormierung. */
#ifdef EPICSTRENDS
					belegtSeitTRENDS,		/* Seit wieviel Sekunden ist TRENDS-Detektor belegt? */
#endif
					nichtDauerbelegtSeit,	/* Seit wieviel Sekunden stand kein Fz mehr auf Detektor? */
					warBelegt,				/* War Detektor whrend der letzten Rotphase belegt? */
					abflussUnunterbrochen,	/* nachdem sich das auf dem Detektor stehende Fz bewegt hat: Sind ununterbrochen Fz ber Detektor gefahren bis er wieder belegt war? In diesem Fall kann man tB neu bestimmen. */
					abgeflosseneFz,			/* nachdem sich das auf dem Detektor stehende Fz bewegt hat: Wie viele Fz haben Detektor passiert?. */
					vorgezogeneFz,			/* falls Rckstau hinter Det. vermutet, wird dieser auf Vert. Queue addiert. Damit kein Double-Counting auftritt, merke ich mir die Anzahl dieser Fz.*/
					belegtSeit,				/* Seit wieviel Sekunden ist Detektor ununterbrochen belegt? */
					StauLetzterUmlauf,		/* wieviele Fz sind nach Dauerbelegung des Det. ohne grere Lcke ber diesen geflossen? */
					StauVorLetzterUmlauf,	/* wieviele Fz sind im vorletzten Umlauf nach Dauerbelegung des Det. ohne grere Lcke ber diesen geflossen? */
					timeRequirement;		/* das eigentliche timeRequirement der Anforderung respektive der Signalgruppe setzt sich aus dem Mittelwert der tBs der parallelen Detektoren zusammen */
	uchar			beruecksichtigt;		/* nur relevant fr FG-Detektoren. Bei mehr als einem Taster je Anforderung will ich die Tastereignisse von verschiedenen Tastern addieren, nicht aber die von gleichen Tastern. */
} det_status_t;


typedef struct							  	/* Struktur zur Definition des Signalgruppenstatus */
{	
	ushort			lengthLastGreen,		/* wie lange dauerte die letzte Grnzeit? Bentigt fr dynamische Anpassung von tB. */
					lengthLastRed,			/* wie lange dauerte die letzte Rotzeit? Bentigt fr Ausgabe von Grnbeginn und -ende. */
					greenSince;
	uchar			frei,					/* Freigabe der Signalgruppen ja/nein = 1/0 */
					TClosedMaxToBeRespected,/* TClosedMax zu bercksichtigen ja/nein = 1/0; ist nur dann nicht der Fall wenn es occupancyDetectors gibt und diese nicht belegt sind. */
					signalBild;				/* das Original-Signalbild, also SG_EPICS_GREEN etc. */
	int				kritischeGesperrtDauer,	/* kritische Zeit, wie lange Signalgruppe schon rot ist, also Zeit, nachdem der Timer anfngt zu laufen, z.B. seit Anmeldung. Bentigt wegen TClosedMax */
					realeGesperrtDauer,		/* Zeit, wie lange Signalgruppe tatschlich schon rot ist. Bentigt wegen TClosedMin */
					freiDauer;				/* Zeit, wie lange Signalgruppe schon grn ist. Bentigt wegen Mindestgrnzeit */
} sgr_status_t;


typedef struct
{	unsigned short	weight;					/* Gewichtung der Signalgruppe [%] */
	unsigned short	weightGreenWave;		/* Gewichtung des virtuellen Pulks, der die Grne Welle steuern soll. Vorsicht: Zu groe Werte sorgen dafr, dass Signalgruppe evtl. unntig lang aufgehalten wird. */
	unsigned short	stauraum[MAXSUBQ];		/* maximale Anzahl von Fahrzeugen, die sich in Subqueue aufstellen koennen */
	long			*anf;					/* resultierende Anforderungs-Queue */  /* von hil einst von TH auf DOUBLETH erhht, da ich mit cyclic flow profiles weiter in die Vergangenheit blicken will. Jetzt dynamisch angefordert */
} queue_t;


/* Optimierungsstufe 2 */

/* Struktur fr einen Knoten (=Phase) im Phasenablauf*/
typedef struct
{	uchar		phIndex,					/* Phasen-Index aktuelle Phase*/
				pueIndex,					/* Index Phasenuebergang zur naechsten Phase*/
				pueDauer,					/* Laenge Phasenuebergang */
				tRel,						/* Zeitkoordinate, relativ zum Startpunkt */
				earliestStartR,				/* fruehester Phasenbeginn, relativ zur aktuellen Umlaufsekunde */
				latestEndR;					/* spaetestes Phasenende, relativ zur aktuellen Umlaufsekunde */
	short		lFrei, rFrei,				/* freier Platz zum linken und rechten Nachbarn des Knotens */
				lRes, rRes;					/* gesamter freier Platz links und rechts des Knotens (ueber mehrere Elemente) */
	int			costPreferred, 				/* Bewertung des IV: */
				costNonPreferred;  			/* Feste Werte fuer Phasen  */
	uchar		preferredStartR,			/* preferredStart, relativ zur aktuellen Umlaufsekunde */
				preferredEndR;				/* preferredEnd, relativ zur aktuellen Umlaufsekunde */
} phabKn_t;


#endif


/* -------------------------------------------------------------------------- */
/* Funktionsprototypen */


#ifdef __cplusplus
	extern "C" {
#endif

ushort e_epics(

	unsigned char, 	 			/* Auswahl der Initialisierung:
												0 = Betrieb (keine Initialisierung),
												1 = Programmwechsel,
												2 = Neustart  */

	unsigned char,		 		/* Aktuelle Umlaufsekunde */
	unsigned char,		 		/* Aktuelle Phase (DUMMYNUMBER1 = keine Phase/laufender Phasenuebergang) */
	unsigned char,	 			/* Index Signalprogramm */

	phabKn_t[],					/* Phasenablauf */
	uchar*,						/* Lnge Phasenablauf */
	SGAnwurf_t*,				/* Balance-Rahmensignalplan */
	short*,						/* von auen bergebene Profile */
	char*,						/* String fr die Runtimes der beiden Optimierungsschritte */
	uchar*,						/* P die momentan noch nicht verwendet werden drfen */
	uchar*);					/* um wie viele Sekunden die P die Mindestfreigabe verletzen wrden */


#ifdef __cplusplus
	}
#endif

