/* -------------------------------------------------------------------------- */
/* Name : e_def.h

	 Definition von Typen, Strukturen und
	 Konstanten

	 Autor : Joachim Mertz

	 Version 2.01 fuer Mobinet

	 Erstellt:  19.03.97

	 Letzte Aenderung:   26.08.99   Mertz
*/
/* -------------------------------------------------------------------------- */


#ifndef e_def_h
#define e_def_h


//#include "e_eondef.h"
#include <stdlib.h>
#include "e_epics.h"
#include <stdio.h>
#include <time.h>
#include <stdint.h>
#if defined STATKBROSS || defined EPICSTRENDS	// STATKBROSS ist die Direktive von A-Ster, unter der EPICSTRENDS erst definiert ist.
#include "l_typdef.h"
#include "t_typtre.h"
#include "s_pttode.h"
#endif

/* -------------------------------------------------------------------------- */
/* Definition Typen und Strukturen */

#ifndef max
#define max(a, b) ((a > b) ?  a : b)
#endif

#ifndef min
#define min(a, b) ((a < b) ?  a : b)
#endif

//#ifdef _WINDOWS
//#define sprintf_s _snprintf			// in VS ist nur _snprintf bekannt. Nein, das stimmt so nicht (mehr). Hat den Nachteil, dass ein zu langer string nicht nullterminiert wird.
//#else
#define sprintf_s snprintf			// dem Gnublin-Compiler ist nur snprintf bekannt
//#endif

/* Strukturen zur Definition der LSA-Eigenschaften und der OEV-Anmeldungen */

/* Struktur zur Definition der Phasenuebergaenge */
typedef struct
{	
	int			ID,							/* Pue-ID */
				fromStageID, toStageID;		/* IDs von Quell- und Ziel-Phase */
#ifndef VSPLUS  /* vorbergehend nur unter dieser Direktive, da die VS-AG diesen Parameter noch nicht kennt. */
	uchar		TTimeID;					/* ID der Balance-T-Zeit, die den sptesten Zeitpunkt beschreibt, zu dem der P gestartet werden soll. Die T-Zeiten sind durchnummeriert T1, T2, T3, ..., der Index ist 0, 1, 2, ... */
#endif
#ifdef RBC
	uchar		isFloating;
//Ein FloatingPue ist ein P, der nicht ber die Barrier hinweggeht. Solch ein P kann bei RBC gleichzeitig mit einem anderen 
//FloatingPue ablaufen respektive die beiden knnen berlappen. Man erkennt einen FloatingPue daran, 
//dass er eine even Sg aus(ein)schaltet und eine odd Sg ein(aus)schaltet und eine andere Sg Dauergrn hat.
//Fugnger (also Sg, die ein- und ausgeschaltet werden, zhlen nicht.)
#endif
	uchar		length,						/* PUE-Dauer, inklusive Mindestgrnzeiten und Mindestphasendauer */
				sgEin[MAXSG],				/* Ein-/Ausschaltvektor */
				sgAus[MAXSG];
} pue_t;

/* Struktur zur Definition der programmabhngigen Phasenparameter */
typedef struct
{	
	int			costPreferred, 				/* Bewertung des IV: */
				costNonPreferred;			/* Feste Werte fuer Phasen */
	uchar		preferredStart,				/* preferredStart<=t<=preferredEnd Wert(Phase) = costPreferred */
				preferredEnd,				/* preferredEnd< t< preferredStart Wert(Phase) = costNonPreferred */
				earliestEnd,				/* frhestes Ende der Phase */
				latestEnd,					/* sptestes Ende der Phase */
				earliestStart,				/* fruehester Anfang Phase */
				minLength,					/* Mindestdauer der Phase; jetzt an vorherigen Pue drangehngt */
				maxLength;					/* Hchstdauer der Phase; Die Anforderung kam von D. Jaros, A-Ster */
} prgDepParam_t;

typedef struct
{
	uchar		start;
	uchar		end;
} interval_t;

/* Struktur zur Definition der Phasen */
typedef struct
{	
// explizit in xml-File versorgte Felder:
	int			ID;							/* Phasen-ID (VT, real) */
#ifndef VSPLUS
	char		name[LENGTHLOGSTRING];		/* Phasen-Name, gibt es nicht in xml-File. */
#endif
	uchar		sgState[MAXSG];				/* Zustand der Signalgruppen in der Phase (1 fr frei, 0 fr rot) */
	prgDepParam_t param[MAXPRG];			/* die 'PrgDepStageParams' sind jetzt in eine eigene Struktur ausgelagert. */
	int			stageHierarchy[MAXPRG][MAXPHAS];	/* vgl. Ep-83 (Phasen-Rangordnung); Bsp. stageHierarchy[1][0] = 4, stageHierarchy[1][1] = 5 bedeutet, dass im Programm mit Index 1 auf die aktuelle Phase Phase 4 folgen soll, sofern sie angefordert ist. Andernfalls ist Phase 5 die zu schaltende etc. */

// nicht explizit in xml-File versorgte Felder:
#ifdef RBC
	uchar		hasFloatingPue;
// Es gibt mindestens einen FloatingPue der aus der Phase fhrt.
#endif
	uchar		notausgang;					/* Pue-ID mit Notausgang fuer nicht-definierte Zustaende; nicht verwendet. */
	pue_t		*pue[MAXPUE];				/* Indizes der von der Phase erreichbaren Phasenuebergaenge */
} ph_t;

typedef struct
{
	uchar interStageID;
	int secondInCycle;
} signalPlanItem;

/* Struktur zur Definition des Signalprogramms */
typedef struct
{	
	uchar		ID,							/* Signalprogramm-ID (real, z.B. 1, 3, 7), <= MAXPRGID */
				tu,							/* Umlaufdauer */
				activePues[MAXACTIVEPUE];	/* die in diesem Programm aktiven Phasenbergnge (IDs). Die Idee kam von D. Jaros, A-Ster */
	ushort		weightBalance;				/* Gewichtung des Balance-Rahmensignalplans */
#ifndef VSPLUS
	uchar		balanceFixedTimeControl;	/* Ist dieses Flag true, so setzt Epics lediglich die Balance-Rahmen um, ebenso wie bei epicsLicenseMode == balanceFixedTime. */
	int			factorStops;				/* jetzt endlich programmabhngig */
	double		factorMaxRedPuT;			/* um diesen Faktor drfen die maximalen Rotzeiten gedehnt werden, wenn eine V-Anforderung vorliegt. */
#endif
	uchar		cycleBalance[MAXPUE];		/* die in diesem Programm von Balance verwendeten Phasenbergnge (IDs). */
#ifdef UseInputdata
	signalPlanItem	cycleFixedTime[MAXPUE];	/* das Festzeitprogramm fr die Rckfallebene. */
#endif
} prg_t;

/* Koordinate in Anforderungsdefinition */
typedef struct
{	
	uchar		val;						/* Wert */
#ifdef VSPLUS
	uchar		t;							/* Koordinate Zeitachse; ursprnglich uchar */
#else
	int			t;							/* Koordinate Zeitachse; kein uchar wegen TDReg und weil in VISSIG <= 2*TimeHorizon gefordert */
#endif
} anfKoord_t;

/* Daten zur Positionsberechnung fuer Quartierview */
typedef struct
{	
	ushort		fahrzeit;					/* durchschnittliche Fahrtzeit [sec] von der Anmeldung zur Haltlinie */
	ushort		hsZeit;						/* durchschnittliche Haltestellen-Zeit [sec] */
	ushort		minT, minX;					/* minimale zeitliche [sec] und raeumliche [m] Entfernung zur Haltlinie */
} position_t;

/* allgemeine Informationen ber die Signalgruppen */
typedef struct
{	
	int			lsaID,						/* ID der LSA (LSA-Nr. bzw. Unit-Nr.), nur fr LogFiles bentigt. */
				nrVersion;					/* EPICS-Versions-Nr.. */
#ifdef VSPLUS
	uint		checkSum;					/* Checksumme der Versorgung. Momentan nicht berprft. */
#endif
#ifndef VSPLUS
	char		lsaName[LENGTHLOGSTRING];	/* LSA-Name, bentigt in Web-Gui */ 
	uint32_t	checkSum;					/* Checksumme der Versorgung (unsigned long). */
	uchar		observationMode,			/* Modus, bei dem man EPICS besonders gut zusehen kann da STL jede Sekunde bertragen wird; sonst einmal bei Rotbeginn. */
				timeHorizon,				/* Zeithorizont von Epics, parametrierbar; default: 100s */
				laneboundTraffic,			/* Ist der Verkehr spurgebunden? Default true. In Indien false. */
				logLevel;					/* 0, ..., 4; definiert welche Log-Files geschrieben werden (nicht was reingeschrieben wird) */
											/* Level 0: Epics_ReadSupply-sig_xxx.txt, Epics_ReadSupply-xml_xxx.txt werden geschrieben, da erst nach Einlesen der Versorgung das LogLevel bekannt ist. */
											/* Level 1: Epics_MainLog_xxx.txt, Epics_MainLog_xxx.json, Epics_Queues_xxx.json werden geschrieben. */
											/* Level 2: Epics_Supply_xxx.txt, Epics_Queues_xxx.txt, Epics_Action_xxx.txt, Epics_StageSequence-1_xxx.txt, Epics_StageSequence-2_xxx.txt werden geschrieben. */
											/* Level 3: Epics_NumberStops-1_xxx.txt, Epics_NumberStops-2_xxx.txt, Epics_PerformanceIndex-1_xxx.txt, Epics_PerformanceIndex-2_xxx.txt werden geschrieben. */
											/* Level 4: Epics_Debug_xxx.txt, Epics_Runtime_xxx.txt und Epics_APValues_xxx.txt werden geschrieben. */
#endif
	int			startStageIDBalance,		/* bei dieser Phase soll der Balance-RSP beginnen */
				factorDelay,				/* Gewichtungsfaktor fr die Optmierungsgre Verlustzeit.  Default:  1 */
				factorStopsCurrent;			/* Gewichtungsfaktor fr die Optmierungsgre Anzahl Halte. Default: 50; current da der Faktor fr das aktuelle Programm gilt */
} gen_t;

/* Informationen ber die Signalgruppen */
typedef struct
{	
	int			ID,							/* ID der Signalgruppe, meist 1, 2, 3, 4, ... aber nicht immer. */
				fatherID,					/* ID der Vater-Signalgruppe von Klonen. Sinnvoller wre es, den fatherIndex zu verwenden. Allerdings nicht ganz so trivial einzulesen fr VS-PLUS. */
				cloneID;					/* ID einer IV-Klon-Signalgruppe. Verwendet fr Ersatzwertbildung von gestrten Detektoren. Die Mglichkeit, dass es mehr als einen Klon geben kann, vernachlssige ich. */
	uchar		TFreeMin,					/* Mindestfreigabezeit */
				notStageDefining,			/* Signalgruppe wird beim Ermitteln der aktuellen Phase nicht bercksichtigt. */
				timeAmber;					/* Gelb-Dauer (whrend bergang von grn nach rot) je Signalgruppe */
#ifndef VSPLUS
	uchar		timeRedAmber,				/* Rot-Gelb-Dauer (whrend bergang von rot nach grn) je Signalgruppe */
				timeFlashingGreen;			/* Grn-Blinken-Dauer (whrend bergang von grn nach rot) je Signalgruppe */
	int			TClosedMin[MAXPRG];			/* min. Gesperrtzeit muss programmabh. sein da bei unterschiedlichen T_U ein einziger Wert nicht sinnvoll. */
#else
	int			parallelSGID;				/* ID einer 'Parallel-Signalgruppe'. Wird bentigt fr Signalgruppen die notStageDefining sind aber dennoch einen Rahmen fr VS-PLUS erhalten sollen. Es wird dann der Rahmen der ParallelSG bernommen. */
#endif
	int			TClosedMax[MAXPRG],			/* max. Gesperrtzeit muss programmabh. sein da bei unterschiedlichen T_U ein einziger Wert nicht sinnvoll. */
				cyclical[MAXPRG];			/* kommt die Sgr nur auf Anforderung? Programmabhngig. -1 bedeutet nicht versorgt. */
#ifdef RBC
	char		Name[20];					/* bentigt um Overlap-Signalgruppen zu finden */ 
#endif
} sgr_t;

/* Struktur zur Definition eines Meldepunktpaares */
typedef struct
{	
	int			ID,							/* MPP-ID (real), der Versorger soll die ID des Meldepunktpaares frei whlen knnen. Intern wird sie in den mppIndex = 0, 1, 2, 3, ... umgewandelt. */
				anmelderID[MAXMP],			/* ID der Anmelder (real); falls mehr als ein Anmelder so sind diese durch 'oder' verknpft */
				abmelderID[MAXMP];			/* ID der Abmelder (real); falls mehr als ein Abmelder so sind diese durch 'oder' verknpft */
#ifndef VSPLUS
	int			anmelderMPNr[MAXMP],		/* Meldepunktnummer; 0 wenn es kein MP ist sondern ein normaler Detektor */
				abmelderMPNr[MAXMP];		/* Meldepunktnummer; 0 wenn es kein MP ist sondern ein normaler Detektor */
	uchar		anzAnmelder,				/* wie viele durch 'oder' verknpfte Anmelder? */
				anzAbmelder;				/* wie viele durch 'oder' verknpfte Abmelder? */
	int			vehTimeForcedLogOff,		/* Time after which the vehicle should be deleted from the calling-point pair. */
				sgrTimeForcedLogOff;		/* Forced deregistration should not be processed until at least so many seconds of green time have passed. */
#endif
} mpp_t;

/* Struktur zur Definition einer Oev-SubQueue */
typedef struct
{	
	uchar		mppIndex,					/* Index des MPP's */
				onlyIfNot,					/* Beruecksichtigung nur, wenn MPPs mit ff. Indizes nicht an */  /*Bsp. OnlyIfNot 14 wrde bedeuten, die MPP-Anmeldungen der Signalgruppe werden nur dann bercksichtigt, wenn sich bei MPP 14 kein Fz angemeldet hat.*/
				hasOwnLane;					/* Falls der V keine eigene Spur hat, verwende ich TDequeuing der Father-Sg */
	int			TDReg;						/* Vordere Grenze der MPP-Anforderung (0..TH1, 0=Haltlinie) (TDReg fr time distance registration point); kein uchar wegen Einlesen */
	position_t	position;					/* Daten zur Positionsberechnung fuer Quartierview */
	anfKoord_t	anfTrapez[4];				/* Trapez zur Definition der Form der OEV-Anforderungen der einzelnen MPP's */
} subQueueOev_t;

/* Struktur zur Definition einer Iv-SubQueue */
typedef struct
{	
	uchar		detID[MAXSPUR],				/* IDs der Detektoren */
				stealingDetID[MAXSPUR],		/* IDs der Stealing-Detektoren, d.h. der Detektoren die auf Zufahrten liegen, auf die Fz von der betrachteten Zufahrt abzweigen knnen. */
				anzDet,						/* wie viele Zhl-Detektoren gibt es fr das Subqueue? */
				anzStealingDet;				/* wie viele Stealing-Detektoren gibt es fr das Subqueue? */
	int			TDDet;						/* zeitliche Entfernung (TD fr time distance) anfordernde Detektoren; kein uchar wegen TDReg */
} subQueueIv_t;

/* Struktur zur Definition einer Ped-SubQueue */
typedef struct
{	
	uchar		detID;						/* ID des Detektors (mehr als einer nicht sinnvoll) */
} subQueuePed_t;


/* Struktur zur Definition der Anforderungsstruktur */
typedef struct	
{
	anfTyp_t	typ;						/* Art der Anforderung (Iv/Oev/IvOev!!!)*/
	uchar		sgIndex,					/* interner Index der zugehoerigen Signalgruppe */
				hilfSg,						/* ID des zugehoerigen Hilfs- bzw. Vorsignals */
				compSg,						/* ID des competing Signals, dessen Vorfahrt zu gewhren ist */
				vorSg,						/* = DUMMYNUMBER1, falls nicht vorhanden */
				numberLanes,				/* Anzahl Spuren der Zufahrt */
				vMax,						/* zul. Hoechstgeschwindigkeit [km/h] */
				anzSubq,					/* Anzahl der zugehoerigen MPP's bzw. IV-Subqueues */
				adaptTimeRequirement;		/* soll tB automatisch angepasst werden oder nicht? */
	ushort		weight,						/* Gewichtung der Fahrzeuge vor Signalgruppe [Oev sollte zumindest ca. 100 mal hoeher sein als Iv] */
#ifndef VSPLUS
				OevWeights[MAXPRIO + 1],	/* entspricht den versorgten Werten fr weight, je nachdem ob die Prioritt 0, 1, 2 oder 3 ist; weight erhlt den aktuell gltigen Wert. Von VS-PLUS noch nicht bergeben */
				prgDepWeights[MAXPRG],		/* Wunsch von Grzegorz F. (EP-28); von VS-PLUS noch nicht bergeben */
				weightStatic,				/* versorgter Wert; fr das Projekt VinStar soll das aktuelle Gewicht von TRENDS abgefragt werden. */
#endif
				detectorCounts,				/* vehicles/pedestrians counted during the last cycle */
				weightGreenWave,			/* Gewichtung des virtuellen Pulks */
				timeRequirementStatic,		/* entspricht dem versorgten Wert fr tB. tB dagegen wird dynamisch angepasst und hngt am sgr_status_t. */
				timeRequirementHelp,		/* Zeitbedarfswert [1/10 sec/Fz] Hilfsignal */
				timeRequirement,			/* Zeitbedarfswert [1/10 sec/Fz] */
				tZwangsabmeldung;			/* nach so vielen Sekunden wird ein V-Fahrzeug zwangsabgemeldet. Default 180s. */
	long		outFlow;					/* vehicles/pedestrians flown off during the last cycle */
//	int			linkID;						/* ID des Links, den man zur Anzeige von Staulngen in VTnet verwenden will; msste nicht ans Steuergert bergeben werden. */
	subQueueOev_t	subQueueOev[MAXSUBQ];	/* Daten der OeV-SubQueues; nur eine der drei subQueues wird tatschlich gefllt */
	subQueueIv_t	subQueueIv[MAXSUBQ];	/* Daten der IV-SubQueues */
#ifndef VSPLUS
	subQueuePed_t	subQueuePed[MAXSUBQ];	/* Daten der Ped-SubQueues */
#else
	subQueuePed_t	subQueuePed[1];			/* [1] weil sonst der Test mit VS-PLUS nicht mehr klappt */
#endif
	uchar		anzOccupancyDet,			/* Belegungsdetektoren; nur wenn Detektor belegt soll die Phase kommen, d.h. TClosedMax bercksichtigt werden. */
				occupancyDetID[MAXSPUR];
} anf_t;

/* Struktur fuer LSA-Eigenschaften */
typedef struct						
{	
	uchar		anzSgr,						/* Anzahl Signalgruppen */
				anzRealSgr,					/* Anzahl Signalgruppen ohne Klone */
				anzPh,	 					/* Anzahl Phasen */
				anzPue,						/* Anzahl Phasenuebergaenge */
				anzPrg,						/* Anzahl Signalprogramme; jetzt doch bentigt zum Befllen des IntlPrgIndex */
				anzMpp,						/* Anzahl Meldepunktpaare; bentigt zum Befllen von mppDef mit DummyNumbers */
				anzAnf;						/* Anzahl Demands; bentigt zum Befllen von anfD mit Dummy-Anforderungen */
	gen_t		genFeatures;				/* Kapselung von allgemeinen Features wie LSA-ID und Checksumme */
	mpp_t		mppD[MAXMPP];				/* Definition der Meldepunktpaare */
	sgr_t		sgrD[MAXSG];				/* Infos ber Signalgruppen */
	prg_t		prgD[MAXPRG];				/* Signalprogramme */
	ph_t		phD[MAXPHAS];				/* Phasen */
	pue_t		pueD[MAXPUE];				/* Phasenuebergaenge */
	anf_t		anfD[MAXSG];				/* Signalgruppenbezogene Anforderungen */ 
} lsaDef_t;


/* kaputte Struktur fuer LSA-Eigenschaften zum Testen */
typedef struct						
{	
	uchar		anzSgr,		  				/* Anzahl Signalgruppen */
				anzRealSgr,					/* Anzahl Signalgruppen ohne Klone */
				anzPh,	 					/* Anzahl Phasen */
				anzPue,						/* Anzahl Phasenuebergaenge */
				anzPrg,						/* Anzahl Signalprogramme; jetzt doch bentigt zum Befllen des IntlPrgIndex */
				anzMpp,						/* Anzahl Meldepunktpaare; bentigt zum Befllen von mppDef mit DummyNumbers */
				anzAnf;						/* Anzahl Demands; bentigt zum Befllen von anfD mit Dummy-Anforderungen */
	gen_t		genFeatures;				/* Kapselung von allgemeinen Features wie LSA-ID und Checksumme */
	mpp_t		mppD[MAXMPP];				/* Definition der Meldepunktpaare */
	sgr_t		sgrD[MAXSG];				/* Infos ber Signalgruppen */
	prg_t		prgD[MAXPRG];				/* Signalprogramme */
	ph_t		phD[MAXPHAS];				/* Phasen */
	pue_t		pueD[MAXPUE];				/* Phasenuebergaenge */
	anf_t		anfD[MAXSG];				/* Signalgruppenbezogene Anforderungen */ 
} lsaDefkaputt_t;


/* Optimierungsstufe 1: */
/* Strukturen zum Aufbau des Graphen zur Darstellung des Zustandsraumes
   in der  ersten Optimierungsstufe */

/* Struktur fuer Knoten des Zustandsraum-Graphen */
typedef struct zRKnoten_s
{	uchar		t,							/* t-Koordinate */
				phIndex;					/* Phasen-Koordinate */
	 struct zRKante_s *kantLst;				/* Liste mit Kanten zu Nachbarknoten im Zustandgraphen */
} zRKnoten_t;

/* Struktur fuer Kanten des Zustandsraum-Graphen */
typedef struct zRKante_s
{	long		kost,			 			/* Wegkosten der Kante (nur bei Phase, sonst aus Sg-Matrizen)*/
				kostSingle;					/* Kosten fr die anschlieende Sekunde nach einem P */
	uchar		pueIndex,  		 			/* Index Phasenuebergang (falls in Pue, sonst 0)*/
				phIndex,  	 				/* Index Phase */
				isPreferred,				/* isPreferred bedeutet: Es handelt sich um einen P, der in eine Bedarfsphase fhrt und zwar in der nheren Umgebung ihres bevorzugten Bereichs. */
				schaltetBedarfsPhaseEin;
	zRKnoten_t	*kn;		 				/* Zielknoten */
	struct zRKante_s *nextKante;			/* naechstes Element in Kantenliste */
} zRKante_t;

/* Struktur fuer erreicht-Liste der Kuerzeste-Weg Suche */
typedef struct erreicht_s
{	long		length;				 		/* Weglaenge vom Startknoten */
	zRKnoten_t	*zrKn;		 				/* Verweis auf Zielknoten im Zustandsraum */
	struct erreicht_s *next, 				/* Nachfolger in der erreicht Liste */
				*weg;			 			/* Vorgaenger auf dem gefundenen Pfad */
	uchar		pueIndex,		 			/* Index Phasenuebergang vom Vorgaengerknoten */
				tRelr;	
} erreicht_t;



/* Struktur Signalzeitenplan */
typedef struct
{	uchar		tE[MAXSG][MAXSCHALT],		/* Ein-/Ausschaltvektor */
				tA[MAXSG][MAXSCHALT];		/* bis zu MAXSCHALT Schaltvorgaenge je Signalgruppe */
} sigPlan_t;

typedef struct hurrycallCommand_s
{
	int id;	// da in stringList_t auch enthalten
	char xmlCommand[LENGTHDEBUGLOGSTRING];
	struct hurrycallCommand_s *next;
} hurrycallCommand_t;

typedef struct
{
	uint64_t timeStampLastCommand;
	int desiredStageID;
	int duration;
	uchar activated;
	uchar started;
} hurrycallState_t;

/* LSA-spezifische Daten gesammelt, damit man mit einer dll fr mehrere LSA auskommt. */
/* das Vorgehen erfolgt analog zum TRENDS-Kern: */
/* Ein Pointer auf diese Daten wird (als Pointer auf Pointer) immer hin und hergegeben. */
/* Beim Initialisieren wird eine neue Struct erzeugt und der Pointer darauf gerichtet. */
typedef struct
{
	lsaDef_t	lsaParameter1;
	lsaDef_t	lsaParameter2;				/* fr vxb-Wechsel; evtl. spter eleganter lsen */
	lsaDef_t	*lsaDef;					/* Zeiger auf Speicherbereich mit LSA-Versorgungsdaten */
	char		*nodeName;
	long		time;						/* Zeitzaehler */	
	long		messageCount;				/* Zhler der Meldungen */
	int			TimeSinceStageHasBeenDecoded;/* wann wurde die Phase zum letzten Mal erkannt? Falls lnger als einen Umlauf her, Warnung! */
	short		timeRunningPue;				/* wie lange luft der P schon ab? */
	time_t		timeLastCall;				/* wann wurde Epics zum letzten Mal aufgerufen? */
	int			timerFallback;				/* nach dem Start oder einer Detektorstrung soll Epics 90s lang nur Zuschauer sein */
	int			phDauer;					/* Zeit, wie lange Anlage schon in aktueller Phase. */
	mpp_status_t mppStatus[MAXMPP];			/* Array mit Meldepunktpaaren */
	queue_t		queue[MAXSG];				/* Schlangenstrukturen mit Anforderungen */
	int			queueMaxMax[MAXSG];			/* Maximum ber die einzelnen Anforderungen auf eine Sgr von Rotbeginn bis Rotbeginn (meist bei Grnbeginn erreicht) */
	det_status_t detStatus[MAXDETID+1];		/* Zusammenfassung des Detektor-Status */
	sgr_status_t sgStatus[MAXSG];			/* Zusammenfassung des Signalgruppen-Status */
	ph_t		*lastPh;
	short		lastPueID;					/* der zuletzt geforderte P */
	short		lastPrgID;					/* das zuletzt gelaufene Programm */
	int			currentHierarchy[MAXPHAS];	/* Die Hierarchie der letzten regulr geschalteten Phase */
	int			lastRegularStageID;			/* letzte Phase, die nicht entgegen der versorgte Hierarchie geschaltet wurde */
	int			desiredStageID;				/* Falls Hierarchie versorgt, soll diese Phase gem Hierarchie folgen. Tut sie es nicht, gehe ich davon aus, dass eine V-Phase geschaltet wurde und versuche, die Phase anschlieend zu schalten */
	uchar		endStageFloating;
	uchar		ErrorDuringRead;
	uchar		logfilesInitialized;
	uchar		AnzAlleWegeVerboten;		/* an sich kommt ja nur eine Warnung, wenn alle Wege verboten sind. Geschieht dies oft hintereinander soll ein Fehler kommen. */ 
//	uchar		noOeVP;						/* V-Priorisierung aktiv ja/nein; wird wohl nie wieder verwendet */
	zRKnoten_t	**zRaum;					/* Zustandsraum, bis DOUBLETH, da es mglich sein soll, dass die Umlaufdauer grer als TH ist. */
	zRKante_t	*kantenHalde;				/* Kantenelemente des Zustandsraumes; es koennen ohne Risiko weit weniger Kanten angefordert werden, soll jedoch hier keine Rolle spielen */
	int			**mppProt,					/* Felder fuer Anforderungsprototypen und -kennfelder der MPPs */
				**mppKenn;					/* Werte in Kennfeld in Prozent */
/* !!! irgendwannmal schauen, ob sich davon nicht einiges bei Knoten/Kantenstrukturen unterbringen laesst !!! */
	uchar		originalPueDauer[MAXPUE];	/* OriginalPueDauer (ohne Mindestverbleib in Phase) */
	uchar		originalPueDauerNeu[MAXPUE];/* dasselbe fr neu eingelesene vxb */
	uchar		pueDauerR[MAXPUE];			/* reduzierte P-Dauern (/TSTEPS) */
	uchar		originalCycleBalance[MAXPRG][MAXPUE];
	uchar		originalCycleBalanceNeu[MAXPRG][MAXPUE];
	interval_t	originalIntervals[MAXPRG][MAXPHAS];/* preferred intervals, werden von Balance berschrieben */
	interval_t	originalIntervalsNeu[MAXPRG][MAXPHAS];/* preferred intervals, werden von Balance berschrieben */
	erreicht_t	**err;						/* Hash-Tabelle mit Elementen der erreicht-Liste */
	int		    **sgQ;						/* Feld mit Anforderungssummen der Signalgruppen */
	int		    **sgQQ;						/* Feld mit Integral der Anforderungssummen der Signalgruppen */
	int			**sgQR;						/* Feld mit summierten Anforderungen der Signalgruppen (reduzierte Zeitachse) */
	int			***sgZRopt;					/* Feld mit knotenbezogenen Abflusssummen der Signalgruppen [Fz/128] (reduzierte Zeitachse) , nur zum Buffern der Werte fr Optimalroute */
	int			sgSRPue[MAXPUE][MAXSG][MAXLENGTHPUE / TSTEP];/* maximaler (ber TSTEP s aggregierter) Service [Fz/128] der Sg in den Phasenuebergaengen und Phasen */
	int			sgSStage[MAXPHAS][MAXSG];	/* maximaler Service [Fz/128] der Sg in jeder Sekunde einer Phase */
	int			sgSPue[MAXPUE][MAXSG][MAXLENGTHPUE];/* maximaler Service [Fz/128] der Sg in den Phasenuebergaengen; NICHT in den Phasen!!! */
//	int			sgSAggr[MAXPUE][MAXSG];		/* aggregierter maximaler Service [Fz/128] der Sg in den Phasenuebergaengen */
#ifdef RBC
	uchar		indexStartStage;			/* Index der Anfangsphase, z.B. (1, 5) oder (1, 6) oder (2, 5) oder (2, 6) */
	uchar		isOnDemand[MAXSG];			/* kommen die einzelnen Signalgruppen nur auf Anforderung? */
	uchar		lastCycleLength;			/* Pfusch, nur vorbergehend */
#endif
#ifdef EPICSTRENDS
#ifndef STATKALLOC							/* in "Debug" nicht definiert; daher immmer: aP(e_tkd)td_npu; */
	TKSTRUCT *e_tkd;						/* epics-spezifische Benennung um Verwechslungen vorzubeugen */
#else
	void *e_tkd;							/* bentigt fr "Debug"; hier TKSTRUCT unbekannt; dieser dummy ist null; ich frage das immer ab. */
#endif										/* STATKALLOC */
#endif
	uchar		IntlPrgIndex[MAXPRGID+1];	/* Umsetzungstabelle Signalprogrammindex */
	uchar		IntlPhIndex[MAXPHASID+1];	/* Umsetzungstabelle Phasen */
	uchar		IntlPueIndex[MAXPUEID+1];	/* Umsetzungstabelle Phasenuebergaenge */
	uchar		IntlSgIndex[MAXSGID+1];		/* Umsetzungstabelle Signalgruppenindex */
#ifndef UseInputdata
	EPICSOutput_t	outDummy;				/* Platzhalter, der die Rolle der von VISSIM bergebenen Struktur im Fall des eigentlichen TRENDS-Betriebs bernimmt. */
#else
	BAL_FSP		balFsp;						/* war ursprnglich in EPICSInput_t. Ich will aber die Struktur verwenden, um den Balance-Rahmensignalplan reinzuparsen. Der einzige eigentliche Input soll netCommand sein. */
#endif
	hurrycallState_t	hurrycallState;		/* Struktur, die den aktuellen hurry-call-Zustand beinhaltet */
	EPICSOutput_t	*outputData;			/* Zeiger auf Ausgabestruktur; Informationen von EPICS ans Steuergert */
	SGAnwurf_t	BalanceRSP[MAXSG][2];		/* Rahmensignalplan von Balance, signalgruppenbezogen. */
	PueStart_t	BalanceRSPPue[MAXPUE];		/* Rahmensignalplan von Balance, phasenbergangsbezogen. */
	uchar		neighbouringStages[MAXPHAS][MAXPHAS];	/* hier stehen fr alle Phasen die 'benachbarten Phasen' drin. Das sind diejenigen Phasen, bei denen sich das Signalbild am wenigsten von dem der Phase unterscheidet. Da es mehr als eine davon geben kann, hat das Array zwei Dimensionen. */
	uchar		lastAnzPhabKn;
	phabKn_t	lastPhab[MAXPHAB];
	uchar		epicsStatus;
} EPICSData_t;

// im folgenden noch ein paar mehrfach verwendete Funktionen an einem zentralen Punkt:
/* -------------------------------------------------------------------------- */

//void nullTerminatedPrintf(char*, size_t, const char*, ...);

void initializeString(char*);

void terminateString(char*);

void terminateDebugString(char*);

void initializeJsonStrings();

void myStrcat(char*, const char*);

void myStrcatDebug(char*, const char*);

/* Time horizon, parametrierbar (bald). */
uchar getTH(void);

/* Time horizon, parametrierbar aus bergebenen LSA-Parametern. */
uchar getTHFromLsaD(lsaDef_t*);

/* verwendet fr die cyclic flow profiles, da diese einen Umlauf in die Vergangenheit blicken. */
ushort getDoubleTH(void);

/* Reduzierte Laenge [sec] der Groboptimierung (= TH/TSTEP) */
uchar getTHRed(void);

/* Maximale Anzahl Optimierungsschritte Groboptimierung; eine Warnung wenn Limit erreicht wre sinnvoll! */
ushort getMaxOpt1(uchar);

/* Maximale Anzahl Optimierungsschritte Feinoptimierung; eine Warnung wenn Limit erreicht wre sinnvoll! */
ushort getMaxOpt2(void);

/* hat ein Demand eine Anforderung? */
uchar hasDemand(anf_t*);

/* Anpassen der maximalen Rotzeit je nach V-Anforderung */
double getFactorTClosedMax(uchar);

int getTClosedMax(sgr_t*, uchar, double);

// Ueberpruefung, ob sich ein Wert tVal innerhalb der Zeitklammer (tA,tB)
// befindet: tA <= tVal <= tB
uchar inZeitklammer (
	short,							/* zu untersuchender Wert */
	short,				            /* untere Grenze */
	short);            				/* obere Grenze */


/* -------------------------------------------------------------------------- */

/* Berechnung des Saturation Flow */
int GetSatFlow(anf_t*);

/* Berechnung des reduzierten Saturation Flow; dieser ist zu verwenden wenn auf Gegenverkehr zu achten ist. */
int GetRedSatFlow(int);	

/* -------------------------------------------------------------------------- */

/* Setzen und anschlieende Normierung eines T-Punktes tP auf Werte 0..tu-1 */
void setUndNormiereTp(short*, short, uchar);

/* -------------------------------------------------------------------------- */

/* Normierung eines T-Punktes tP auf Werte 0..tu-1 */
void normiereTp(short*, uchar);

/* -------------------------------------------------------------------------- */

#ifdef __cplusplus
	extern "C" {
#endif

/* Phasenbergang schaltet Signalgruppe ein */
uchar pueSchaltetSgEin(pue_t*, uchar);

/* Phasenbergang schaltet Signalgruppe aus */
uchar pueSchaltetSgAus(pue_t*, uchar);

uchar pueSchaltetSg(pue_t*, uchar, uchar);

/* Phasenbergang schaltet Signalgruppe ein und nicht aus */
uchar pueSchaltetSgNurEin(pue_t*, uchar);

/* Phasenbergang schaltet Signalgruppe aus und nicht ein */
uchar pueSchaltetSgNurAus(pue_t*, uchar);

/* Phasen-ID aus Index */
int getPhID(uchar);

/* Index aus Phasen-ID */
uchar getPhIndex(int);

uchar getRealPhIndex(uchar);

/* Phase aus ID */
ph_t *getPh(int);

/* Phasenbergangs-ID aus Index */
int getPueID(uchar);

/* Index aus Phasenbergangs-ID */
uchar getPueIndex(int);

/* Phasenbergang aus ID */
pue_t *getPue(int);

/* die aktuell ermittelte Phase wird nur in den AP-Werten notiert */
void setCurrentStage(short);
short getCurrentStage(void);

/* alle Signalgruppen whrend der Phase rot? */
uchar phIsAllRed(ph_t*);

/* wie verndert die Hilfsignalgruppe einen Phasenbergang? Leicht unterschiedlich fr die beiden Optimierungsschritte */
void setSgEinAusFromSgHilf1(uchar, uchar, uchar*, uchar*, pue_t*);
void setSgEinAusFromSgHilf2(uchar, uchar, uchar*, uchar*);

uchar getIndexSgHilf(anf_t*);

uchar getIndexSgCompeting(anf_t*);

uchar SgGruen(anf_t*, ph_t*);

uchar SgHilfGruen(anf_t*, ph_t*);

/* handelt es sich um eine RBC-Fugnger-Signalgruppe? */
uchar isPedSgr_RBC(uchar);

/* ffnen eines Log-Files */
FILE *openLogFile(const char*, lsaDef_t*);

/* ffnen eines Log-Files und Schreiben von Uhr und Phase */
FILE *openLogFileInStage(const char*, uchar);

/* ffnen eines Log-Files und Schreiben von Uhr und Phase und tX */
FILE *openLogFileInStageAtTx(const char*, uchar, uchar);

void closeLogFile(FILE*);

void closeLogFileWithNewLine(FILE*);

//void copyLogToJson(lsaDef_t*, const char*);

void initializeLogfiles(lsaDef_t*);

void initializeLogfile(lsaDef_t*, const char*, const char*);

FILE *initializeAndOpenLogfile(lsaDef_t*, const char*);

void initializeMainLogfile(lsaDef_t*, const char*);

void initializeLogfileAction(lsaDef_t*, const char*);

void initializeLogfileRuntime(lsaDef_t*, const char*);

void initializeLogfileStageSequence1(lsaDef_t*, const char*);

void initializeLogfileStageSequence2(lsaDef_t*, const char*);

void initializeLogfileAPValues(lsaDef_t*, const char*);

void initializeLogfileNumberStops(lsaDef_t*, const char*, const char*);

void initializeLogfileNumberStops1(lsaDef_t*, const char*);

void initializeLogfileNumberStops2(lsaDef_t*, const char*);

void initializeLogfileQueues(lsaDef_t*, const char*);

void initializeLogfilePI1(lsaDef_t*, const char*);

void initializeLogfilePI2(lsaDef_t*, const char*);

void initializeLogfileDelays(lsaDef_t*, const char*);

void initializeLogfileDequeuing(lsaDef_t*, const char*);

void newLine(FILE*);

void writeLogFile(FILE*, char*);

void writeLogLine(lsaDef_t*, const char*, char*);

void writeLogLineWithStage(const char*, char*, uchar);

void writeLogLineWithStageAndTx(const char*, char*, uchar, uchar);

extern void writeEPICSDebugLogFile(FILE*, char*);

//void writeJsonFile(lsaDef_t*, const char*, char*);

/* Globaler Zeittakt aus Simulationsumgebung */
long getTime(void);

/* -------------------------------------------------------------------------- */
/* Globale Variablen */

extern EPICSData_t	*EPICSData;						// alle LSA-spezifischen Daten


#ifdef __cplusplus
	}
#endif

#endif	// e_def_h



