// -------------------------------------------------------------------------- 
// Name : e_shell_trends.h
//
//	 Definition of input/output interface between Epics and the control system (e.g. TRENDS) or VISSIM, respectively.
//
//	 Author : R. Hildebrandt
//
//	 Written:  14.01.10
//
//	 Version 6.2 for PTV group
//
// -------------------------------------------------------------------------- 

#include "e_eon.h"

#ifdef __cplusplus
	extern "C" {
#endif

typedef enum {
#ifdef UseInputdata
	epicsm_TEMPERROR       = -30,						// temporary error during run; Epics must control via its fallback routine; alternative: the system returns to its own local control
	epicsm_FALLBACK        = -20,						// Epics controls via its fallback routine
#endif
	epicsm_NOTDEF          = -10,
	epicsm_ERROR           =   0,						// hard error during run; controlling via fallback routine not possible
	epicsm_SUCCESS         =  10,						// run successful, frame signal plan unchanged
	epicsm_SUCCESSNEWORDER =  20						// run successful, frame signal plan changed
} EPICSReturnType;										// factor 10 due to TICS (unit of the TRENDS kernel 1/10 s); corrected in function Epics_Shell

short Epics_Shell(
	EPICSInput_t*,										// pointer to input structure (in) 
	EPICSOutput_t*,										// pointer to output structure (out) 
	void**,												// pointer to pointer to controller specific data
	char*);												// pointer to xml string with supply data

#ifdef EPICSTRENDS										// not needed if UseInputdata set
#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_init(DYNACDEF1(char*), void**);
#else
EPICSReturnType f_epics_init(DYNACDEF1(char*));
#endif

#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_newprg(DYNACDEF1(char*), void*);
#else
EPICSReturnType f_epics_newprg(DYNACDEF1(char*));
#endif

#ifndef WINTK
#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_newvxb_read(TKSTRUCT*, char*, void*);
#else
EPICSReturnType f_epics_newvxb_read(TKSTRUCT*, char*);
#endif

#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_newvxb_activate(TKSTRUCT*, TKSTRUCT*, void*);
#else
EPICSReturnType f_epics_newvxb_activate(TKSTRUCT*, TKSTRUCT*);
#endif
#endif

#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_run(DYNACDEF1(short*), void*);
#else
EPICSReturnType f_epics_run(DYNACDEF1(short*));
#endif

#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_shutdown(DYNACDEF1(char*), void*);
#else
EPICSReturnType f_epics_shutdown(DYNACDEF1(char*));
#endif
#ifdef EPICSMultiLSAMode
EPICSReturnType f_epics_hurrycall(DYNACDEF2( short, short), void*);
#else
EPICSReturnType f_epics_hurrycall(DYNACDEF2( short, short ));
#endif
#else
EPICSReturnType f_epics_init(char*, char*, void**, EPICSOutput_t*);
EPICSReturnType f_epics_update(char*, void*);
EPICSReturnType f_epics_newsupply_read(char*, void*);
EPICSReturnType f_epics_newsupply_activate(void*);
EPICSReturnType f_epics_run(short*, void*);
EPICSReturnType f_epics_shutdown(char*, void*);
EPICSReturnType f_epics_hurrycall(short, short, void*);
#endif

#ifdef __cplusplus
	}
#endif

