/* -------------------------------------------------------------------------- */
/* Name : e_eondef.h

	 Definition der globalsten Konstanten

	 Autor : Robert Hildebrandt

	 Version 1.0 fuer Cooperativ

	 Erstellt:  30.12.09

*/
/* -------------------------------------------------------------------------- */
//#pragma warning( disable : 4820)

//#ifndef e_eondef_h
//#define e_eondef_h


#ifdef VISSIM
#define dllMode
#define UseInputdata
#endif

#ifdef RBC
#define UseInputdata
#endif

#ifdef UseInputdata
#define EPICSMultiLSAMode
#endif

#if !defined UseInputdata && !defined EPICSTRENDS
#define VSPLUS
#endif

/* -------------------------------------------------------------------------- */
/* Definition Konstanten */

//#define MAXDET 100						/* momentan nur fr die EON-Schnittstelle; allerdings wird diese eh nicht mehr gepflegt */
#define MAXPRG 33							/* Maximale Anzahl Signalprogramme; Zahl von VS-PLUS */
#define MAXMPP 30							/* Maximale Anzahl Meldepunktpaare (Folgezuege) */
#define MAXMPPTIEFE 6						/* Maximale Anzahl Anforderungen pro Folgezug  */
#define MAXPRGID 50							/* Signalprogramme mit ID > 50 werden nicht akzeptiert */
#define MAXSUBQ 4							/* Maximale Anzahl Sub-queues bzw. Meldepunktpaare pro queue */
#define THPROFILESIN 100					/* Zeithorizont [sec] der von auen bergebenen Flow-Profiles. Auf 100 definiert. timeHorizon kann abweichen! */
#define MAXPUEID 100						/* Ps mit ID > 100 werden nicht akzeptiert */
#define MAXPHASID 100						/* Phasen mit ID > 100 werden nicht akzeptiert */
#define MAXSPUR 5							/* Maximale Anzahl von Spuren in einer Zufahrt */
#ifndef VSPLUS
#define MAXMP MAXSPUR						/* Maximale Anzahl An- bzw. Abmelder in einem MPP */
#define MAXPHAS 30							/* Maximale Anzahl Phasen */
#define MAXPUE 90							/* Maximale Anzahl Phasenuebergaenge, 90 = 10*9, sodass man aus 10 Phasen in jede andere wechseln kann; ferner ist es dieselbe Obergrenze wie in CROSSIG. */
#else
#define MAXMP 1								/* Maximale Anzahl An- bzw. Abmelder in einem MPP */
#define MAXPHAS 20							/* Maximale Anzahl Phasen */
#define MAXPUE 30							/* momentan noch weniger wegen VS-PLUS */
#endif
#define MAXLENGTHPUE 100					/* maximale Lnge eines P (incl. Mindestphasendauer) */
#define MAXACTIVEPUE MAXPUE					/* Maximale Anzahl aktiver Phasenuebergaenge je Signalprogramm */
#define MINPRIO 0							/* Prioritt kann die Werte 0, 1, 2, 3 annehmen */
#define MAXPRIO 3							/* Prioritt kann die Werte 0, 1, 2, 3 annehmen */
#define DEFAULTPRIO 1						/* Default-Prioritt */
#define TSTEP 5								/* Zeitliche Laenge [sec] eines Optimierungsschritts der Groboptimierung */
#define MAXTH 255							/* irgendwo muss Schluss sein. Sonst gibt es auch rger mit dem Logfile Epics_StageSequence-1 da die Strings zu lang werden. */
#define MAXTHRED MAXTH/TSTEP
#define MAXOPTITER 10						/* Maximale Anzahl Iterationen Groboptimierung; mittlerweile hinfllig */
#define MAXWEG 999999999					/* Default Wert fuer Weglaenge */
#define WERTVERBOTEN (10*1000*1000 >> 7)	/* Bestrafung einer Sekunde im verbotenen Bereich einer Phase. >> 7 da anschlieend << 7 gerechnet. Wert so gewhlt, dass < 1/TH von long, gleichzeitig aber >= TH*1000*128 (bei einem V-Gewicht von 1000) */
#define MINWEGVERBOTEN MAXWEG - MAXSG*getTH()/* falls PI grer, ist der Weg wegen TClosedMax oder TClosedMin verboten */
#define MAXSCHALT 10						/* Maximale Anzahl Gruenzeit-Intervalle in einem Signalplan; das Problem ist, dass der TH jetzt nicht mehr konstant ist. Je lnger dieser ist, desto mehr Intervalle knnen nat. vorkommen; hnlich wie die maximale Zahl Iterationen whrend der Optimierung. */
#define MAXPHAB 30							/* Maximale Anzahl Phasen in einem Phasenablauf */
#define MINANFBREITE 2						/* Minimale Anforderungsbreite OEV; ursprnglich 6s. Verringert am 27.07.2015, da sonst bei einem Gewicht von 100 nur '16 Fz' an der Haltelinie warten. Es kann also vorkommen, dass Epics die V-Phase lnger rauszgert als gewnscht, da ein IV-Fz. z.B. 50s warten msste  */
//#define ZADAPT 102 /*40*/					/* Anpassungsfaktor [in 1/128] fuer summierten abfliessenden Verkehr (38=0.3,51=0.4,64=0.5,77=0.6,90=0.7*/
#define DUMMYNUMBER0 0						/* Zahl, die Ungltigkeit symbolisiert, z.B. wenn Wert nicht versorgt; verwendet wenn Werte > 0 erwartet werden */
#define DUMMYNUMBER1 99						/* Zahl, die Ungltigkeit symbolisiert, z.B. wenn Wert nicht versorgt */
#define DUMMYNUMBER2 255					/* Zahl, die Ungltigkeit symbolisiert, z.B. wenn Wert nicht versorgt; verwendet wenn Werte >= 99 mglich sind */
#define DUMMYNUMBERNEG -1					/* Zahl, die Ungltigkeit symbolisiert, z.B. wenn Wert nicht versorgt; verwendet wenn Werte >= 0 mglich sind */
#define TIMELIMITJAM 4						/* nach 4 Sekunden Belegung gilt Detektor als berstaut. (RiLSA empfiehlt 5s bis 15s; alllerdings geht sie von einer Detektorlnge >= 6m aus) */
#define TIMELIMITLASTCALL 10				/* wenn Epics mehr als 10s nicht aufgerufen wurde, soll es 90 Sekunden lang nur Zuschauer sein */
#define WATCHTIME 90						/* nach dem Einschalten oder Detektorstrung etc. soll EPICS 90 Sekunden lang nur Zuschauer sein */
#define EPICSVERSION 100					/* wenn mal viele EPICS im Einsatz sind, muss man aufpassen, ob das Versorgungsfile mit der EPICS-Version auf dem Steuergert kompatibel ist, d.h. wenn sich etwas an dem Versorgungs-Schema ndert, msste man hier die Version hochdrehen. */
#define ERRORNRDETGESTOERT 10005			/* Rckgabewert, falls ein Detektor gestrt */
#define ERRORNREPICSHARD 89					/* so erkennt man, dass von EPICS eine Fehlermeldung an VS-PLUS bergeben wurde. Hard bedeutet, dass der Fehler dazu fhren soll, dass EPICS nicht mehr aufgerufen wird. */
#define ERRORNREPICSTEMP 88					/* Temp bedeutet, dass der Fehler evtl. nur temporr ist */
#define WARNINGNREPICS 84					/* so erkennt man dass von EPICS eine Warnung an VS-PLUS bergeben wurde. Intern unterscheide ich Fehlermeldungen und Infomeldungen so: Fehlermeldungen beginnen mit 100, Infomeldungen mit 101 */
#define INFONREPICS 83						/* fr reine Informationen, also ohne jegliches Gefahrenpotential */

/* die Namen der diversen Logfiles */
#define fnLogDir			"Epics_Log"
#define fnMainLog			"Epics_MainLog"
#define fnDebug				"Epics_Debug"
#define fnReadSupply		"Epics_ReadSupply"
#ifdef _EMULATOR_VSPLUS_
#define	fnSignalplan		"Epics_Signalplan"
#define	fnSignalplanError	"Epics_SignalplanError"
#endif
//#define fnTestInterstages	"Epics_TestInterstages"
//#define fnTestStages		"Epics_TestStages"
#define fnQueues			"Epics_Queues"
#define fnAPValues			"Epics_APValues"
#define fnPI1				"Epics_PerformanceIndex-1"
#define	fnPI2				"Epics_PerformanceIndex-2"
//#define fnDelays			"Epics_Delays"
//#define fnDequeuing		"Epics_Dequeuing"
#define	fnNumberStops1		"Epics_NumberStops-1"
#define	fnNumberStops2		"Epics_NumberStops-2"
#define fnAction			"Epics_Action"
#define fnRuntime			"Epics_Runtime"
#define fnStageSequence1	"Epics_StageSequence-1"
#define fnStageSequence2	"Epics_StageSequence-2"
#define fnSupply			"Epics_Supply"

/* Code fr Signalgruppenzustnde (identisch zu VISSIM-Code) */
#define SG_EPICS_GREEN          1
#define SG_EPICS_RED            2
#define SG_EPICS_RED_AMBER      7
#define SG_EPICS_AMBER          8
#define SG_EPICS_GREEN_FLASHING 11


/* -------------------------------------------------------------------------- */
/* Definition Typen */

#ifndef __USE_MISC		// Unter Unix wird, wenn man stdlib.h einbindet, standardmig eine types.h-Datei (unter /usr/include/sys/) eingebunden, die die folgenden zwei Definitionen enthlt
typedef unsigned short ushort;
typedef unsigned int   uint;
#endif
typedef unsigned char  uchar;

enum {Oev, Iv, OevIv, Ped, Dummy};			/* Typ einer Anforderungs-Queue bzw. des Verkehrs; in zwei Teile unterteilt, da manche Compiler mit int rechnen, andere mit uchar */
typedef uchar anfTyp_t;

typedef struct
{
	int type;	// 15=T-time IT, 17=T-time bus, 24=T-time tram, 34=constant
	int interStageID;
	int secondInCycle;
} BAL_FSPItem;

typedef struct
{
	BAL_FSPItem frameSignalPlan[MAXVAR];
	int programID;
	double time;
	double validityInSeconds;
} BAL_FSP;


//#endif	// e_eondef_h

