

#define VISSIM

#include <assert.h>
//#include <stdio.h>
//#include <time.h>
//#include <stdlib.h>
#include <string.h>
#ifdef _WINDOWS
#include <windows.h>	// for Sleep()
#endif
//#include <iostream>
//#include <sstream>
//#include <fstream>
//#include <map>
//#include <string>
#include "e_def.h"
#include "e_shell_trends.h"

// for finding memory leaks:
/*
#define _CRTDBG_MAP_ALLOC
#ifdef _DEBUG
#ifndef DBG_NEW
#define DBG_NEW new ( _NORMAL_BLOCK , __FILE__ , __LINE__ )
#define new DBG_NEW
#endif
#endif  // _DEBUG
#include <crtdbg.h>
*/
#ifndef e_def_h
#define OBFUSCATED											// obfuscated Code to be compiled
#endif

char* EPICSXmlString;
char *netCommand;
EPICSInput_t EPICSInput;									// data from e.g. VISSIM to EPICS
EPICSOutput_t EPICSOutput;
messageText_t supplyFileName;
messageText_t commandFileName;								// BDataCommand_XXX.xml
int nrIterations;
unsigned char runRepeatable;

void generateAnf(int detID)
{
	if ((rand() % 15) == 0)
		EPICSInput.detDemand[detID] = 1;
}

void resetDetectorEvents()
{
	int i;

	for (i = 0; i <= MAXDETID; i++)
	{
		EPICSInput.detDemand[i] = 0;
		EPICSInput.detOccupancy[i] = 0;
		EPICSInput.detFailure[i] = 0;
		EPICSInput.detPriority[i] = 1;	// memset does not work here since it fills every char with 1; 256 + 1 = 257 would appear in the entries
	}
}

#ifdef OBFUSCATED
void *myEPICSData;											// controller specific data

/* Code for Signal group states (identical to VISSIM-Code)     */
/* here once again since original definitions are obfuscated */
#define SG_EPICS_GREEN          1
#define SG_EPICS_RED            2
#define SG_EPICS_RED_AMBER      7
#define SG_EPICS_AMBER          8
#define SG_EPICS_GREEN_FLASHING 11

void generateDetectorEvents()
{
	int detID;
	resetDetectorEvents();
	for (detID = 1; detID <= 256; detID++)
		generateAnf(detID);
}

void setCycleSecond()
{
	EPICSInput.tX = 0;
}

void setCycleFixedTime() 
{
}

#else
EPICSData_t *myEPICSData;									// controller specific data

void generateDetectorEvents()
{
	/* writes arbitrary numbers into the fields anf and bel					   */
	/* I guess the shortened version (OBFUSCATED) would do the job as well */
	int i, j, k;
	anf_t *anf;
	mpp_t *mpp;
	subQueueIv_t *subQueueIv;
	subQueueOev_t *subQueueOev;
	subQueuePed_t *subQueuePed;

	resetDetectorEvents();
	if ((!myEPICSData) || (!myEPICSData->lsaDef))
		return;

	for (i = 0; i < myEPICSData->lsaDef->anzAnf; i++)	// i < myEPICSData->lsaDef->anzAnf - 5 um sich auf die ersten Anforderungen zu beschr�nken
	{
		anf = &myEPICSData->lsaDef->anfD[i];
		for (j = 0; j < anf->anzSubq; j++)
		{
			if (anf->typ == Iv)
			{
				subQueueIv = &anf->subQueueIv[j];
				for (k = 0; k < subQueueIv->anzDet; k++)
				{
					generateAnf(subQueueIv->detID[k]);
				}
			}
			if (anf->typ == Oev)
			{
				subQueueOev = &anf->subQueueOev[j];
				mpp = &myEPICSData->lsaDef->mppD[subQueueOev->mppIndex];
				for (k = 0; k < mpp->anzAnmelder; k++)
				{
					generateAnf(mpp->anmelderID[k]);
				}
				for (k = 0; k < mpp->anzAbmelder; k++)
				{
					generateAnf(mpp->abmelderID[k]);
				}
			}
			if (anf->typ == Ped)
			{
				subQueuePed = &anf->subQueuePed[j];
				generateAnf(subQueuePed->detID);
			}
		}
	}
}

void setCycleSecond()	// without e.g. TRENDS in the background one has to calculate the cycle second oneself
{
	uchar tu;

	if (myEPICSData && myEPICSData->lsaDef && EPICSInput.program > 0 && EPICSInput.program <= MAXPRGID)
	{
		tu = myEPICSData->lsaDef->prgD[myEPICSData->IntlPrgIndex[EPICSInput.program]].tu;
		if (EPICSInput.callingMode == 0)
			EPICSInput.tX = (myEPICSData->time + 1 + 72 - 73) % tu;	// since time is incremented during the call; +72 um etwas Willk�r ins Spiel zu bringen
		else
			EPICSInput.tX = (myEPICSData->time + 0 + 72 - 72) % tu;	// for the test cases no update in tX has been used
		EPICSInput.tX = (myEPICSData->time + 70) % tu;
	}
	else
		EPICSInput.tX = 0;
}

// in the following I try to derive for each program the fixed-time-cycle from the intervals
// Does not necessarily work. Only useful if xml file read. Else contained in supply anyway.
void setCycleFixedTime()
{
	uchar spIndex, phIndex1, phIndex2, pueIndex, cycleIndex;
	uchar stageStart, stageEnd, interstageFound;
	prg_t *prg;
	ph_t *phas1, *phas2;
	pue_t *pue;
	lsaDef_t *lsaD = myEPICSData->lsaDef;

	for (spIndex = 0; spIndex < lsaD->anzPrg; spIndex++)
	{
		cycleIndex = 0;
		prg = &lsaD->prgD[spIndex];
		if (prg->cycleFixedTime[0].interStageID > 0)
			return;	// obviously sig file read
		for (phIndex1 = 0; phIndex1 < lsaD->anzPh; phIndex1++)
		{
			phas1 = &lsaD->phD[phIndex1];
			if (phas1->param[spIndex].costPreferred > 0)	// only desired stages considered
				continue;
			interstageFound = 0;
			stageEnd = phas1->param[spIndex].preferredEnd;
			for (phIndex2 = 0; phIndex2 < lsaD->anzPh; phIndex2++)
			{
				phas2 = &lsaD->phD[phIndex2];
				if (phas2->param[spIndex].costPreferred > 0)// only desired stages considered
					continue;
				if (phas1 == phas2)							// obviously non sense
					continue;

				stageStart = phas2->param[spIndex].preferredStart;
				if (stageStart < stageEnd)
					stageStart += prg->tu;
				for (pueIndex = 0; pueIndex < lsaD->anzPue; pueIndex++)
				{
					pue = &lsaD->pueD[pueIndex];
					if ((pue->fromStageID == phas1->ID) && (pue->toStageID == phas2->ID) && (abs(stageStart - stageEnd - myEPICSData->originalPueDauer[pueIndex]) < 2))
					{
						prg->cycleFixedTime[cycleIndex].interStageID = (uchar)pue->ID;
						prg->cycleFixedTime[cycleIndex].secondInCycle = stageEnd + 1;
						if (prg->cycleFixedTime[cycleIndex].secondInCycle >= prg->tu)
							prg->cycleFixedTime[cycleIndex].secondInCycle -= prg->tu;
						interstageFound = 1;
						cycleIndex++;
						break;
					}
				}
				if (interstageFound)
					break;
			}
			if (!interstageFound)
			{
				prg->cycleFixedTime[0].interStageID = 0;	// not successful
				break;
			}
		}
		prg->cycleFixedTime[cycleIndex].interStageID = 0;
		prg->cycleFixedTime[cycleIndex].secondInCycle = 0;
	}
}

#endif

void readEPICSSupply()
{
	size_t size;

	//std::ifstream EPICSXmlFile(supplyFileName);
	//std::ostringstream buffer;
	FILE* f = fopen(supplyFileName, "r");
	if (f)
	{
		fseek(f, 0, SEEK_END);
		size = ftell(f);
		rewind(f);
		EPICSXmlString = malloc(size + 1);
		if (EPICSXmlString)
			fread(EPICSXmlString, sizeof(char), size, f);
		fclose(f);
	}
	//buffer << EPICSXmlFile.rdbuf(); // std::ostream& operator<<(std::ostream&, std::streambuf*) reads the complete content
	//EPICSXmlString = buffer.str();
}

void readNetCommand()
{
	size_t size;

	if (strlen(commandFileName) > 0)
	{
		FILE* f = fopen(commandFileName, "r");
		if (f)
		{
			fseek(f, 0, SEEK_END);
			size = ftell(f);
			rewind(f);
			if ((!netCommand) || (size > strlen(netCommand)))
			{
				free(netCommand);
				netCommand = malloc(size + 1);
			}
			if (netCommand)
				fread(netCommand, sizeof(char), size, f);
			fclose(f);
		}
		else
		{
			free(netCommand);
			netCommand = NULL;
		}
	}
}

void initRandomizer()
{
	time_t t;

	if (runRepeatable)
		return;

	time(&t);
	srand((unsigned int)t);              /* initialize randomizer */
}

void initEPICSInput()
{
	int i;

	resetDetectorEvents();
	initRandomizer();			// without this routine the runs are repeatable
	EPICSInput.callingMode = 0;
	EPICSInput.program = 0;		// set to first program afterwards
	EPICSInput.tX = 0;
	EPICSInput.deltaT = 1;
	EPICSInput.language = 1;
	sprintf_s(EPICSInput.nodeName, sizeof(EPICSInput.nodeName), "%s", supplyFileName);
	for (i = 0; i <= MAXMPPID; i++)
	{
		EPICSInput.numberPTVehicles[i] = -1;
	}
	for (i = 0; i <= 255; i++)
	{
		EPICSInput.signalState[i] = -1;
	}
	EPICSInput.netCommand = 0;
// the following is Output, but should be initialized as well
	memset(EPICSOutput.action, 0, (MAXSGID + 1) * sizeof(short));
}

void getSignalbild()
{
	int sgID;

	for (sgID = 1; sgID <= 255; sgID++)
	{
		if (EPICSOutput.action[sgID] != 0)
			EPICSInput.signalState[sgID] = EPICSOutput.action[sgID];
	}
}

void showJsonStrings() {
	int i;

	for (i = 0; i < 6; i++)
	{
		printf("%s", EPICSOutput.jsonStrings[i]);
		printf("\n");
	}
}

void showBasics()
{
	if (myEPICSData)
		printf("%4ld ", myEPICSData->time);
	else
		printf("%4d ", 0);

	printf("%4d ", EPICSInput.tX);
	//printf("%3d ", EPICSInput.program);
}

void showMessages(short returnValue)
{
	int i;
	messageText_t output;

	for (i = 0; i < EPICSOutput.numberMessages; i++)
	{
		showBasics();
		sprintf_s(output, LENGTHLOGSTRING, "%d   %s (importance: %d, return value: %d)", EPICSOutput.messages[i].messageNumber, EPICSOutput.messages[i].messageText, EPICSOutput.messages[i].importance, returnValue);
		terminateString(output);
		printf("%s", output);	// preferred by gcc with respect to printf(output);
		printf("\n");
	}
}

void showSignalbild()
{
	int i, sgID;

	getSignalbild();
	showBasics();
#ifndef OBFUSCATED
	for (i = 0; i < myEPICSData->lsaDef->anzRealSgr; i++)
	{
		sgID = myEPICSData->lsaDef->sgrD[i].ID;
#else
	for (i = 1; i <= 20; i++)
	{
		sgID = i;
#endif
		if (EPICSInput.signalState[sgID] == SG_EPICS_RED)
			printf("   -");
		else if (EPICSInput.signalState[sgID] == SG_EPICS_GREEN)
			printf("   |");
		else if (EPICSInput.signalState[sgID] == SG_EPICS_RED_AMBER)
			printf("   /");
		else if (EPICSInput.signalState[sgID] == SG_EPICS_AMBER)
			printf("   +");
		else if (EPICSInput.signalState[sgID] == SG_EPICS_GREEN_FLASHING)
			printf("   *");
		else
			printf("   ?");
	}
	printf(" Cmd:%d", EPICSOutput.stage);	// switching command, f�r Strasbourg; kann sp�ter wieder auskommentiert werden
	for (i = 0; i < 9; ++i)
	{
		if (i == 6)		// initialized?
			continue;
		printf(" ");
		if (i == 0)
			printf("T:");
		if (i == 1)
			printf("tX:");
		if (i == 2)
			printf("st:");
		if (i == 3)
			printf("nds:");
		if (i == 4)
			printf("P:");
		if (i == 5)
			printf("TU:");
		if (i == 7)
			printf("PI1:");
		if (i == 8)
			printf("PI2:");
		printf("%i", EPICSOutput.APValuesGeneral[i]);
	}
	printf("\n");

	//showJsonStrings();
}

short callEPICS(short callingMode, char *xml, char *command)
{
	void *EPICSData_void = myEPICSData;
	short result;

	EPICSInput.callingMode = callingMode;
	EPICSInput.netCommand = command;
	setCycleSecond();
	result = Epics_Shell(&EPICSInput, &EPICSOutput, &EPICSData_void, xml);
#ifdef OBFUSCATED
	myEPICSData = EPICSData_void;
#else
	myEPICSData = (EPICSData_t*)EPICSData_void;
#endif
	showMessages(result);
	if (callingMode == 0)
		showSignalbild();
	return result;
}

short doInit()
{
	short result;

	initEPICSInput();
	readEPICSSupply();
	result = callEPICS(2, EPICSXmlString, 0);
	free(EPICSXmlString);
	return result;
}

int fileExists(const char *fname)
{
	FILE *file = fopen(fname, "r");
	if (file)
	{
		fclose(file);
		return 1;
	}
	return 0;
}

void CleanUp()
{
	callEPICS(-1, 0, 0);
}

void doCalculate()
{
	unsigned char i;
	int j;
	short prgWunsch;

	setCycleFixedTime();

#ifndef OBFUSCATED
	for (i = 0; i < myEPICSData->lsaDef->anzPrg; i++)
	{
		prgWunsch = myEPICSData->lsaDef->prgD[i].ID;
#else
	for (i = 1; i <= 1; i++)
	{
		prgWunsch = i; 
#endif
		for (j = 0; j < nrIterations; j++)
		{
			if ((EPICSInput.program != prgWunsch) && (prgWunsch > 0) && (prgWunsch <= MAXPRGID))
			{
				//prgWunsch = 3;	// Test f�r Strasbourg 711
				EPICSInput.program = prgWunsch;
				callEPICS(1, 0, 0);				// try to switch program
				//EPICSInput.program = 11;	// Test f�r Strasbourg 711
			}
//			if (j < 50)
//				EPICSInput.program = 21;		// 'switching program'
//			else
//				EPICSInput.program = prgWunsch;
			generateDetectorEvents();
			readNetCommand();
			
			if (j == 500)	// the following test of remote supply is also part of the test cases
			{
				strcat(supplyFileName, "_");		// hand down different supply
				if (fileExists(supplyFileName))
				{
					readEPICSSupply();
					callEPICS(3, EPICSXmlString, 0);// read remote supply
					free(EPICSXmlString);
				}
			}
			if ((j == 505) && (fileExists(supplyFileName)))
			{
				callEPICS(4, 0, 0);					// activate remote supply
#ifndef OBFUSCATED
				if (!myEPICSData->lsaDef)			// e.g. remote supply with errors
					return;
#endif
				setCycleFixedTime();
			}

			if ((j > 0) && (j % 300 == 0))
				callEPICS(0, 0, netCommand);
			else
				callEPICS(0, 0, 0);
		}
	}
}

unsigned char demandDetector(int index, int detID)
{
	if (index % 2 == 1)
	{
		EPICSInput.detDemand[detID] = 1;
		EPICSInput.detOccupancy[detID] = 100;
	}
	return EPICSOutput.stage > 0;
}

unsigned char demandDetectorEven(int index, int detID)
{
	if (index % 2 == 0)
	{
		EPICSInput.detDemand[detID] = 1;
		EPICSInput.detOccupancy[detID] = 100;
	}
	return EPICSOutput.stage > 0;
}

unsigned char failDetector(int detID)
{
	EPICSInput.detFailure[detID] = 1;
	return EPICSOutput.stage > 0;
}

// the following test cases have been written for Strasbourg
// the first 13 cases use the simple test node from Florian Schubert: exemple_sig1.sig
// the other cases use the original node 713
void runTestCase(int nrTestCase)
{
	void *EPICSData_void = myEPICSData;
	unsigned char stopped = 0;
	unsigned char tramHasGreen = 0;
	short result = 1;
	int j;
	int startT1;
	int startT2;

	//for (j = 0; j < 90; j++)
	//{
	//	if ((EPICSInput.program != -1))
	//	{
	//		EPICSInput.program = -1;
	//		result = callEPICS(1, 0, 0);	// try to switch 'switch-on program'
	//	}
	//	resetDetectorEvents();
	//	result = callEPICS(0, 0, 0);
	//}

	if (nrTestCase < 13)
		EPICSInput.program = 1;
	else if (nrTestCase < 100)
		EPICSInput.program = 3;
	else if (nrTestCase < 70908)
		EPICSInput.program = 11;
	else
		EPICSInput.program = 5;
	if (nrTestCase == 71004)
		EPICSInput.program = 11;
	result = callEPICS(1, 0, 0);

	for (j = 0; j < nrIterations; j++)
	{
		resetDetectorEvents();
		if (nrTestCase / 100 == 709 || nrTestCase / 1000 == 709)
			tramHasGreen = EPICSInput.signalState[20] == SG_EPICS_GREEN || EPICSInput.signalState[20] == SG_EPICS_GREEN_FLASHING;
		if (nrTestCase / 100 == 710)
			tramHasGreen = EPICSInput.signalState[20] == SG_EPICS_GREEN || EPICSInput.signalState[20] == SG_EPICS_GREEN_FLASHING;

		if (nrTestCase == 0)	// default run without traffic; would also happen if one would hand over e.g. nrTestCase = 99
		{
			// nothing to do
		}
		else if (nrTestCase == 1)	// prolong stage 1
		{
			if (!stopped && (j >= 200)) 
			{
				stopped = demandDetector(j, 1);
			}
		}
		else if (nrTestCase == 2)	// prolong stage 2
		{
			if (!stopped && (j >= 140)) 
			{
				stopped = demandDetector(j, 2);
			}
		}
		else if (nrTestCase == 3)	// prolong stage 3
		{
			if (!stopped && (j >= 165)) 
			{
				stopped = demandDetector(j, 3);
			}
		}
		else if (nrTestCase == 4)	// shorten stage 1
		{
			if (!stopped && (j >= 180)) 
			{
				stopped = demandDetector(j, 2);
			}
		}
		else if (nrTestCase == 5)	// shorten stage 2
		{
			if (!stopped && (j >= 130))
			{
				stopped = demandDetector(j, 3);
			}
		}
		else if (nrTestCase == 6)	// shorten stage 3
		{
			if (!stopped && (j >= 150))
			{
				stopped = demandDetector(j, 1);
			}
		}
		else if (nrTestCase == 7)	// failure of an essential detector
		{
			if (!stopped && (j >= 150))
			{
				stopped = failDetector(1);
			}
		}
		else if (nrTestCase == 8)	// pause Epics call
		{
			if (j == 150)
			{
				printf("Sleeping for 12 seconds\n");
#ifdef _WINDOWS				
				Sleep(12000);		// funktioniert nur unter _WINDOWS
#endif
			}
		}
		else if (nrTestCase == 9)	// hard supply error
		{
			// for this test one has to manipulate the sig file
		}
		else if (nrTestCase == 10)	// hard run time error - wrong tX or unknown program; remark: for calling mode 1 tX is no longer checked. Therefore it does not have to be set sensibly.
		{
			if (j >= 150)
			{
				EPICSInput.tX = 91;
				//EPICSInput.program = 22;
				result = Epics_Shell(&EPICSInput, &EPICSOutput, &EPICSData_void, 0);
				showMessages(result);
				//showSignalbild();
				//continue;
			}
		}
		else if (nrTestCase == 11)	// remote supply; can be used for two test cases: successful and unsuccessful. For the second test one has to manipulate the sig file
		{
			if (j == 300)
			{
				strcat(supplyFileName, "_");		// hand down different supply
				if (fileExists(supplyFileName))
				{
					readEPICSSupply();
					result = callEPICS(3, EPICSXmlString, 0);// read remote supply
					free(EPICSXmlString);
				}
			}
			if ((j == 305) && (fileExists(supplyFileName)))
			{
				result = callEPICS(4, 0, 0);		// activate remote supply
			}
		}
		else if (nrTestCase == 12)	// program switch
		{
			if (j > 237 && j < 350)
			{
				if ((EPICSInput.program != 2))
				{
					EPICSInput.program = 2;
					result = callEPICS(1, 0, 0);				// try to switch program; variation: replace program 2 by program 22 (try to switch to unknown program)
				}
			}
			if (j > 350)
			{
				if ((EPICSInput.program != 1))
				{
					EPICSInput.program = 1;
					result = callEPICS(1, 0, 0);
				}
			}
		}
		else if (nrTestCase == 13)	// trigger calling point
		{
			if (j == 285)
				demandDetector(j, 162);
		}
		else if (nrTestCase == 14)	// regular logoff
		{
			if (j == 271)
				demandDetector(j, 162);
			if (j == 291)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 15)	// forced logoff
		{
			if (j == 271)
				demandDetector(j, 162);
		}
		else if (nrTestCase == 16)	// stage on demand
		{
			if (j == 271)
				demandDetector(j, 2);
		}
		else if (nrTestCase == 17)	// ghost signal group
		{
			if (j == 271)
				demandDetector(j, 2);
			if (j == 273)
				demandDetector(j, 162);
		}
		else if (nrTestCase == 18)	// failure of a non-essential detector
		{
			if (!stopped && (j >= 150))
			{
				stopped = failDetector(51);
			}
		}
		else if (nrTestCase == 31)	// re-initialization, asked for by Fabio Molteni from SCAE
		{
			if (j == 200) {
				CleanUp();
				doInit();
				EPICSInput.program = 3;
				result = callEPICS(1, 0, 0);
			}
		}
		//else if (nrTestCase == 99)	// delta T; the reaction is interesting but it is no real test of the interface
		//{
		//	if (j == 283)
		//		EPICSInput.deltaT = 20;
		//	else
		//		EPICSInput.deltaT = 1;
		//}
		//else if (nrTestCase == 99)	// too many PuT vehicles; test does not work, since at most 6 vehicles are counted in
		//{
		//	if (j >= 285)
		//		demandDetector(j, 162);
		//}
		else if (nrTestCase == 70901)	// Erkl�rung folgt unten, durchgef�hrt mit P11, Versorgung veraltet daher nicht mehr reproduzierbar
		{
			startT1 = 295;
			startT2 = 323;
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 18)
				demandDetector(j, 162);
			if (j == startT1 + 26)
				demandDetector(j, 163);
			if (j > startT1 + 36 && tramHasGreen)
				demandDetector(j, 169);
			//if (j == startT2)// kam nicht
			//	demandDetector(j, 151);
			if (j == startT2 + 14)
				demandDetector(j, 152);
			if (j == startT2 + 22)
				demandDetector(j, 153);
			if (j > startT2 + 30 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70902)	// Erkl�rung folgt unten, durchgef�hrt mit P11, Versorgung veraltet daher nicht mehr reproduzierbar
		{
			startT1 = 277;
			startT2 = 257;
			if (j > 174 && j < 186)
				demandDetector(j, 3);	// um Phase 1 auf 20s zu verk�rzen und Phase 2 auf 10s zu verl�ngern
			//if (j == startT2)// kam nicht
			//	demandDetector(j, 151);
			if (j == startT2 + 14)
				demandDetector(j, 152);
			if (j == startT2 + 22)
				demandDetector(j, 153);
			if (j > startT2 + 30 && tramHasGreen)
				demandDetector(j, 159);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 22)
				demandDetector(j, 162);
			if (j == startT1 + 30)
				demandDetector(j, 163);
			if (j > startT1 + 36 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 70903)	// durchgef�hrt mit P11; Fall 5) vom 21.2.
		{
			startT2 = 209;
			if (j > 150 && j < 160)
				demandDetector(j, 2);	// um Phase 4 auf 13s zu verl�ngern
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 16)//16
				demandDetector(j, 152);
			if (j == startT2 + 22)
				demandDetector(j, 153);
			if (j > startT2 + 30 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70904)	// durchgef�hrt mit P11; Fall 4) vom 21.2.
		{
			startT1 = 287;
			if (j > 170 && j < 174)
				demandDetector(j, 2);	// um Phase 1 zu verk�rzen
			if (j > 170 && j < 174)
				demandDetector(j, 3);	// um Phase 1 zu verk�rzen
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 12)
				demandDetector(j, 162);
			if (j == startT1 + 20)
				demandDetector(j, 163);
			if (j > startT1 + 30 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 70905)	// durchgef�hrt mit P11; Fall 3) vom 21.2. nicht zu reproduzieren.
		{
			startT1 = 285;
			startT2 = startT1 - 8;
			if (j == 265)
				demandDetector(j, 3);
			if (j == 283 || j == 293)
				demandDetector(j, 2);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 20)
				demandDetector(j, 162);
			if (j == startT1 + 28)
				demandDetector(j, 163);
			if (j > startT1 + 38 && tramHasGreen)
				demandDetector(j, 169);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 20)
				demandDetector(j, 152);
			if (j == startT2 + 28)
				demandDetector(j, 153);
			if (j > startT2 + 38 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70906)	// durchgef�hrt mit P11; Fall 2) vom 21.2. Der Klassiker
		{
			startT2 = 245;
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 16)
				demandDetector(j, 152);
			if (j == startT2 + 22)
				demandDetector(j, 153);
			if (j > startT2 + 30 && j < startT2 + 30 + 28 && tramHasGreen)
				demandDetector(j, 159);
			startT1 = startT2 + 28;
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 22)
				demandDetector(j, 162);
			if (j == startT1 + 30)
				demandDetector(j, 163);
			if (j > startT1 + 38 && tramHasGreen)
				demandDetector(j, 169);
			startT2 = startT1 + 26;
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 22)
				demandDetector(j, 152);
			if (j == startT2 + 30)
				demandDetector(j, 153);
			if (j > startT2 + 38 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70907)	// durchgef�hrt mit P11; Fall 1) vom 21.2. nicht zu reproduzieren.
		{
			if (j > 220 && j < 225)
				demandDetector(j, 3);
			startT2 = 247 + 34;
			startT1 = 247 - 4;// wurde zwangsabgemeldet
			if (j > 247 - 15 && j < 247 - 11)
				demandDetector(j, 3); 
			// es kann sein, dass dieser Detektor f�r den vorzeitigen Phasenabbruch verantwortlich ist. 
			// Wenn dann sehe ich den Abbruch aber fr�her. In jedem Fall wird hier Phase 3 aufgehalten.
			//if (j > 247 - 5 && j < 247 + 1 + 0)
			//	demandDetector(j, 2);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 16)
				demandDetector(j, 152);
			if (j == startT2 + 22)
				demandDetector(j, 153);
			if (j > startT2 + 30 && tramHasGreen)
				demandDetector(j, 159);
			startT1 = startT2 + 10;
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 30)
				demandDetector(j, 162);
			if (j == startT1 + 38)
				demandDetector(j, 163);
			if (j > startT1 + 46 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 70908)	// durchgef�hrt mit P5; erstellt wegen EP-136 um zu testen, in wie weit das (Nicht-)Stauchen der Tram vor einem Meldepunkt eine Rolle spielt.
		{
			startT2 = 299;
			startT1 = startT2 - 32;
			if (j == startT2 - 20)
				demandDetector(j, 2);
			if (j == startT2 - 20)
				demandDetector(j, 3);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 20)
				demandDetector(j, 162);
			if (j == startT1 + 28)
				demandDetector(j, 163);
			if (j > startT1 + 41 && tramHasGreen)
				demandDetector(j, 169);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 18)
				demandDetector(j, 152);
			if (j == startT2 + 24)
				demandDetector(j, 153);
			if (j > startT2 + 32 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70909)	// durchgef�hrt mit P5; erstellt wegen EP-137
		{
			startT2 = 267;
			startT1 = startT2 + 8;
			if (j >= startT2 - 50 && j <= startT2 - 40)
				demandDetector(j, 2);
			if (j == startT2 - 24)
				demandDetector(j, 2);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 20)
				demandDetector(j, 162);
			if (j == startT1 + 28)
				demandDetector(j, 163);
			if (j > startT1 + 41 && tramHasGreen)
				demandDetector(j, 169);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 8)
				demandDetector(j, 152);
			if (j == startT2 + 24)
				demandDetector(j, 153);
			if (j > startT2 + 32 && tramHasGreen)
				demandDetector(j, 159);
		}
		else if (nrTestCase == 70910)	// durchgef�hrt mit P5; erstellt wegen EP-138; der 'invertierte Klassiker': Epics h�lt die Phase f�r die erste Tram offen, die zweite muss warten.
		{
			startT2 = 295;
			startT1 = startT2 + 14;
			if (j >= 228 && j <= 240)
				demandDetector(j, 2);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 6)
				demandDetector(j, 152);
			if (j == startT2 + 12)
				demandDetector(j, 153);
			if (j > startT2 + 25 && tramHasGreen)
				demandDetector(j, 159);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 6)
				demandDetector(j, 162);
			if (j == startT1 + 16)
				demandDetector(j, 163);
			if (j > startT1 + 25 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 70911)	// durchgef�hrt mit P5; erstellt wegen EP-138; der 'Klassiker': Epics bricht die Phase bei Anmeldung der zweiten Tram ab, die erste muss warten.
		{
			startT2 = 301;
			startT1 = startT2 + 10;
			if (j >= 228 && j <= 240)
				demandDetector(j, 2);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 6)
				demandDetector(j, 152);
			if (j == startT2 + 12)
				demandDetector(j, 153);
			if (j > startT2 + 25 && tramHasGreen)
				demandDetector(j, 159);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 6)
				demandDetector(j, 162);
			if (j == startT1 + 16)
				demandDetector(j, 163);
			if (j > startT1 + 25 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 709139)	// durchgef�hrt mit P5; erstellt wegen EP-138; der 'Klassiker': Epics bricht die Phase bei Anmeldung der zweiten Tram ab, die erste muss warten.
		{
			startT2 = 301;
			startT1 = startT2 + 10;
			if (j >= 228 && j <= 240)
				demandDetector(j, 2);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 6)
				demandDetector(j, 152);
			if (j == startT2 + 12)
				demandDetector(j, 153);
			//if (j > startT2 + 25 && tramHasGreen)
			//	demandDetector(j, 159);
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 6)
				demandDetector(j, 162);
			if (j == startT1 + 16)
				demandDetector(j, 163);
			//if (j > startT1 + 25 && tramHasGreen)
			//	demandDetector(j, 169);
		}
		else if (nrTestCase == 71001)	// durchgef�hrt mit P5
		{
			startT1 = 163;
			if (j >= 162 && j <= 164)
				demandDetector(j, 6);
			if (j >= 162 && j <= 172)
				demandDetector(j, 2);
			if (j == startT1)
				demandDetector(j, 161);
			//if (j == startT1 + 18)
			//	demandDetector(j, 162);
			//if (j == startT1 + 22)
			//	demandDetector(j, 163);
			if (j == startT1 + 28)
				demandDetector(j, 168);
			if (j == startT1 + 48 && tramHasGreen)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 71002)	// durchgef�hrt mit P5
		{
			startT2 = 191;
			if (j >= 160 && j <= 190)
				demandDetector(j, 6);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 14)
				demandDetector(j, 161);
			if (j == startT2 + 14)
				demandDetector(j, 152);
			if (j == startT2 + 30)
				demandDetector(j, 159);
			//if (j == startT2 + 84)
			//	demandDetector(j, 161);
		}
		else if (nrTestCase == 71003)	// durchgef�hrt mit P5
		{
			startT2 = 191;
			//if (j >= 160 && j <= 190)
			//	demandDetector(j, 6);
			if (j == startT2)
				demandDetector(j, 161);
			if (j == startT2 + 14)
				demandDetector(j, 152);
			if (j == startT2 + 30)
				demandDetector(j, 159);
			if (j == startT2 + 84)
				demandDetector(j, 161);
		}
		else if (nrTestCase == 71004)	// durchgef�hrt mit P11
		{
			startT2 = 77;
			if (j == 101 || j == 103)
				demandDetector(j, 6);
			if (j == startT2)
				demandDetector(j, 161);
			//if (j == startT2 + 18)
			//	demandDetector(j, 162);	// Vermutung: Zweite Anmeldung bleibt aus. Dritte bleibt sowieso aus. Oder die erste wird zweimal �bertragen.
			if (j == startT2 + 28)
				demandDetector(j, 168);
			if (j == startT2 + 44)
				demandDetector(j, 169);
			startT2 = startT2 + 44 + 8;
			if (j == startT2)
				demandDetector(j, 161);
			//if (j == startT2 + 16)
			//	demandDetector(j, 162);
			if (j == startT2 + 24)
				demandDetector(j, 168);
			if (j == startT2 + 44)
				demandDetector(j, 169);
		}
		else if (nrTestCase == 70999)
		{
			// Im Folgenden habe ich einige Tests gemacht, bei denen ich zwei Trams in entgegengesetzter Richtung an der 709 einspeise.
			// Die Trams kamen meist zeitlich versetzt, sodass die zweite Tram einen spontanen Phasenabbruch bewirkte. Oder sie kam erst nach Ende von Phase 1.
			// Folgende Probleme wurden beobachtet (vgl. auch Email von mir vom 20.02.2018, 22,02.2018): 
			// 1) Tram 1 meldet sich w�hrend Phase 1 an, Epics will die Phase f�r die Tram aufhalten. 
			// Etwa 12s bevor diese Tram ankommt meldet sich eine andre an. Epics kann die Phase nicht auch noch f�r diese aufhalten und entschlie�t sich, die Phase sofort zu verlassen und �ber Phase 3 zu gehen. Tram 1 muss bis zu 11s warten.
			// 2) Tram 1 meldet sich w�hrend Phase 1 an, Epics h�lt die Phase noch auf, um �ber Phase 3 zu gehen. Kurz vor oder nach Ende von Phase 1 meldet sich eine andere Tram an.
			// Epics kann Phase 3 nicht lange aufhalten wegen Phase 4. Es hat zwei M�glichkeiten: Phase 3 kurz einschalten (dann wartet Tram2) oder Phase 3 nicht zu schalten (dann wartet Tram1) 
			// das Problem bei meinen Tests ist, dass die Reisezeit der Tram ziemlich genau eingehalten wird. In der Realit�t besteht die erste Anmeldung darin, dass der Fahrer aktiv einen Knopf dr�ckt.
			// das ist zeitlich nicht klar definiert. Drum sieht man auch manchmal, dass eine Tram zum zweiten MP 10s l�nger braucht als erwartet.

			// diese Tests wurden angesto�en durch die erste Scharfschaltung von Epics an der 709, da einige Trams halten mussten.
			// 1) die ersten zwei Trams, die warten mussten (15:01:13/15:01:35); TestCase 70901 
			// die erste muss warten, weil Epics 40s travel time versorgt hat, die Tram aber viel schneller (35s) ist und Epics daher Phase 1 zu lange aufh�lt, bevor es in Phase 3 geht.
			// die zweite (Anmeldung w�hrend �bergang 1->2) muss warten, da Epics Phase 3 nicht aufhalten kann, da es TClosedMax von Phase 4 verletzen w�rde
			// 2) die letzten zwei Trams, die warten mussten (15:48:42/15:49:10); TestCase 70902
			// Zun�chst m�chte Epics Phase 1 f�r die erste angemeldete Tram aufhalten, dann meldet sich eine weitere an und Epics �ndert den Plan.
			// Es muss den Umweg �ber Phase 3 gehen, kann daher Phase 1 nicht mehr lange genug aufhalten (zumindest mit hoher Wahrscheinlichkeit)
			// und bricht sie sofort ab. Phase 3 kann auch nicht so lange aufgehalten werden, dass die zweite Tram sicher durch kommt, daher 
			// wird sie nur das Minimum gehalten.

			// nun die Tests:

			// Urspr�nglich hatte ich keine maximale Phasendauer und TClosedMax = 110 �berall; 
			// Obiges Problem 1 schl�gt nat. zu. Tram 1 muss bis zu 13s warten. Ist der Weg �ber Phase 3 nicht mehr erlaubt, da sonst die max. Gesperrtzeit von Phase 4 verletzt w�rde, so wartet Tram 1 sogar noch l�nger. 
			// Es geht sogar noch schlimmer: Phase 3 wird geschaltet aber Tram2 verpasst sie und wartet ebenfalls sehr lange, da diese nicht aufgehalten werden kann.

			// Zun�chst dachte ich, es macht Sinn, eine maximale Phasendauer von 70s f�r Phase 1 einzustellen. TClosedMax = 110 wurde �berall belassen; 
			// Die Idee war schlecht. Denn das Problem, dass die Phase f�r die erste Tram aufgehalten werden kann, f�r die zweite aber nicht mehr, besteht nat�rlich genauso. 
			// Ferner nimmt man dem zweiten Optimierungsschritt Flexibilit�t: Er muss sich u.U. entscheiden, ob er Phase 1 20s oder 30s weiter offen h�lt 
			// (feiner ist die Abstufung momentan nicht). 30s k�nnnen verboten sein wegen der Obergrenze, 20 k�nnen zu wenig sein.
			
			// der n�chste Testlauf hatte keine maximale Phasendauer, aber TClosedMax = 130 f�r Phase 4, 110 sonst;
			// auch hier kommt es nat. zu Situationen, in denen eine Tram halten muss (Problem 1 oder 2). Dennoch eine deutliche Verbesserung.

			// die Kombination 'maximale Phasendauer von 70s, TClosedMax = 130 f�r Phase 4' brachte keine Verbesserung
			startT1 = 195;
			startT2 = 221;
			if (j == startT1)
				demandDetector(j, 161);
			if (j == startT1 + 16)
				demandDetector(j, 162);
			if (j == startT1 + 24)
				demandDetector(j, 163);
			if (j > startT1 + 34 && tramHasGreen)
				demandDetector(j, 169);
			if (j == startT2)
				demandDetector(j, 151);
			if (j == startT2 + 12)
				demandDetector(j, 152);
			if (j == startT2 + 20)
				demandDetector(j, 153);
			if (j > startT2 + 30 && tramHasGreen)
				demandDetector(j, 159);
		}
		if (result != 0)	// also with -3 I let run the fallback mode. In reality it might behave differently.
			result = callEPICS(0, 0, 0);
		if (result == 0)
			break;
	}
}

int main(int argc, char* argv[])
{
//	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);		// for finding memory leaks:
//	char *test = (char*)malloc(64);	// memory leak for testing crtdbg
	short result = 0;
	nrIterations = 1200;
	myEPICSData = 0;
	netCommand = 0;
	strcpy(supplyFileName, "EPICS.xml");
	runRepeatable = 1;
	int nrTestCase = -1;
	if (argc > 1)
	{
		sprintf_s(supplyFileName, LENGTHLOGSTRING, "%s", argv[1]);
		terminateString(supplyFileName);
	}
	commandFileName[0] = '\0';
	if (argc > 2)
		nrIterations = atoi(argv[2]);			// in case of error atoi returns 0 and the program is finished
	if (argc > 3)
	{
		sprintf_s(commandFileName, LENGTHLOGSTRING, "%s", argv[3]);
		terminateString(commandFileName);
	}
	if (argc > 4)
		runRepeatable = (atoi(argv[4]) == 1);
	if (argc > 5)
	{
		nrTestCase = atoi(argv[5]);
		if (nrTestCase < 13)
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Einzelknoten\\exemple_sig1.sig");	// sp�ter �ndern in TestCasesSimple.sig (eingecheckt)
		else if (nrTestCase < 100)
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Colmar\\180109_Av_Colmar_epics_det_act\\170628a_Av_Colmar713_epics_2tram_det_22.sig");	// sp�ter �ndern in TestCasesAdvanced.sig (eingecheckt)
		else
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Colmar\\180109_Av_Colmar_epics_det_act\\180221a_Av_Colmar709_epics_rh.sig");
		if (nrTestCase == 70909)
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Colmar\\180109_Av_Colmar_epics_det_act\\180221a_Av_Colmar709_epics_testdeca2_IPH_red.sig");
		if (nrTestCase == 70910 || nrTestCase == 70911)
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Colmar\\180109_Av_Colmar_epics_det_act\\180221a_Av_Colmar709_epics_testdeca2_IPH_red110150_iph3bb.sig");
		if (nrTestCase == 709139)
			strcpy(supplyFileName, "Av_Colmar709_epics139.sig");
		if (nrTestCase == 71001 || nrTestCase == 71002 || nrTestCase == 71003 || nrTestCase == 71004)
			strcpy(supplyFileName, "C:\\Projekte\\Strasbourg\\Colmar\\Live-Tests\\710_25_06_17h\\180522_Av_Colmar_prime_710_HPHC_redmax2.sig");
	}
	if (!fileExists(supplyFileName))
		return 0;
	result = doInit();
#ifndef OBFUSCATED
	if (result != 0)
#else
	if (1)		// trivial but true...
#endif
	{
		if (nrTestCase >= 0)
			runTestCase(nrTestCase);
		else
		{
			showJsonStrings();
			doCalculate();
		}
	}
	else
	{
		printf("Signal-control data not assigned. Probably supply error.\n");
	}

	if (netCommand)
		free(netCommand);
	CleanUp();	// free memory

#ifdef _WINDOWS
	system("Pause");
#endif
	return 0;
}


