#include "mbed.h"
#include "platform/mbed_thread.h"
#include "clubbing.h"
#include "EthernetSetup.h"
#include "UdpClients.h"
#include "doHTML.h"

extern EthernetInterface *gp_eth;
extern C_HTMLparse * gpc_html;

#if NO_UDP
static struct S_EthernetAddress_Remote
{
  char ip[16];
  int port;   
  int validy;
  UDPSocket *p_udpSocket;
  Thread *p_udpThread;
  int txError;
  int rxStatus;

} s_EthAddRemote[NO_UDP] , *ps_ear[NO_UDP];//

//static UDPSocket *gp_udpSocket[NO_UDP] = {NULL};
//static Thread *gp_udpRxThread[NO_UDP] = {NULL};
#endif

static int myUdpPort = 11000;

void udpRx_fun( int* par_i );


/************* inicijalizacija parametara  **********************/

void init_udp_param( void )
{
 //   memset(ps_ear[0], 0, sizeof(struct S_EthernetAddress_Remote)*NO_UDP);

    if( test_num(gpc_html->get_myUdpPort( )))  myUdpPort = atoi( gpc_html->get_myUdpPort( ));
    printf( " myUdpPort = %d\n\r", myUdpPort);
#if NO_UDP>0
    for( int i=1; i<= NO_UDP; i++)
    {
      const char *sp, *sip=gpc_html->get_UdpIP(i);
      

      // treba popraviti, IP(4) i IP(5) su opseg adresa
      if( i < 5 ) sp = gpc_html->get_UdpPort(i);
      else 
      {     
            sp = gpc_html->get_UdpPort(4);
      }
      
               
       
       ps_ear[i-1] = &(s_EthAddRemote[i-1]);
        
        if( test_ip( sip ) && test_num( sp ) )
        { 
            strncpy( ps_ear[i-1]->ip, sip, 16 );
            ps_ear[i-1]->port = atoi( sp );
            ps_ear[i-1]->validy = 1;
        }
        else
        {
                ps_ear[i-1]->validy = 0;
        }
        ps_ear[i-1]->rxStatus = 0;

      //printf(" UDP IP adresa: %s   port = %d validy %d\n\r",   ps_ear[i-1]->ip, ps_ear[i-1]->port, ps_ear[i-1]->validy );
    }
#endif
}

void start_UdpClients( void )
{
//      start = false;
        printf( "start UDP clients\n\r");
        F
        init_udp_param( );

        for( int i=0; i< NO_UDP; i++)
        {
            int *p_i = new int;
            *p_i = i;
            ps_ear[i]->p_udpThread = new Thread;
            ps_ear[i]->p_udpThread->start(callback( udpRx_fun, p_i));
       //     printf(" UDP Clients start:   Thread[%d]=%d\n\r", i, ps_ear[i]->p_udpThread );
            
        }
}


/***************** Predaja na UDP  ****************************/


void sendUdpi( int i, char *buffer, int val )
{   
#if NO_UDP>0
  if( ps_ear[i]->p_udpSocket && ps_ear[i]->validy && (ps_ear[i]->rxStatus == 3))
  {
    ps_ear[i]->txError = ps_ear[i]->p_udpSocket->sendto(ps_ear[i]->ip, ps_ear[i]->port, (const uint8_t*)buffer, val);
    //thread_sleep_for(1);//wait(0.001);
  
   // printf(" UDPpaket ip=%s port=%d val=%d err=%d  stat=%d\n\r", ps_ear[i]->ip, ps_ear[i]->port, val, ps_ear[i]->txError , getEthernetStatus( ) );    
  }
  else printf("UDPsocket[%d] == NULL\n\r", i);
#endif
}

void sendToUdp( char *buffer, int val )
{

#if NO_UDP>0
  ThisThread::yield();
  for( int i=0; i< NO_UDP; i++ )
     if( ps_ear[i]->validy )  { sendUdpi( i, buffer, val );  ThisThread::yield();}
#endif
}



/***************  Prijem na UDP socket i predaja na Serial com ***************/

void udpRx_fun( int* par_i )
{
 int i = *par_i;
 free(par_i);

//   nsapi_error_t err;
    char inbuff[1500];

//    printf("udpRxThread[%d] inicijalizovan \n\r",i);

    while( !(ThisThread::flags_get() & 4))
    {
        ps_ear[i]->rxStatus=1;
        nsapi_error_t err;

        if( ps_ear[i]->validy)
        {
        UDPSocket *p_sock = ps_ear[i]->p_udpSocket = new UDPSocket;
//        printf("\n\rudpClient[%d]: novi UDP socket %x\n\r", i, p_sock);
                
            while( !(ThisThread::flags_get() & 2) )    
            {    
                ps_ear[i]->rxStatus =  2;
                if( (err= p_sock->open(gp_eth)) == NSAPI_ERROR_OK )
                {
                char *ip = ps_ear[i]->ip;
                int port = ps_ear[i]->port;
                signed int n=0;
                     p_sock->bind( port );
//!!!                     p_sock->set_timeout(100);
                    ps_ear[i]->rxStatus =  3;
                     sendToUdp( (char*)"Hallo Marko\n\r", 13 );
                    while( !(ThisThread::flags_get( ) & 1) )
                    {
                    SocketAddress sockAddr;

                    ps_ear[i]->rxStatus =  3;
                        if( (n>=0) )
                        {
                            n = p_sock->recvfrom(&sockAddr, &inbuff, sizeof(inbuff));

                            if(n>0) { extern void sendToScom(  char *buffer, int val ); sendToScom( inbuff, n); }
//!!!                            else if(n==-3001)  n = 0;
                            else 
                            {
                                printf( "udpClient[%d]: Greska  na prijemu = %d   BREAK!\n\r", i, n);  
                                break;
                            }
                        }
                    }// while 1
                    ps_ear[i]->rxStatus = 2;
                    ThisThread::flags_clear(1);
//!!!                    p_sock->set_timeout(-1);
                    p_sock->close();
                } // open socket
                else         printf("udpClient[%d]: greska otvaranja soketa err=%d \n\r",i, err);  
                thread_sleep_for(1000);  // dremni pre ponovnog pokusaja konekcije
                break;  // izlaz iz while 2, brisanje socket-a i ponovno otvaranje 
            } // while 2
            ps_ear[i]->rxStatus = 1;
            ThisThread::flags_clear(2);
        printf("udpClient[%d]:___zatvaranje UDP socket= %x\n\r",i, p_sock);        
        delete p_sock;
        p_sock = NULL;
        thread_sleep_for(1000);  // dremni pre ponovnog konstrukcije socketa

        } // validy
    } // while 4 
    ThisThread::flags_clear(4);
    ps_ear[i]->rxStatus = 0;
    printf("udpClient[%d]: izlaz iz rxThread-a\n\r",i);
    fflush(stdout);
}


void restart_UdpClientConnection( int noClient, int restartType )
{
    if( (noClient < NO_UDP) && (restartType <= (1+2+4)) )
    {
        ps_ear[noClient]->p_udpThread->flags_set(restartType);
        if( restartType & 4 )
        { 
            ps_ear[noClient]->p_udpThread->join(); 
            printf("UDP Client Thread[%d]=%d zavrsen\n\r",noClient, ps_ear[noClient]->p_udpThread);
        }    
    }
}

void restart_UdpClientsConnection( int restartType )
{
    init_udp_param(  );
    for(int i=0; i<NO_UDP; i++)
    {
        if(ps_ear[i]->rxStatus)
            restart_UdpClientConnection( i, restartType);
    }
}

void restart_UdpClients( void )
{
    restart_UdpClientsConnection(7);
    start_UdpClients();
}






// /*         staro  */
// void udpRxThreadsCancel( void )
// {
//      /* Gasenje UDP threada  */

// #if NO_UDP>0
//      for(int i =0; i<NO_UDP; i++ )
//      {
//        if(ps_ear[i]->validy )
//        {  
//          if( gp_udpRxThread[i] )
//          {  
//             if( gp_udpRxThread[i]->get_state( ) && gp_udpRxThread[i]->get_state( )<16 )
//                 gp_udpRxThread[i]->flags_set( 1 );
//             gp_udpRxThread[i]->join( );        
            
//             delete gp_udpRxThread[i]; 
//             gp_udpRxThread[i] = NULL;
//          }
//         }
        
//         printf("udp thread[%d] zavrsio\n\r", i);
//         ps_ear[i]->validy = 0;
        
//         // !!!!! ugasiti i sockete
//     }
// #endif
// }

// void udpRxThreadsRiseUp( void )
// {
//      /* paljenje UDP thread-a */
// #if  NO_UDP>0

//     nsapi_error_t err;

//      init_udp_param(  );

//      for(int i =0; i<NO_UDP; i++ )
//         if( ps_ear[i]->validy )
//         {
             
             
//              gp_udpSocket[i] = new UDPSocket;
//             printf("___novi UDP socket[%d] %x\n\r", i, gp_udpSocket[i]);
               
//              if( (err = gp_udpSocket[i]->open( gp_eth ))  != NSAPI_ERROR_OK )  
//                 { printf(" greska otvaranja UDP soketa %d  err=%d \n\r", i, err);  
//                    gp_udpSocket[i] = NULL;
//                    gp_udpRxThread[i] = NULL; 
//                    break;      
//                 }
//              gp_udpSocket[i]->bind(/* ps_ear[0]->port*/ myUdpPort);
//              gp_udpSocket[i]->set_timeout(100);
// int *p_i = (int*)malloc(sizeof(int));
// *p_i = i;
//                  gp_udpRxThread[i] = new Thread;
//                  gp_udpRxThread[i]->start( callback( udpRx_fun, p_i) );
//                 printf( "startuje udpRxThread [%d] =%x\n\r", i, &gp_udpRxThread[i] );
//         }
// //     gp_udpRxThread[i]->start( callback( udpRx_fun, &i ) );
// //     
// #endif
// }

// void udpRxThreadsRestart( void )
// {
//  printf("gasi udp\n\r"); fflush(stdout);
//     udpRxThreadsCancel( );
//  printf("pali udp\n\r"); fflush(stdout);
//     udpRxThreadsRiseUp( );
// }

