#include "mbed.h"
#include "clubbing.h"
#include "string.h"
#include "dxml.h"

#include "doHTML.h"
#include "dataFlash.h"
#include "HTMLpage.h"



/**************************  Pocetak *********************/

void test_HTML(void)
{
extern C_HTMLparse *gpc_html;

 P_str( "selected bit rate" ,  (char*)gpc_html->get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)gpc_html->get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)gpc_html->get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)gpc_html->get_selected_option( "data_bits" ) );

    {
        extern UARTSerial *gp_scom;
        extern void sendScom( struct UARTSerial *p_scom, char *buffer, int val);

            auto c = gpc_html->getHTML_free( );
        //  n = p_soc->send(c, strlen(c));
            sendScom( gp_scom, c, strlen(c));
            free(c);
    }


 P_str( "select bit rate 38400", gpc_html->set_selected_option( "baud_rate", "38400" ) );
 P_str( "select bit parity ODD", gpc_html->set_selected_option( "parity", "odd" ) );
 P_str( "select stop bits 1.5", gpc_html->set_selected_option( "stop_bits", "1.5" ) );
 P_str( "select data bits 7", gpc_html->set_selected_option( "data_bits", "7" ) );

    {
        extern UARTSerial *gp_scom;
        extern void sendScom( struct UARTSerial *p_scom, char *buffer, int val);

            auto c = gpc_html->getHTML_free( );
        //  n = p_soc->send(c, strlen(c));
            sendScom( gp_scom, c, strlen(c));
            free(c);
    }


P_str( "selected bit rate" ,  (char*)gpc_html->get_selected_option( "baud_rate" ) );
 P_str( "selected parity" ,  (char*)gpc_html->get_selected_option( "parity" ) );
 P_str( "selected stop bits" ,  (char*)gpc_html->get_selected_option( "stop_bits" ) );
 P_str( "selected data bits" ,  (char*)gpc_html->get_selected_option( "data_bits" ) );

}
 
 



/************************ definicija klase C_HTMLparse ********************/

  void C_HTMLparse::load_front_row(void )
    {
        int i = 0;
        for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
        {
            auto input = dxml_child(td, "input");
            front_row[i] = input;
            ++i;
        }
        
        tr = tr->next;
    }
     
    void C_HTMLparse::load_second_row()
    {
        int i = 0;
        for (auto td = dxml_child(tr, "td")/*, i = 0*/; td; td = td->next)
        {
            auto input = dxml_child(td, "input");
            if (i == 0)
                UDPs[0] = input;
            else if(i == 1)
                TCPs[0] = input;
            ++i;
        }
        
        tr = tr->next;
    }
     
    void C_HTMLparse::load_udp_and_tcp(dxml_t& td)
    {
        for (int i = 0; i < 4; td = td->next)
        {
            dxml_t inputs[5];
            int input_count = 0;
            for (auto input = dxml_child(td, "input"); input; input = input->next)
                inputs[input_count++] = input;
            
            if (i < 2) // Load inputs into UDPs
            {
                for (int k = 0; k < input_count; ++k)
                    UDPs[i == 0 ? k + 1 : k + 6] = inputs[k];
            }
            else
            {
                for (int k = 0; k < input_count; ++k)
                    TCPs[i == 2 ? k + 1 : k + 6] = inputs[k];
            }
                    
            ++i;    
        }
    }
     
    void C_HTMLparse::load_serial(dxml_t& td)
    {
        auto select = dxml_child(td, "select");
        for (int i = 0; select; select = select->next)
            serial[i++] = select;
    }
     
 
    dxml_t C_HTMLparse::get_serial_option(dxml_t s, int option_idx)
    {
        auto rv = dxml_child(s, "option");
        for (int i = 0; i < option_idx; ++i)
        {
            if( rv->next == NULL ) return NULL;
            else rv = rv->next;
        }
        return rv;
    }

    C_HTMLparse::C_HTMLparse( void )
    {
        
        p_HTMLpage = (char*)malloc(strlen(HTMLpage)+1);
        strcpy( p_HTMLpage, HTMLpage);
        P_int("ucitavam html", strlen(HTMLpage));
        p_rootHTML = dxml_parse_str(p_HTMLpage, strlen(p_HTMLpage));
        intern_init( );
     }

     C_HTMLparse::C_HTMLparse( const char *str )
     {
        p_HTMLpage = (char*)malloc(strlen(str)+1);
        strcpy( p_HTMLpage, str);
        P_int("ucitavam html", strlen(str));
        p_rootHTML = dxml_parse_str(p_HTMLpage, strlen(p_HTMLpage));
        intern_init( );
         
     }
    
     
     void C_HTMLparse::intern_init( void )
     {   
        html_body = dxml_child(p_rootHTML, "body");
        html_form = dxml_child(html_body, "form");
        html_table = dxml_child(html_form, "table");
        tr = dxml_child(html_table, "tr");
        
        load_front_row();
        
        load_second_row();
        
        auto td = dxml_child(tr, "td");
        load_udp_and_tcp(td);
        load_serial(td);    
        for(int i = 0; i < sizeof( s_hpv)/sizeof( s_hpv[0]); i++) { s_hpv[i].name= NULL; s_hpv[i].value = NULL; }
    }


    char *C_HTMLparse::getHTML_free( void )
    {
        return dxml_toxml(p_rootHTML);
    }


/****************** geteri - seteri *************************/




    const char * C_HTMLparse::get_selected_option( const char *name_option )
    {
        for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
        {
           char *ret;  
             if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
             {
               for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
               {
                  if( dxml_attr( get_serial_option(serial[i],j), "selected" ) ) 
                    return  dxml_attr(get_serial_option(serial[i], j), "value");
                } 
               return  dxml_attr(get_serial_option(serial[i], 0), "value"); 
             }
        } 
        return NULL;
    }
    
    const char * C_HTMLparse::set_selected_option( const char* name_option, const char* value_option )
    {
        for( int i=0; dxml_attr(serial[i], "name") != NULL; i++ )
        {
        //   printf(" i = %d  \n\r", i );
           char *ret;  
             if( !strcmp( (char*)dxml_attr(serial[i], "name"), name_option) )
             {
               for(int j=0; dxml_attr(get_serial_option(serial[i], j), "value") != NULL; j++)
               {
          //        printf("  j=%d \n\r", j);
                  if( !strcmp( dxml_attr( get_serial_option(serial[i],j), "value"), value_option) )
                  {
                    if( !dxml_attr( get_serial_option(serial[i],j), "selected") )
                    { 
                        for(int k=0; dxml_attr(get_serial_option(serial[i], k), "value") != NULL; k++)
                        {
        //                  printf("   k=%d\n\r",k);
                          if( !strcmp( dxml_attr( get_serial_option(serial[i],k), "value"), value_option) )
                          { 
                             printf("   kk=%d\n\r",k); 
                             dxml_set_attr( get_serial_option(serial[i],k), "selected", "ON" );
                          }
                          else  
                          {  
//                              printf("   k=%d\n\r",k); 
                              dxml_set_attr( get_serial_option(serial[i],k), "selected", NULL );
                          }
                        }
                    }
                    return value_option;
                  }
                }  
             }
        } 
        
        return NULL;
        
    }
    
    const char * C_HTMLparse::get_BaudRate( void )
    {
       return get_selected_option( "baud_rate" );
    }
    const char * C_HTMLparse::get_Parity( void )
    {
      return get_selected_option( "parity" );
    }
    const char * C_HTMLparse::get_StopBits( void )
    {
        return get_selected_option( "stop_bits" );
    }
    const char * C_HTMLparse::get_DataBits( void )
    {
        return get_selected_option( "data_bits" );
    }

    

#define COPY_IP_ATTR_VALUE( DXML_T, STR )  { char *s = (char *)dxml_attr( DXML_T, "value"); if( s ) {strcpy( s, STR );  dxml_set_attr( DXML_T, "value", s);  }  }
//#define COPY_IP_ATTR_VALUE( DXML_T, STR )  { char *s = (char *)dxml_attr( DXML_T, "value"); free( s ); char *d = (char *)malloc( strlen(STR)+1); strcpy( s, STR ); dxml_set_attr( DXML_T, "value", d);  }  

#define COPY_PORT_ATTR_VALUE( DXML_T, STR )  { char *s = (char *)dxml_attr( DXML_T, "value"); if( s ) {strcpy( s, STR );  dxml_set_attr( DXML_T, "value", s);  }  }

    void C_HTMLparse::set_myIP( const char* str )    {  if( test_ip( str )) COPY_IP_ATTR_VALUE( front_row[0], str );     }
    
    void C_HTMLparse::set_myMASK( const char* str )  {  if( test_ip( str )) COPY_IP_ATTR_VALUE( front_row[1], str );     }

    void C_HTMLparse::set_myGATE( const char* str )  {  if( test_ip( str )) COPY_IP_ATTR_VALUE( front_row[2], str );     }

    void C_HTMLparse::set_myUdpPort( const char* str )  { if( test_num( str ) ) COPY_PORT_ATTR_VALUE( UDPs[0], str );      } //dxml_set_attr( UDPs[0], "value", str );    }
    
    void C_HTMLparse::set_myTcpPort( const char* str )  { if( test_num( str ) ) COPY_PORT_ATTR_VALUE( TCPs[0], str );      } // if( test_num( str) ) dxml_set_attr( TCPs[0], "value", str);    }

    void C_HTMLparse::set_UdpIP( int i, const char* str )
    {
        if( (i > 0) && (i <= 5 ) )
        {
            if( test_ip( str ) )     COPY_IP_ATTR_VALUE( UDPs[i], str )
            else                    COPY_IP_ATTR_VALUE( UDPs[i], "xxx.xxx.xxx.xxx" )
        }
    }    
    void C_HTMLparse::set_UdpPort( int i, const char* str )
    {
        if( (i>0) && (i<= 4) )
        {
            if (test_num( str ) )        COPY_PORT_ATTR_VALUE( UDPs[i+5], str )  
//            else                        COPY_PORT_ATTR_VALUE( UDPs[i+5], " " )
        }
    }
    
    void C_HTMLparse::set_TcpIP( int i, const char* str )
    {
        if( (i > 0) && (i <= 5 ) )
        {
            if( test_ip( str ) )     COPY_IP_ATTR_VALUE( TCPs[i], str )       /////// dxml_set_attr( TCPs[i], "value", str); 
            else                     COPY_IP_ATTR_VALUE( TCPs[i], "xxx.xxx.xxx.xxx" )       /////// dxml_set_attr( TCPs[i], "value", str); 
        }
    }    
    void C_HTMLparse::set_TcpPort( int i, const char* str )
    {
        if( (i>0) && (i<= 4) )
        {
            if( test_num( str ) )        COPY_PORT_ATTR_VALUE( TCPs[i+5], str )       ////dxml_set_attr( TCPs[i+6], "value", str) ;
//            else                        COPY_PORT_ATTR_VALUE( TCPs[i+5], " " )
        }
    }

    const char *C_HTMLparse::get_myIP( void )
    {
       return dxml_attr( front_row[0], "value");
    }
    const char *C_HTMLparse::get_myMASK(void)
    {
        return dxml_attr( front_row[1], "value");
    }
    const char *C_HTMLparse::get_myGATE( void )
    {
        return dxml_attr( front_row[2], "value");
    }

    const char *C_HTMLparse::get_myUdpPort( void )
    {
        return dxml_attr( UDPs[0], "value" );
    }
    const char *C_HTMLparse::get_myTcpPort( void ) 
    {
        return dxml_attr( TCPs[0], "value");
    }
    
    const char *C_HTMLparse::get_UdpIP( int i )
    {
        if( (i > 0) && (i <= 5 ) )        return dxml_attr( UDPs[i], "value"); 
        return NULL;
    }
    
    const char *C_HTMLparse::get_UdpPort( int i )
    {
        if( (i>0) && (i<= 4) )    return dxml_attr( UDPs[i+5], "value") ;
        return NULL; 
    }
    
    const char *C_HTMLparse::get_TcpIP( int i )
    {
        if( (i > 0) && (i <= 5 ) )        return dxml_attr( TCPs[i], "value"); 
        return NULL;
    }
    
    const char *C_HTMLparse::get_TcpPort( int i )
    {
        if( (i>0) && (i<= 4) )    return dxml_attr( TCPs[i+5], "value") ;
        return NULL; 
    }
 

/****************************************************************************/

/***************   HTTP obrada *********************************************/


int C_HTMLparse::httpSplitInLines( char *lines[], char * httpresp)
{

  char * pch;
  int i=0;
  pch = lines[i++]= strtok (httpresp,"\n\r");
  while (pch != NULL)
  {
    pch=lines[i++] = strtok (NULL, "\n\r");
  }
   return i;
}
char * C_HTMLparse::httpFirstLine( char **descr, char *line)
{
  char * pch;

  pch = strtok (line,"/ ");
  *descr = strtok (NULL, "/ ");
     return pch;
}
//
//struct S_httpPostValues
//{
//    char *name;
//    char *value;
//} s_hpv[100];

//struct S_httpPostValues *ps_hpv = s_hpv;

int C_HTMLparse::extractPostPairs( struct S_httpPostValues ** ps_hpv, char *line)
{
 char *lines[100];
 char * pch;

  int i=0;
  pch = lines[i++]= strtok (line,"&");
  while (pch != NULL)
  {
    pch=lines[i++] = strtok (NULL, "&\n\r");
  }

//printf("linija 26 %s\n\r", lines[26]);
//for(int i=0; i<15; i++) printf("%x ", *(lines[26]+i) ); printf("\n\r\n\r");

  for( int j=0; j<i; j++)
  {
      char *s = strtok(lines[j], "=");
      (*ps_hpv)[j].name = s;
      (*ps_hpv)[j].value = strtok(NULL, "=");
  }
  return i;
}


char * C_HTMLparse::doHTTP( char * httpcontents)
{
char *lines[50];

int http_i = httpSplitInLines( lines, httpcontents);

char *descr;
char *type = httpFirstLine( &descr, lines[0]);

printf("type = %s  descr = %s\n\r", type, descr );

int html_j=0;
    if ( !strcmp( type, "POST") )
    {
        if( http_i >=14)
        {
            html_j = extractPostPairs( &ps_hpv, lines[14]);
            return "POST" ;
        }
    }
    else if( !strcmp(type, "GET"))
    {
        if( !strcmp(descr, "HTTP") ) return "GET_HTML";
        else               return 0;
    }
    return 0;
}

/* TEST

if( !strcmp(doHTTP( hG3), "POST") )

    for( int k=0; k<10; k++ )
        printf("name= %s   value= %s\n\r", (ps_hpv+k)->name, ps_hpv[k].value);

    return 0;
*/

//   struct S_httpPostValues
//    {
//        char *name;
//        char *value;
//    } s_hpv[100];


void C_HTMLparse::htmlPOST_fun( void )
{
  for(int i = 0; i<27; i++ )
  {
 //     printf(" rb = %d   name:%s = value:%s \n\r", i, s_hpv[i].name, s_hpv[i].value );
        
      if( !strcmp( s_hpv[i].name, "ip_adresa") )    set_myIP( s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "netmask") ) set_myMASK( s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "gateway") ) set_myGATE( s_hpv[i].value ); 

      else if( !strcmp( s_hpv[i].name, "udp_server_port") ) set_myUdpPort( s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_server_port") ) set_myTcpPort( s_hpv[i].value ); 

      else if( !strcmp( s_hpv[i].name, "udp_ip_1") ) set_UdpIP( 1, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_ip_2") ) set_UdpIP( 2, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_ip_3") ) set_UdpIP( 3, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_opseg_od") ) set_UdpIP( 4, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_opseg_do") ) set_UdpIP( 5, s_hpv[i].value ); 

      else if( !strcmp( s_hpv[i].name, "udp_port_1") ) set_UdpPort( 1, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_port_2") ) set_UdpPort( 2, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_port_3") ) set_UdpPort( 3, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "udp_port_opseg") ) set_UdpPort( 4, s_hpv[i].value ); 

      else if( !strcmp( s_hpv[i].name, "tcp_ip_1") ) set_TcpIP( 1, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_ip_2") ) set_TcpIP( 2, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_ip_3") ) set_TcpIP( 3, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_opseg_od") ) set_TcpIP( 4, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_opseg_do") ) set_TcpIP( 5, s_hpv[i].value ); 

      else if( !strcmp( s_hpv[i].name, "tcp_port_1") ) set_TcpPort( 1, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_port_2") ) set_TcpPort( 2, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_port_3") ) set_TcpPort( 3, s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "tcp_port_opseg") ) set_TcpPort( 4, s_hpv[i].value ); 


      else if( !strcmp( s_hpv[i].name, "baud_rate") ) set_selected_option(  "baud_rate" , s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "parity") ) set_selected_option(  "parity" , s_hpv[i].value ); 
      else if( !strcmp( s_hpv[i].name, "data_bits") ) { set_selected_option(  "data_bits" , s_hpv[i].value ); } 
      else if( !strcmp( s_hpv[i].name, "stop_bits") ) { set_selected_option(  "stop_bits" , s_hpv[i].value ); }
    }

}



//ip_adresa=192.168.1.20&
//netmask=255.255.255.0&
//gateway=192.168.1.1&
//udp_server_port=11000&
//tcp_server_port=12000&
//udp_ip_1=xxx.xxx.xxx.xxx&
//udp_ip_2=xxx.xxx.xxx.xxx&
//udp_ip_3=xxx.xxx.xxx.xxx&
//udp_opseg_od=xxx.xxx.xxx.xxx&
//udp_opseg_do=xxx.xxx.xxx.xxx&
//udp_port_1=65535&
//udp_port_2=&
//udp_port_3=65535&
//udp_port_opseg=65535&
//tcp_ip_1=xxx.xxx.xxx.xxx&
//tcp_ip_2=xxx.xxx.xxx.xxx&
//tcp_ip_3=xxx.xxx.xxx.xxx&
//tcp_opseg_od=xxx.xxx.xxx.xxx&
//tcp_opseg_do=xxx.xxx.xxx.xxx&
//tcp_port_1=65535&
//tcp_port_2=&tcp_port_3=65535&
//tcp_port_opseg=65535&
//baud_rate=9600&
//parity=none&data_bits=8&
//stop_bits=1




/*****************************************************************************/
