#include "mbed.h"
#include "platform/mbed_thread.h"
#include "clubbing.h"
#include "EthernetSetup.h"
#include "Udp.h"
#include "doHTML.h"



struct S_EthernetAddress_Remote
{
  char ip[16];
  int port;   
  int validy;
} s_EthAddRemote[NO_UDP] , *ps_ear[NO_UDP];//

//char lokaUdpPort[6] = "13000", localUdpPortFlash[6] = "65535";

/* globalni pointeri*/


extern EthernetInterface *gp_eth;
extern C_HTMLparse * gpc_html;

static UDPSocket *gp_udpSocket[NO_UDP] = {NULL};
static int myUdpPort = 11000;
static Thread *gp_udpRxThread[NO_UDP] = {NULL};

/************* inicijalizacija parametara  **********************/

void init_udp_param( void )
{
    
    if( test_num(gpc_html->get_myUdpPort( )))  myUdpPort = atoi( gpc_html->get_myUdpPort( ));
    printf( " myUdpPort = %d\n\r", myUdpPort);

    for( int i=1; i<= NO_UDP; i++)
    {
      const char *sp, *sip=gpc_html->get_UdpIP(i);
      

      // ovo je fake, zbog testiranja, i treba da bude izbaceno na kraju
      if( i < 5 ) sp = gpc_html->get_UdpPort(i);
      else 
      {     
            sp = gpc_html->get_UdpPort(4);
            sip=gpc_html->get_UdpIP(4);
      }
      
               
       
       ps_ear[i-1] = &(s_EthAddRemote[i-1]);
        
        if( test_ip( sip ) && test_num( sp ) )
        { 
            strncpy( ps_ear[i-1]->ip, sip, 16 );
            ps_ear[i-1]->port = atoi( sp );
            ps_ear[i-1]->validy = 1;
        }
        else
        {
                ps_ear[i-1]->validy = 0;
        }
        printf(" UDP IP adresa: %s   port = %d validy %d\n\r",   ps_ear[i-1]->ip, ps_ear[i-1]->port, ps_ear[i-1]->validy );
    }
}


/***************** Predaja na UDP  ****************************/

void sendUdp( struct S_EthernetAddress_Remote *ps_ear, char *buffer, int val )
{   
  if( gp_udpSocket[0] )
  {
    printf(" UDPpaket ip=%s port=%d val=%d\n\r", ps_ear->ip, ps_ear->port, val);
    gp_udpSocket[0]->sendto(ps_ear->ip, ps_ear->port, (const uint8_t*)buffer, val);
  }
  else printf("UDPsocket == NULL\n\r");
}

void sendUdpi( int i, char *buffer, int val )
{   
  if( gp_udpSocket[i] )
  {
    printf(" UDPpaket ip=%s port=%d val=%d\n\r", ps_ear[i]->ip, ps_ear[i]->port, val);
    gp_udpSocket[i]->sendto(ps_ear[i]->ip, ps_ear[i]->port, (const uint8_t*)buffer, val);
  }
  else printf("UDPsocket[%d] == NULL\n\r", i);
}

void sendToUdp( char *buffer, int val )
{
  for( int i=0; i< NO_UDP; i++ )
     if( ps_ear[i]->validy )  sendUdpi( i, buffer, val );
}



/***************  Prijem na UDP socket i predaja na Serial com ***************/

void udpRx_fun( int* par_i )
{
 int i = *par_i;
//   nsapi_error_t err;
printf("udp kanal %d\n\r", i);
    char inbuff[1500];

  //  if(gp_udpSocket == NULL)
    {

//         gp_udpSocket[i] = new UDPSocket;
//        printf("___novi UDP socket[%d] %x\n\r", i, gp_udpSocket[i]);
//         if( (err = gp_udpSocket[i]->open( gp_eth ))  != NSAPI_ERROR_OK )  
//            { printf(" greska otvaranja soketa %d \n\r", err);  }
//         gp_udpSocket[i]->bind(ps_ear[0]->port);
//         gp_udpSocket[i]->set_timeout(1000);
    }
    printf("UDPrx inicijalizovan \n\r");


signed int n=0;
    while( !(ThisThread::flags_get( ) & 1) )
   {
        SocketAddress sockAddr;
       if( (n>=0) && gp_udpSocket[i] )
       {
        int n = gp_udpSocket[i]->recvfrom(&sockAddr, &inbuff, sizeof(inbuff));

        if(n>0) { extern void sendToScom(  char *buffer, int val ); sendToScom( inbuff, n); }
        else if(n==-3001)  n = 0;
        else break;
       }
       //else wait(0.1);
    } 
    
    if(gp_udpSocket[i]) { delete gp_udpSocket[i]; gp_udpSocket[i] = NULL;}
    printf("udpSocket obrisan\n\r");
    fflush(stdout);
}


void udpRxThreadCancel( void )
{
     /* Gasenje UDP threada  */
     for(int i =0; i<NO_UDP; i++ )
     {
       if(ps_ear[i]->validy )
       {  
         if( gp_udpRxThread[i]->get_state( ) && gp_udpRxThread[i]->get_state( )<16 )
            gp_udpRxThread[i]->flags_set( 1 );
         gp_udpRxThread[i]->join( );        
        
         if(gp_udpRxThread[i]) {delete gp_udpRxThread[i]; gp_udpRxThread[i] = NULL;}
        }
        
        printf("udp thread[%d] zavrsio\n\r", i);
        ps_ear[i]->validy = 0;
        
        // !!!!! ugasiti i sockete
    }
    
}


 TCPSocket *p_tcpSocket[2];   /* socket za prijem zahteva za konekciju */
void udpRxThreadRiseUp( void )
{
     /* paljenje UDP thread-a */
    nsapi_error_t err;

     init_udp_param(  );

     for(int i =0; i<NO_UDP; i++ )
        if( ps_ear[i]->validy )
        {
             
             
             gp_udpSocket[i] = new UDPSocket;
            printf("___novi UDP socket[%d] %x\n\r", i, gp_udpSocket[i]);
               
             if( (err = gp_udpSocket[i]->open( gp_eth ))  != NSAPI_ERROR_OK )  
                { printf(" greska otvaranja UDP soketa %d  err=%d \n\r", i, err);  }
             gp_udpSocket[i]->bind(/* ps_ear[0]->port*/ myUdpPort);
             gp_udpSocket[i]->set_timeout(1000);

                 gp_udpRxThread[i] = new Thread( &i, udpRx_fun );
                printf( "          dprxthread [%d] =%x\n\r", i, &gp_udpRxThread[i] );
        }
//     gp_udpRxThread[i]->start( callback( udpRx_fun, &i ) );
//     
}

void udpRxThreadRestart( void )
{
 printf("gasi udp\n\r"); fflush(stdout);
    udpRxThreadCancel( );
 printf("pali udp\n\r"); fflush(stdout);
    udpRxThreadRiseUp( );
}

