#include "mbed.h"
#include "platform/mbed_thread.h"
#include "clubbing.h"
#include "EthernetSetup.h"
#include "TcpClients.h"
#include "doHTML.h"

extern EthernetInterface *gp_eth;
extern C_HTMLparse * gpc_html;



struct SThreadParam
{
  Thread *p_Thread; // sopstveni pointer
  void * p_param;  // pointer za parametre thread-a, u ovom slucaju na socket koji je accept-van
};

volatile static struct S_EthernetAddress_Remote
{
  char ip[16];
  int port;   
  int validy;
  TCPSocket *p_tcpSocket;
  Thread *p_tcpThread;
  int txError;
  int rxStatus;
} s_EthAddRemote[NO_TCP] , *ps_ear[NO_TCP];//

//static TCPSocket *gp_tcpSocket[NO_TCP] = {NULL};
//static Thread *gp_tcpRxThread[NO_TCP] = {NULL};


static int myTcpPort = 11000;

void tcpRx_fun( int* par_i );

/************* inicijalizacija parametara  **********************/

int get_rxStatus( int i )
{
    return s_EthAddRemote[i].rxStatus;
}
int get_rxValidy( int i )
{
    return s_EthAddRemote[i].validy;
}

void init_tcp_param( void )
{
 //   printf("my tcp port = %s\n\r", gpc_html->get_myTcpPort( ));  F
    
    if( test_num(gpc_html->get_myTcpPort( )))  myTcpPort = atoi( gpc_html->get_myTcpPort( ));
    printf( " myTcpPort = %d\n\r", myTcpPort);

#if  NO_TCP>0

    for( int i=1; i<= NO_TCP; i++)
    {
          const char *sp, *sip=gpc_html->get_TcpIP(i);

      // treba popraviti, IP(4) i IP(5) su opseg adresa
      if( i < 5 ) sp = gpc_html->get_TcpPort(i);
      else 
      {     
            sp = gpc_html->get_TcpPort(4);
      }
             
       ps_ear[i-1] = &(s_EthAddRemote[i-1]);
        
        if( test_ip( sip ) && test_num( sp ) )
        { 
           strncpy( (char *)ps_ear[i-1]->ip, sip, 16 );
            ps_ear[i-1]->port = atoi( sp );
            ps_ear[i-1]->validy = 1;
        }
        else
        {
                ps_ear[i-1]->validy = 0;
        }

        ps_ear[i-1]->rxStatus = 0;
      //  printf(" TCP IP adresa: %s   port = %d validy=%d \n\r",   ps_ear[i-1]->ip, ps_ear[i-1]->port, ps_ear[i-1]->validy );

    }
#endif
}

// 

void start_TcpClients( void )
{
        printf( "start tcp clients\n\r");
        
        init_tcp_param( );

        for( int i=0; i< NO_TCP; i++)
        {
            int *p_i = new int;
            *p_i = i;
            ps_ear[i]->p_tcpThread = new Thread;
            ps_ear[i]->p_tcpThread->start(callback( tcpRx_fun, p_i));
            //printf(" TCP Clients start:   Thread[%d]=%d\n\r", i, ps_ear[i]->p_tcpThread );
        }
}


/***************** Predaja na TCP  ****************************/


void sendTcpi( int i, char *buffer, int val )
{   
#if  NO_TCP>0

  if( ps_ear[i]->p_tcpSocket && ps_ear[i]->validy && (ps_ear[i]->rxStatus ==  3))
  {
    ps_ear[i]->txError = ps_ear[i]->p_tcpSocket->send(buffer, val);
  //  static int i = 0; printf("tcp %d\n\r", i++);
 //   printf(" TCPpaket ip=%s port=%d val=%d err=%d  stat=%d\n\r", ps_ear[i]->ip, ps_ear[i]->port, val, ps_ear[i]->txError, getEthernetStatus( ) );    
  }
  else printf("TCPsocket[%d] == NULL\n\r", i);
#endif
}

void sendToTcp( char *buffer, int val )
{

#if  NO_TCP>0
  for( int i=0; i< NO_TCP; i++ )
     if( ps_ear[i]->validy )  {sendTcpi( i, buffer, val ); ThisThread::yield(); /* thread_sleep_for(200);*/}

#endif
}



/***************  Prijem na TCP socket i predaja na Serial com ***************/

void tcpRx_fun( int* par_i )
{
 int i = *par_i;
 delete par_i;

    char inbuff[1500];
ps_ear[i]->rxStatus = 0;
      //printf("tcpClient[%d]: rx thread inicijalizovan \n\r",i);

    while( !(ThisThread::flags_get( ) & 4) )  //  flag za izlaz iz Thread-a
    {
ps_ear[i]->rxStatus=1;
        nsapi_error_t err;

        if(ps_ear[i]->validy)
        {

        TCPSocket *p_sock = ps_ear[i]->p_tcpSocket = new TCPSocket;
    //    printf("\n\rtcpClient[%d]: novi TCP socket %x\n\r", i, p_sock);

            while( !(ThisThread::flags_get( ) & 2) ) // fleg za gasenje socket-a
            {
ps_ear[i]->rxStatus = 2;
                    if( (err = p_sock->open( gp_eth ))  == NSAPI_ERROR_OK )  
                    {
                        int port = ps_ear[i]->port;
                        char *ip = (char*)ps_ear[i]->ip;
                        p_sock->bind( port );
                        if( (err = p_sock->connect(ip, port)) == NSAPI_ERROR_OK)
                        {
                            printf("tcpClient[%d]:konektovan na ip=%s, port=%d\n\r",i, ip, port);
         //!!!                   p_sock->set_timeout(100);       
                            signed int n=0;
                            while(!(ThisThread::flags_get( ) & 1) )  // fleg za izlaz iz konekcije
                            {
ps_ear[i]->rxStatus =  3;
                                if( (n>=0)  )
                                {
                                    n = p_sock->recv( inbuff, sizeof(inbuff));

                                    if(n>0) { extern void sendToScom(  char *buffer, int val ); sendToScom( inbuff, n); }
        //!!!                            else if(n==-3001)  n = 0;   // nije prava greska, isteklo vreme timeouta
                                    else {printf("\n\rtcpClient[%d]: break na receive  err=%d\n\r", i,n);  break; }
                                }
                
                            } //while 1
ps_ear[i]->rxStatus = 2;
                            ThisThread::flags_clear(1);
        //!!!                    p_sock->set_timeout(-1);
                            p_sock->close();       
                        } // connected
                        else     printf("tcpClient[%d]: greska konekcije rxThread %d\n\r", i, err); 
                    } // open
                    else         printf("tcpClient[%d]: greska otvaranja soketa err=%d \n\r",i, err);  
                thread_sleep_for(1000);  // dremni pre ponovnog pokusaja konekcije
                break;  // izlaz iz while 2, brisanje socket-a i ponovno otvaranje 
            } // while 2
ps_ear[i]->rxStatus = 1;
            ThisThread::flags_clear(2);
        
        printf("tcpClient[%d]:___zatvaranje TCP socket= %x\n\r",i, p_sock);
        delete p_sock;
        p_sock = NULL;
        thread_sleep_for(1000);  // dremni pre ponovnog konstrukcije socketa

        } // if validy


    }// while 4
    ThisThread::flags_clear(4);
ps_ear[i]->rxStatus = 0;

    printf("tcpClient[%d]: izlaz iz rxThread\n\r", i);
    fflush(stdout);

}

void restart_TcpClientConnection( int noClient, int restartType )
{
    if( (noClient < NO_TCP) && (restartType <= (1+2+4)) )
    {
        ps_ear[noClient]->p_tcpThread->flags_set(restartType);
        if( restartType & 4 )
        { 
            ps_ear[noClient]->p_tcpThread->join(); 
            printf("TCP Client Thread[%d]=%d zavrsen\n\r",noClient, ps_ear[noClient]->p_tcpThread);
        }    
    }
}

void restart_TcpClientsConnection( int restartType )
{
    init_tcp_param(  );
    for(int i=0; i<NO_TCP; i++)
    {
        if(ps_ear[i]->rxStatus)
            restart_TcpClientConnection( i, restartType);
    }
}

void restart_TcpClients( void )
{
    restart_TcpClientsConnection(7);
    start_TcpClients();
}
