#include "mbed.h"
#include "clubbing.h"
#include "doHTML.h"



#define SerialTxPin     PTC17
#define SerialRxPin     PTC16
char scomBaud[7] = "9600", scomBaudFlash[7] = "200000";


/* globalni pointeri*/


Thread *gp_scomRxThread=NULL;
UARTSerial *gp_scom=NULL;
extern  C_HTMLparse *gpc_html;


int get_baud( void )
{
  int a = atoi(scomBaudFlash), b = atoi(scomBaud), ret;
  if( (a > 90) && (a < 100000) ) ret = a;
  else if( (b > 90) && (b < 100000) ) ret = b;
  else ret = 96/*00*/;
  printf(" baud rates = %d %d  final %d\n\r", a, b, ret );
  return ret;  
}
//    char * C_HTMLparse::get_BaudRate( void );
//    char * C_HTMLparse::get_Parity( void );
//    char * C_HTMLparse::get_StopBits( void );
//    char * C_HTMLparse::getBaudRate( void );

int get_baudRates( void )
{
  int br =  atoi( gpc_html->get_BaudRate( ) );
  if( IN_RANGE( 1000, br, 1000000) ) return br;
  return 9600;
}
int get_stopBits( void )
{
    const char *c = gpc_html->get_StopBits( );
    if( !strcmp( c, "2" ) ) return 2;
    else return 1; 
}
SerialBase::Parity  get_parity ( void )
{
    const char *c = gpc_html->get_Parity( );
    SerialBase::Parity p = SerialBase::None;
    if( !strcmp( c, "Odd") ) return SerialBase::Odd;
    if( !strcmp( c, "Even") ) return SerialBase::None;
    return p;
}
int get_databits( void )
{
  int b = atoi( gpc_html->get_DataBits( ));
  if( IN_RANGE( 5, b, 8 ) ) return b;
  return 8;  
}
/****************  Predaja na Serial Com ********************************/


void sendScom( struct UARTSerial *p_scom, char *buffer, int val)
{
   if( p_scom )
   {
     int num;
        if(val>0)  num = p_scom->write( (const uint8_t*) buffer, val );
        printf(" Poslan serial com paket od %d bajtova", num);
    }
    else printf("Serial com neinicijalizovan\n\r");
}

void sendToScom(  char *buffer, int val )
{
   sendScom( gp_scom, buffer, val);
}

/**************  Prijem na serial com i slanje na UDP  *********************/

void scomrx_fun( void )
{
    
    char readbuff[1500];
    int totno=0; 
    int noreaded=0;
//  if(gp_scom) delete gp_scom;
      gp_scom = new UARTSerial(SerialTxPin,SerialRxPin,/*get_baud()*/ get_baudRates( ) );  //38400 za KSS
      gp_scom->set_format( get_databits( ), get_parity(), get_stopBits( ) );
       printf("Rx serial com initialised\n\r");
       
       while( !(ThisThread::flags_get( ) & 1) )
      {
        if( gp_scom->readable() )   
        {
            noreaded = gp_scom->read( (uint8_t *)(readbuff+totno), 1500);
            totno += noreaded;
            wait(0.01);     
        }
        else if(totno) 
        {
            printf("PRIJEM na rs232 com   totno = %d  \n\r", totno);   
       //     if(readbuff[0] == 'q') {extern Thread udpBroadcast_thread; udpBroadcast_thread.terminate();}
    
//            if(readbuff[0] == 'c'){ extern void udpBroadcast_fun( void );Thread *th = new Thread; th->start( udpBroadcast_fun);}
//            if(readbuff[0] == 'r'){ extern void inic_1(void); extern PFV pfv; pfv = inic_1;  }
//            if(readbuff[0] == 'q'){ if(gp_udpSocket)gp_udpSocket->close();gp_udpSocket=NULL;  }
//            sendUdp( ps_ear, (char *)readbuff, totno); 
extern void sendToUdp( char *buffer, int val );   sendToUdp( readbuff, totno );
            totno = 0;      
        } 
  }
  if(gp_scom) {delete gp_scom; gp_scom = NULL;}
  printf(" Ugasen serial com Thread\n\r");
} 


void scomRxThreadCancel( void )
{
        /* gasenje serial com thread-a */
    int st = gp_scomRxThread->get_state();
    if( st && st<16 )gp_scomRxThread->flags_set(1);
    gp_scomRxThread->join();
    printf("ScomRx Thread upravo zavrsio\n\r");
    if(gp_scomRxThread) { delete gp_scomRxThread; gp_scomRxThread = NULL;}
}

 void scomRxThreadRiseUp( void )
 {
    /* paljenje serial com thread-a */
    gp_scomRxThread = new Thread(scomrx_fun);
}
 
void scomRxThreadRestart( void )
{
   scomRxThreadCancel(  );
   scomRxThreadRiseUp(  );
}