#include "mbed.h"
#include "clubbing.h"
#include "doHTML.h"



#define SerialTxPin     PTC17
#define SerialRxPin     PTC16


/* globalni pointeri*/
extern  C_HTMLparse *gpc_html;
extern volatile int tcpServerBlock;   

UARTSerial * gp_scom;// = new UARTSerial(SerialTxPin,SerialRxPin/* , get_baudRates( )*/ );  //38400 za KSS

static Thread *gp_scomRxThread=NULL;
int serial_status = 0;
int totno=0; 
int noreaded=0;

void print_serial( void )
{
    printf( " serial: status=%d totno=%d  noreaded=%d \n\r", serial_status, totno, noreaded);
}


//    char * C_HTMLparse::get_BaudRate( void );
//    char * C_HTMLparse::get_Parity( void );
//    char * C_HTMLparse::get_StopBits( void );
//    char * C_HTMLparse::getBaudRate( void );

int get_baudRates( void )
{
  int br =  atoi( gpc_html->get_BaudRate( ) );
  if( IN_RANGE( 1000, br, 1000000) ) return br;
  return 9600;
}
int get_stopBits( void )
{
    const char *c = gpc_html->get_StopBits( );
    if( !strcmp( c, "2" ) ) return 2;
    else return 1; 
}
SerialBase::Parity  get_parity ( void )
{
    const char *c = gpc_html->get_Parity( );
    SerialBase::Parity p = SerialBase::None;
    if( !strcmp( c, "Odd") ) return SerialBase::Odd;
    if( !strcmp( c, "Even") ) return SerialBase::None;
    return p;
}
int get_databits( void )
{
  int b = atoi( gpc_html->get_DataBits( ));
  if( IN_RANGE( 5, b, 8 ) ) return b;
  return 8;  
}

/******************** INICIJALIZACIJA I START SERIJALA - start se moze pozvati samo jednom ***********************/


void init_SerialCom( void )
{
    gp_scom->set_format( get_databits( ), get_parity(), get_stopBits( ) );
    gp_scom->set_baud( get_baudRates());
}

void scomrx_fun( void );
void start_SerialCom( void )
{

        if(gp_scomRxThread==NULL) 
        {
//        printf("inicijalizacija serijal thread-a\n\r");fflush(stdout);
            gp_scomRxThread = new Thread;
            gp_scomRxThread->start(scomrx_fun);
//            printf(" Paljenje serial com RxThread = %d \n\r", gp_scomRxThread);
        
        }
        else printf("@@@@@@@@@   ScomThread vec postoji, ne moze se setovati novi\n\r");

}

/****************  Predaja na Serial Com ********************************/





void sendScom( struct UARTSerial *p_scom, char *buffer, int val)
{
   if( !tcpServerBlock)
   {
        if( p_scom )
        {
            int num;
                if(val>0)  num = p_scom->write( (const uint8_t*) buffer, val );
                printf("SComTx:  Poslan serial com paket od %d bajtova\n\r", num);
        }
        else printf("SComTx:  Serial com neinicijalizovan\n\r");        
   }
}

void sendToScom(  char *buffer, int val )
{
   sendScom( gp_scom, buffer, val);
}

/**************  Prijem na serial com i slanje na UDP  *********************/
static volatile int prc =0;
void scomrx_fun( void )
{
    
    char readbuff[1500];
    // int totno=0; 
    // int noreaded=0;
       gp_scom = new UARTSerial(SerialTxPin,SerialRxPin,/*get_baud()*/ get_baudRates( ) );  //38400 za KSS
        if( gp_scom )
        {
            printf("inicijalizacija serijal comm-a\n\r");fflush(stdout);
            init_SerialCom( );
  //          printf("SComRxThread:  Rx serial com initialised gp_scom=%d\n\r", gp_scom);
        
        int k =0;
            while( true )
            {
            
                if( /* !tcpServerBlock  &&*/ gp_scom->readable() /* && ((noreaded = gp_scom->read( (uint8_t *)(readbuff+totno), 1500-totno))>0)*/ )   
                {

                                  noreaded = gp_scom->read( (uint8_t *)(readbuff+totno), 1500-totno);
                      totno += noreaded;
                      k++;
                       ThisThread::yield();//wait(0.001);*/  thread_sleep_for(1);  
                }
                 else if(totno) 
                {
                           //     printf("  k=%d \n\r", k);   
        extern void sendToUdp( char *buffer, int val );   sendToUdp( readbuff, totno );
        extern void sendToTcp( char *buffer, int val );   sendToTcp( readbuff, totno );
        extern void sentOnTcpServers(  char *buffer, int val  );  sentOnTcpServers(readbuff, totno );
                    k = 0;
                    totno = 0;      
                } 
                ThisThread::yield();//wait(0.001);    
            }// while 1
        }
        else printf("problem inicijalizacije socketa\n\r"); 
        terminate();
}

