#include "mbed.h"
//#include "string.h"

#include "EthernetSetup.h"
#include "doHTML.h"
#include "dataFlash.h"

#include "TcpServer.h"
#include "SerialCom.h"

#include <iterator>
#include <list>



extern EthernetInterface *gp_eth;
extern C_HTMLparse * gpc_html;



/* globalni pointer na tcpServer RX Thread za parametarizaciju  */
static Thread *gp_tcpServerThread = NULL; //new Thread;
static void tcpServerRx_fun( void );

// char remote_ip[16];
 int port;

static TCPSocket *gp_tcpSocket=NULL;   /* socket za prijem zahteva za konekciju */
static Thread *gp_thr = NULL; /* pointer gde se smesta thread za brisanje */



typedef void(*PF_PSTP)(struct SThreadParam *);   // ne koristi se

// parametri thread-a za uspostavljenje konekcije
struct SThreadParam
{
  Thread *p_Thread; // sopstveni pointer
  void * p_param;  // pointer za parametre thread-a, u ovom slucaju na socket koji je accept-van
} ;

struct SThreadParam s_ThrPrm, *gps_ThPrm=&s_ThrPrm;
list<struct SThreadParam *> lps_tp;
void showlist( list<struct SThreadParam*> ls )
{
    printf("socket list: ");
     for( auto it=ls.begin(); it!=ls.end(); it++)
         printf(" %d ", (int)(*it)->p_param );
     printf("\n");
}


void set_thp(  struct SThreadParam * p)
{
    gps_ThPrm->p_param = p->p_param;
    gps_ThPrm->p_Thread = p->p_Thread;
    lps_tp.push_front(p);
    showlist(lps_tp);
}
void del_thp(  struct SThreadParam * p )
{
    gps_ThPrm->p_param= NULL;
    gps_ThPrm->p_Thread = NULL;
    lps_tp.remove(p);
    showlist(lps_tp);
}

bool isAny_thp(  void )
{
    if( gps_ThPrm->p_param ) return true;
    return false;

}


/******************  inicijalizacija u mainu  ************************/
static char* html_string;

void start_TcpServer( void )
{
    if( test_num(gpc_html->get_myTcpPort()))  port = atoi( gpc_html->get_myTcpPort( ));
    else port = 11111;

   //del_thp(  NULL );

    if( gp_tcpServerThread )  delete gp_tcpServerThread;
    gp_tcpServerThread = new Thread();    
    gp_tcpServerThread->start(tcpServerRx_fun);

}


void sentOnTcpServers(  char *buffer, int val  )
{
    // if( isAny_thp() )  
    // {
    //     ((TCPSocket *)(gps_ThPrm->p_param))->send(buffer, val);

    // }

     for( auto it=lps_tp.begin(); it!=lps_tp.end(); it++)
         ((TCPSocket *)((*it)->p_param))->send(buffer, val);


}




/*****************            u main-u               *************************/
// zatvaranje thread-a nakon http razmene 

void finish_TcpServerInstance( void )
{
        if(gp_thr) 
        { 
            printf("Brisanje thread-a %d\n\r", gp_thr); fflush(stdout);
            gp_thr->join(); 
            
            delete gp_thr; 
            gp_thr = NULL; 
            printf("Obrisan thread %d\n\r", gp_thr); 
//            s.release(); 
        } 
}


/**************  Trajni TCPServer thread *********************************/



void serverInstance_fun( SThreadParam *ps_thr );

static void tcpServerRx_fun( void )
{
  while( true )
  {  
    printf("____Otvoren TCP server rx thread____ \n\r");   
    if( gp_tcpSocket ) {delete gp_tcpSocket; gp_tcpSocket = NULL; } /* ima smisla ako se thread nasilno zatvara  */

      gp_tcpSocket = new TCPSocket;
      if(gp_tcpSocket->open( gp_eth ) != 0) break;
      gp_tcpSocket->bind( port );

        if(gp_tcpSocket->listen(2) != 0 )  
        {   printf("greska listenovanja na socketu\n\r");  break;}
    
        TCPSocket *p_soc;
        nsapi_error_t err=NULL;      
    int nos = 0;

    while(   (p_soc = gp_tcpSocket->accept( &err))  )
    {

            Thread *p_thr = new Thread( );
            struct SThreadParam *ps_thp = new struct SThreadParam;  // alokacija ps_thp
            ps_thp->p_param = (void*)p_soc;
            ps_thp->p_Thread = p_thr;
            set_thp(ps_thp);

            printf("TCPThread: NOVA KONEKCIJA!  thread %d   socket  %d   struct Sst %d\n\r", ps_thp->p_Thread, p_soc, ps_thp);fflush(stdout);
            p_thr->start( callback( serverInstance_fun, ps_thp ));


    }
    printf("TCP WEB SERVER: Ispad iz accept while!!! socket = %d  err = %d\n\r", p_soc, err);fflush(stdout);
   }
  printf("TCP WEB SERVER: Zaustavljen WEB server \n\r");fflush(stdout);

}




/***************** privremeni TCPServer thread za klijenta  ******************/
// thread je jednokratan - primi http telegram i odgovori - ako je GET ili POST upit

void serverInstance_fun( struct SThreadParam *ps_thp )
{
     TCPSocket *p_soc = (TCPSocket *)ps_thp->p_param;

     char inbuff[1500];

      int n;
     // printf("tcpServThread:  Otvoren socket %d\n\r",(int)p_soc);   
        
       //     printf("tcpServThread: cekam prijem od klijenta \n\r");
            SocketAddress sockAddr;
            p_soc->getpeername( &sockAddr );
            
        //    p_soc->set_timeout(10); // non-blocking pruzimanje bajtova na 10ms
            n=0;
            while(true)
            {
                
               n = p_soc->recv( (inbuff), sizeof(inbuff));  // razmotriti obradu nr=0 !!!
 
               if(n>0) 
               {   
                   extern void sendToScom(  char *buffer, int val ); 
                   sendToScom( inbuff, n); 
                }
                else 
                {
         //           printf("\n\rtcpServer: break na receive  err=%d\n\r",n);  
                    break; 
                }
           }            
               
        //{printf("tcpServThread: zatvaranje socketa\n\r"); fflush(stdout);}      
        
        del_thp(ps_thp);
        p_soc->close();    // zatvaranje socketa      


        
        //{printf("tcpServThread: zatvaranje thread-a\n\r"); fflush(stdout);}          
        // zatvaranje thread-a
        gp_thr = ps_thp->p_Thread;//   poslati pointer da se delete-uje
 
        //{printf("tcpServThread: brisanje parametara\n\r"); fflush(stdout);}         
        delete ps_thp; // relokacija ps_thp

}

