#include "mbed.h"
#include "EthernetInterface.h"
#include <stdio.h>
#include <string.h>
#include "TCPSocket.h"

//#define WADDR

#ifdef WADDR
#define IP_ADDR   "169.254.65.200"
#define NET_MASK  "255.255.0.0"
#define GATW_ADDR "169.254.65.1"
#define IP_ADDR_REMOTE "169.254.65.199"
#else
#define IP_ADDR   "192.168.1.200"
#define NET_MASK  "255.255.255.0"
#define GATW_ADDR "192.168.1.1"
#define IP_ADDR_R "192.168.1.9"
#endif

#define SOCKET_PORT 11000



EventFlags ef;

EthernetInterface eth;
nsapi_error_t err;


struct Sst
{
  TCPSocket *p_soc;
  Thread *p_Thread;   
};

int str_count( unsigned char *ps)
{
 int i=0;
  for(i=0; ps[i] != 0; i++);
  return i;   
}


MemoryPool<struct Sst, 16> mpool;
Queue<struct Sst, 16> queue;



//void fun( void  );
//void fun( TCPSocket *s );
void fun( Sst *s );
void tcpThread_fun( EthernetInterface *e);



DigitalOut RedLed(LED1);
DigitalOut GreenLed(LED2);
DigitalOut BlueLed(LED3);


char flag = 0;

  void ledfun(void)
  {
     
    RedLed =1;
    GreenLed = 1;
    BlueLed = 1;
  
     while(1) {

    


        RedLed = 0;
        wait(0.3);
        RedLed = 1;
        wait(0.3);
  if(flag){
              
        GreenLed=0;
        wait(0.2);
        GreenLed=1;
        wait(0.2);
        
        BlueLed = 0;
        wait(0.1);
        BlueLed = 1;
        wait(0.1);
    }
    }
  
}

int main(void)
{
  //  if( (err = eth.disconnect()) != NSAPI_ERROR_OK )  { printf(" greska diskonekcije %d \n\r", err); return 1; } 
  //  ((NetworkInterface *)&eth)->set_network("192.168.1.11","255.255.255.0","192.168.1.1");
  
  
  Thread LedThread;
  LedThread.start( ledfun);
  
  wait(10);
  
  
 
    if( (err = eth.set_network(IP_ADDR,NET_MASK,GATW_ADDR))!= NSAPI_ERROR_OK )  { printf(" greska setovanja mreze %d \n\r", err); return 1; } 
    
    
     if( (err = eth.connect())  != NSAPI_ERROR_OK )  { printf(" greska konekcije %d \n\r", err); return 1; }
    
    const char *ip = eth.get_ip_address() ;
    
    
    printf( "MAC adresa: %s\n\r", eth.get_mac_address() );
    printf( "IP adresa:  %s\n\r", ip);
    printf( "net mask:   %s\n\r", eth.get_netmask() );
    printf( "GW adresa:  %s\n\r", eth.get_gateway() );
    
    Thread TCPThread;
    osStatus status = TCPThread.start( callback( tcpThread_fun, &eth ));
    if(status != osOK)  error("Oh NO!");
    printf("main: status threada %d \n\r",status);
    
 

    while(true)
    {
  //  printf("\n\rMain: Cekanje flega\n\r");    fflush(stdout);
//      uint32_t flag =  ef.wait_any(1);
//        if(flag) { if(sst.p_Thread) {printf("Main:  thread %d je delete-ovan /n/r", sst.p_Thread);  delete sst.p_Thread; sst.p_Thread = 0;}}
// 
    printf("\n\rMain: Cekanje eventa\n\r");    fflush(stdout);
 osEvent ev = queue.get();
       if(ev.status == osEventMessage) 
       {
            struct Sst *s = (struct Sst *)ev.value.p;
            if(s->p_Thread) { printf("Main:  thread %d je delete-ovan, socket %d \n\r", s->p_Thread, s->p_soc);  delete s->p_Thread; s->p_Thread = 0;}
            
            if(s->p_soc) { printf("Main:  socket %d je close-ovan\n\r",  s->p_soc);(s->p_soc)->close();}
       
            delete s;
       }
    }
    printf("\n\rmain: Kraj, error=%d\n\r",err);    fflush(stdout);
}




//    unsigned char sendBuffer[]= "HTTP/1.1 200 OK\r\nContent-Length: 11\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nBosko je ovde";                  // HTTP Message Body, length = 11
    unsigned char sendBuffer[]= "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nMarko je ovde";                  // HTTP Message Body, length = 11
unsigned char sb[1000]="HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n";


void fun( Sst *s )
{
 TCPSocket *soc = s->p_soc;
 
 char inbuff[1000];
 char sendbuff[] = "javlja se socket\n";
  int n, nr, nt;
  
  flag = 1;
  
  printf("thread:  Otvoren socket %d\n\r",s->p_soc);
    
    
    while(true)
   {
        
        printf("thread %d :  cekam prijem na socket %d \n\r",s->p_Thread,soc);
fflush(stdout);
wait(1);
        SocketAddress sockAddr;
        soc->getpeername( &sockAddr );
        n=nr = soc->recv( &inbuff, sizeof(inbuff));
        if( n<0 ) break;
        printf("thread %d: primljeno = %d bajtova na socket %d\n\r",s->p_Thread,n, soc);
        int i; for(i=0;i<n;i++)  printf("%c", inbuff[i] );

//        nt=n = soc->send( sendbuff, sizeof(sendbuff));
 //       nt=n = soc->send( sendBuffer, sizeof(sendBuffer)+1);
 
 int t=0;
 //sprintf( sb, "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n Test");
 //sprintf( sb, "  ");
 
                    soc->send(sendBuffer, str_count(sendBuffer)+1);
printf("velicina niza = %d, %d \n\r",sizeof(sendBuffer), str_count(sendBuffer));
        if(n<0) break; 
        printf("\n\rthread %d: Predaja %d bajtova %s  na adresu %s , port %d\r\n",s->p_Thread,n, sendbuff,sockAddr.get_ip_address(), sockAddr.get_port());
    

    } 

    queue.put(s);

   printf("\n\rthread %d  soc=%d: KRAJ KONEKCIJE!!! nr=%d    nt=%d  \n\r",s->p_Thread, soc, nr,nt);

     


//    printf("\n\rthread %d  soc=%d: KRAJ KONEKCIJE!!! nr=%d    nt=%d  \n\r",s->p_Thread, soc, nr,nt);
//ef.set(1);
}


void tcpThread_fun( EthernetInterface *e)
{
    TCPSocket tcpSocket, *p_soc;  
    nsapi_error_t err=NULL;      
    if(tcpSocket.open( e ) !=0)   printf("greska otvaranja socketa\n\r");
    
    int no_sockets = 0;
    if(tcpSocket.bind(SOCKET_PORT) !=0) printf("greska bindovanja socketa\n\r");;
    if(tcpSocket.listen(10) != 0 )  printf("greska listenovanja na socketu\n\r");;
    while(   (p_soc = tcpSocket.accept( &err)) || (err == NSAPI_ERROR_NO_SOCKET)  )
    {
        if(err == NSAPI_ERROR_NO_SOCKET) {  printf("TCPThread: prekoracenje socketa\n\r"); fflush(stdout); wait(1); continue; }
        no_sockets++;
        Thread *thr = new Thread;
        struct Sst *s = new struct Sst;
        s->p_soc = p_soc;
        s->p_Thread = thr;
        
        printf("TCPThread: NOVA KONEKCIJA!  thread %d   socket  %d   struct Sst %d\n\r", s->p_Thread, s->p_soc, s);
        osStatus status = thr->start( callback( fun, s ));
        if(status != osOK)  error("Oh NO!");
        printf("TCPThread: status threada %d socket= %d no_sockets=%d\n\r",status, p_soc, no_sockets);

//fun(soc);
    }    
    
}
    


//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};