/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

#include "EthernetInterface.h"

#include <stdio.h>
#include <string.h>
#include "TCPSocket.h"

#include "PGSdisplay.h"
#include "ParkareClient.h"




char MyIPaddress[]= "192.168.2.11";
char MyNETmask  []= "255.255.248.0";
char MyGWaddress[]= "192.168.1.1";

char conf_server_ip[] = "192.168.2.254";
int conf_server_port = 12197;


Thread *threadGarColl = NULL;


EthernetInterface eth;
nsapi_error_t err;
volatile int ethinic_flag = 0;

void theth_fun( void )
{
 
//   while( true )
   {
//        if(ethinic_flag==0)
        {
            printf(" setovanje ethernet mreze \n\r");
            if( (err = eth.set_network(MyIPaddress,MyNETmask,MyGWaddress))== NSAPI_ERROR_OK ) 
            {
                printf(" uspostavljanje konekcije \n\r");
                if( (err = eth.connect())  == NSAPI_ERROR_OK )  
                {
                
                    printf( "MAC adresa: %s\n\r", eth.get_mac_address() );
                    printf( "IP adresa:  %s\n\r", eth.get_ip_address() );
                    printf( "net mask:   %s\n\r", eth.get_netmask() );
                    printf( "GW adresa:  %s\n\r", eth.get_gateway() );
        ethinic_flag = 1;
                }
            }
        }
        fflush( stdout);
//        thread_sleep_for( 1000 );
    }
}



char * extract_string( char delimiter, char *ulazni_str, int n_str );
void putOnDisp( char *s, char boja);

void tcpThread_fun( EthernetInterface *e);
void requestMessage( EthernetInterface *e);

DigitalOut ledc(LED3,1);

int main(void)
{
printf("\n\r----------------Pocetak------------ \n\r"); fflush(stdout);

Thread ThEth;
    ThEth.start( theth_fun );

    init_disp( );
    putOnDisp("elcom",3);

    ThEth.join( );
    printf(" Thread ethernet = %d \n\r", (int)&ThEth );
    
    SocketAddress sa(conf_server_ip, conf_server_port);
    printf("socket inicijalizovan \n\r"); fflush(stdout);

    putOnDisp("flash",2);

extern char crm_req[];
extern char srm_req[];
    struct s_rm s_crm = { &eth, &sa, crm_req, crm_fun, 0 };
    struct s_rm s_srm = { &eth, &sa, srm_req, srm_fun, 0 };


    printf("Parkare server zahtev za katalog \n\r"); fflush(stdout);


    Thread CRMThread;
    CRMThread.start( callback( requestMessageThread, &s_crm ));
    CRMThread.join();
    int i=0;
//        thread_sleep_for(15000);

printf("ispred while-a\n\r"); 
fflush(stdout);

    while(true) {
//        ledc = !ledc;
if( threadGarColl != NULL ) {delete threadGarColl; threadGarColl = NULL; }

        thread_sleep_for(5000);

        printf("Parkare server zahtev za broj \n\r"); fflush(stdout);
        Thread SRMThread;
        s_srm.response = 0;
        SRMThread.start( callback( requestMessageThread, &s_srm ));
        SRMThread.join();
        printf("PGSdisplay status response %d\n\r",s_srm.response);
    }
//   printf("\n\rmain: Kraj, error=%d\n\r",err);    fflush(stdout);
}



//
//unsigned char sendBuffer[]= "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nMarko je ovde";                  // HTTP Message Body, length = 11
//unsigned char sb[1000]="HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n";
//
//
//
//unsigned char txbuf[100]="test konekcije";
//unsigned char rxbuf[100];



//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};


