/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

#include "EthernetInterface.h"

#include <stdio.h>
#include <string.h>
#include <sstream>
#include <iostream>
#include "TCPSocket.h"


void putOnDispNo(int broj, char boja);
void putOnDisp(char *s, char boja);
void requestMessageThread(struct s_rm *s);
void slanjefun();

#define IP_ADDR   "192.168.2.11"
#define NET_MASK  "255.255.248.0"
#define GATW_ADDR "192.168.1.1"
#define IP_ADDR_R "192.168.1.9"



EthernetInterface eth;
nsapi_error_t err;

char * extract_string( char delimiter, char *ulazni_str, int n_str );
void putOnDisp( char *s, char boja);

int strcount( char *ps)
{
    int i=0;
    for(i=0; ps[i] != 0; i++);
    return i;
}

void tcpThread_fun( EthernetInterface *e);
void requestMessage( EthernetInterface *e);

DigitalOut tast(PTB19,0);
//RawSerial rs485(PTC17,PTC16);
RawSerial rs485(PTD3,PTD2);

struct s_rm {
    EthernetInterface *e;
    SocketAddress *sa;
    char *tx_msg;
    void (*fun_rec)(char*);
};

char crm_req[]= {'{','1','|','1','}'}; //"{1|1}";
char crm_resp[100];
void crm_fun( char *rx)
{
    printf("crm_resp: %s\n\r",rx);
    strcmp(crm_resp, rx);
}

char srm_req[]="{5|1|0}";
void srm_fun( char *rx )
{
    printf("srm_resp: %s\n\r",rx);
    char *strno= extract_string(';',rx, 2);
    char boja = 0;
    if(atoi(strno) <= 0) {
        boja = 1;
    } else if(atoi(strno) >0 && atoi(strno)<5) {
        boja = 4;
    } else {
        boja = 2;
    }
    printf("broj: %d - boja: %d\n\r", atoi(strno),boja);
    if (atoi(strno) < 0)
        putOnDisp("0", boja);
    else
        putOnDisp((char*)strno, boja);
}




int main(void)
{



    rs485.format(8, mbed::RawSerial::Even, 1);

    Thread t;
//   t.start( slanjefun );

    putOnDisp("elcom", 3);

    if( (err = eth.set_network(IP_ADDR,NET_MASK,GATW_ADDR))!= NSAPI_ERROR_OK )  {
        printf(" greska setovanja mreze %d \n\r", err);
        return 1;
    }
    if( (err = eth.connect())  != NSAPI_ERROR_OK )  {
        printf(" greska konekcije %d \n\r", err);
        return 1;
    }

    const char *ip = eth.get_ip_address() ;


    printf( "MAC adresa: %s\n\r", eth.get_mac_address() );
    printf( "IP adresa:  %s\n\r", ip);
    printf( "net mask:   %s\n\r", eth.get_netmask() );
    printf( "GW adresa:  %s\n\r", eth.get_gateway() );

    SocketAddress sa("192.168.2.254", 12197);

    struct s_rm s_crm = { &eth, &sa, crm_req, crm_fun };
    struct s_rm s_srm = { &eth, &sa, srm_req, srm_fun };


    putOnDisp("flash", 2);

    Thread CRMThread;
    CRMThread.start( callback( requestMessageThread, &s_crm ));
    CRMThread.join();
    int i=0;
//        thread_sleep_for(15000);

    while(true) {
        thread_sleep_for(5000);

        Thread SRMThread;
        SRMThread.start( callback( requestMessageThread, &s_srm ));
        SRMThread.join();
        printf("main %d\n\r",i++);
    }
//   printf("\n\rmain: Kraj, error=%d\n\r",err);    fflush(stdout);
}




unsigned char sendBuffer[]= "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nMarko je ovde";                  // HTTP Message Body, length = 11
unsigned char sb[1000]="HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n";



unsigned char txbuf[100]="test konekcije";
unsigned char rxbuf[100];


char conf_server_ip[] = "192.168.1.26";
int conf_server_port = 12197;
unsigned char msg_request_message[] = "{5|1|1;2}";
unsigned char msg_catalogue_request_message[] = "{1|1}";



void requestMessageThread(struct s_rm *s)
{

    TCPSocket tcpSocket;
    nsapi_error_t err=NULL;
    char rxbuf[1024];
    memset(rxbuf, 0, sizeof(rxbuf));
    if((err=tcpSocket.open( s->e )) ==0 ) {
        if((err = tcpSocket.connect(*(s->sa))) == 0) {
            char *ss = s->tx_msg;
            if( (err = tcpSocket.send(s->tx_msg,strcount(ss))<0 ) ) {
                printf("requestMessage - send err: %d\n\r", err);
            } else {
                printf("requestMessage - poslano: %d bajtova od: %s\n\r", err, s->tx_msg);
                if( (err = tcpSocket.recv(rxbuf,sizeof(rxbuf)) <0 )) {
                    printf("requestMessage - recv err %d\n\r", err);
                } else {

                    printf("requestMessage - prim tel %d: %s\n\r", err, rxbuf) ;
                    s->fun_rec( rxbuf );
                }
            }
        }

        printf("requestMessage - zatvaranje konekcije\n\r");
        tcpSocket.close();
    }

}

//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};





void ev(int)
{
    tast=0;
}



unsigned char buf_tel[100] = {0x71,0x00,0x0D,0x71,0x43,0x01,0x1B,0x4A,0x01,0x01,  /*0x1b,0x45,0x1,*/  0x1B,0x43,1,0x33,0xD5,0x16};
#define NO_BEFORE_DATA 13
#define NO_WITH_DATA (NO_BEFORE_DATA + strlen(s))

void putOnDisp( char *s, char boja)
{
    int ubb = NO_BEFORE_DATA+strlen(s)+1+1-4-2; // ubb = ukupan broj bajtova
    buf_tel[NO_BEFORE_DATA-1]=boja;
    memcpy(buf_tel+NO_BEFORE_DATA, s, strlen(s)+2);

    char suma=0;
    for(int i = 4; i < NO_WITH_DATA; i++) {
        suma +=buf_tel[i];
    }

    buf_tel[NO_WITH_DATA] = suma;
    buf_tel[NO_WITH_DATA+1] = 22;
    buf_tel[1]=ubb>>8;
    buf_tel[2]=ubb;


    tast=1;
    rs485.write(buf_tel, NO_WITH_DATA+2+2,ev);
}

void putOnDispNo(int broj, char boja)
{
    char s[10];
    sprintf( s, "%d", broj);
    putOnDisp( s, boja);
}


void slanjefun()
{

    int j=0;


    while (true) {
//       printf("disp thred %d\n\r",j);
        if(j >10 && j<15 ) putOnDisp("des",1);
        else putOnDispNo(j,1);
        j++;
        thread_sleep_for(1000);
    }
}


char * extract_string( char delimiter, char *ulazni_str, int n_str )
{
    int br_str=0;
    char *ret_str=ulazni_str;
    char* ptr = ulazni_str;

    while(*ptr) {
        if(*ptr == delimiter) {
            *ptr = 0;
            if( br_str == n_str )   return ret_str;
            else {
                br_str++;
                ret_str = ptr + 1;
            }
        }
        ptr++;
    }
    if( br_str == n_str )   return ret_str;
    return NULL;
}

