/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

#include "EthernetInterface.h"

#include <stdio.h>
#include <string.h>
#include "TCPSocket.h"


void putOnDispNo(int broj, char boja);
void putOnDisp(char *s, char boja);
void slanjefun();

#define IP_ADDR   "192.168.2.11"
#define NET_MASK  "255.255.248.0"
#define GATW_ADDR "192.168.1.1"
#define IP_ADDR_R "192.168.1.9"



EthernetInterface eth;
nsapi_error_t err;


int strcount( unsigned char *ps)
{
 int i=0;
  for(i=0; ps[i] != 0; i++);
  return i;   
}

void tcpThread_fun( EthernetInterface *e);

 DigitalOut tast(PTB19,0);               
//RawSerial rs485(PTC17,PTC16);           
RawSerial rs485(PTD3,PTD2);
 

int main(void)
{
 
 rs485.format(8, mbed::RawSerial::Even, 1);
 
    Thread t;
 //   t.start( slanjefun );

 
 
     if( (err = eth.set_network(IP_ADDR,NET_MASK,GATW_ADDR))!= NSAPI_ERROR_OK )  { printf(" greska setovanja mreze %d \n\r", err); return 1; }    
     if( (err = eth.connect())  != NSAPI_ERROR_OK )  { printf(" greska konekcije %d \n\r", err); return 1; }
    
    const char *ip = eth.get_ip_address() ;
    
    
   printf( "MAC adresa: %s\n\r", eth.get_mac_address() );
    printf( "IP adresa:  %s\n\r", ip);
    printf( "net mask:   %s\n\r", eth.get_netmask() );
    printf( "GW adresa:  %s\n\r", eth.get_gateway() );
    
    Thread TCPThread;
    TCPThread.start( callback( tcpThread_fun, &eth ));
 
    int i=0;
  
    while(true)
    {
      thread_sleep_for(20000);
      printf("main %d\n\r",i++);
    }
 //   printf("\n\rmain: Kraj, error=%d\n\r",err);    fflush(stdout);
}




    unsigned char sendBuffer[]= "HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nMarko je ovde";                  // HTTP Message Body, length = 11
unsigned char sb[1000]="HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html\r\n\r\n";



unsigned char txbuf[100]="test konekcije";
unsigned char rxbuf[100];

void tcpThread_fun( EthernetInterface *e)
{

    TCPSocket tcpSocket;  
    nsapi_error_t err=NULL;      
    SocketAddress sa("192.168.2.254", 12197);
    printf("ip= %s, ver= %d, port= %d\n\r", sa.get_ip_address(), sa.get_ip_version(), sa.get_port() ); 
    int i=1;
    
    while(true)
    {
     if((err=tcpSocket.open( e )) ==0 )        
     {
        if((err = tcpSocket.connect(sa)) == 0)
        {
            while( true)
            {
                printf("iteracija %d   \n\r", i);
                    if(strcount(txbuf) )
                    {
                        printf(" za slanje %d bajtova: %s\n\r", strcount(txbuf), txbuf);
                        if( (err = tcpSocket.send(txbuf,strcount(txbuf))<0 ) )   {    printf("send err %d\n\r", err); break; }
                        else(" poslano %d bajtova od: %s\n\r", err, txbuf);
                        memset(txbuf, 0, sizeof(txbuf) );
                    }
                    else
                    {
                        if( (err = tcpSocket.recv(rxbuf,sizeof(rxbuf)) <0 )) {    printf("recv err %d\n\r", err); break;  }
                        else                                                 
                        {
                          
                                printf(" prim tel %d: %s\n\r", err, rxbuf) ; 
                                {
                                  extern  void putOnDisp(char *, char );
                                     putOnDisp((char*)rxbuf, 1);
                                }
                                memcpy(txbuf, rxbuf, sizeof(txbuf) );
                                memset(rxbuf, 0, sizeof(rxbuf)); 
                        } 
                    }
                 printf("kraj iteracije %d   \n\r", i++);
                 fflush(stdout);
            }
        }
        else printf("greska otvaranja konekcije %d\n\r", err);
      }
      else printf("greska otvaranja socketa %d\n\r", err);
      
      printf("zatvaranje konekcije\n\r");
      tcpSocket.close();
      thread_sleep_for(2000);
     }
}

    


//
//enum nsapi_error {
//    NSAPI_ERROR_OK                  =  0,        /*!< no error */
//    NSAPI_ERROR_WOULD_BLOCK         = -3001,     /*!< no data is not available but call is non-blocking */
//    NSAPI_ERROR_UNSUPPORTED         = -3002,     /*!< unsupported functionality */
//    NSAPI_ERROR_PARAMETER           = -3003,     /*!< invalid configuration */
//    NSAPI_ERROR_NO_CONNECTION       = -3004,     /*!< not connected to a network */
//    NSAPI_ERROR_NO_SOCKET           = -3005,     /*!< socket not available for use */
//    NSAPI_ERROR_NO_ADDRESS          = -3006,     /*!< IP address is not known */
//    NSAPI_ERROR_NO_MEMORY           = -3007,     /*!< memory resource not available */
//    NSAPI_ERROR_NO_SSID             = -3008,     /*!< ssid not found */
//    NSAPI_ERROR_DNS_FAILURE         = -3009,     /*!< DNS failed to complete successfully */
//    NSAPI_ERROR_DHCP_FAILURE        = -3010,     /*!< DHCP failed to complete successfully */
//    NSAPI_ERROR_AUTH_FAILURE        = -3011,     /*!< connection to access point failed */
//    NSAPI_ERROR_DEVICE_ERROR        = -3012,     /*!< failure interfacing with the network processor */
//    NSAPI_ERROR_IN_PROGRESS         = -3013,     /*!< operation (eg connect) in progress */
//    NSAPI_ERROR_ALREADY             = -3014,     /*!< operation (eg connect) already in progress */
//    NSAPI_ERROR_IS_CONNECTED        = -3015,     /*!< socket is already connected */
//    NSAPI_ERROR_CONNECTION_LOST     = -3016,     /*!< connection lost */
//    NSAPI_ERROR_CONNECTION_TIMEOUT  = -3017,     /*!< connection timed out */
//};





void ev(int){tast=0;}

unsigned char buf_tel[100] = {0x71,0x00,0x0D,0x71,0x43,0x01,0x1B,0x4A,0x01,0x01,0x1B,0x43,1,0x33,0xD5,0x16};
void putOnDisp( char *s, char boja)
{
    int ubb = 13+strlen(s)+1+1-4-2;
    unsigned char lh, ll;
    ll=ubb;
    lh=ubb>>8;

    memcpy(buf_tel+13, s, strlen(s)+2);
    
    int suma=0;
    for(int i = 4; i < 13+strlen(s); i++) {
        suma +=buf_tel[i]; 
    }
    
    buf_tel[13+strlen(s)] = suma;
    buf_tel[13+strlen(s)+1] = 22;
    buf_tel[1]=lh;
    buf_tel[2]=ll;
   
    fflush(stdout);
    
    tast=1;
    rs485.write(buf_tel, 21,ev);
}
void putOnDispNo(int broj, char boja)
{
     char s[10];
    sprintf( s, "%d", broj);  
    putOnDisp( s, boja); 
}


void slanjefun(){
    
    int j=0;
    

    while (true) {
 //       printf("disp thred %d\n\r",j);
        if(j >10 && j<15 ) putOnDisp("des",1);
        else putOnDispNo(j,1);
        j++;
        thread_sleep_for(1000);
    }
}
