/** ADC Processing, Serial Comm, Timers
 * 
 * @version 0.0
 *
 * @author boseji (http://m8051.blogspot.com)
 *
 * @note
 * Copyright (c) 2010, boseji
 * released under MIT license http://mbed.org/licence/mit 
 *
 */
////////////////////////////////////////////////// 
// Include Files
#include "mbed.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
////////////////////////////////////////////////// 
//Pin Defines
DigitalOut sysled(LED1); //System Indicator
DigitalOut ind1(LED2);
DigitalOut ind2(LED3);
DigitalOut ind3(LED4);

AnalogIn Sense1(p15); //Sensor 1
AnalogIn Sense2(p16); //Sensor 2
AnalogIn Sense3(p17); //Sensor 3
AnalogIn Sense4(p19); //Sensor 4
AnalogIn Sense5(p20); //Sensor 5

AnalogOut Voc(p18);

Ticker t1;//Timer

//Configure the PC Serial Port for CDC USB
Serial pc(USBTX, USBRX); // tx, rx
//////////////////////////////////////////////////
// Function Declarations
void tint1( void );
////////////////////////////////////////////////// 
// main Program
int main() {

    unsigned short usCurrentValue;
    //Power Down the Unused Ethernet PHY
    EMAC_Init();
    PHY_EnergyDetect_Disable();
    PHY_PowerDown();

    //Configure the Fastest Baud Rate
    pc.baud(115200);

    printf("Aum Sri Ganeshay Namh !!\n");

    //Configure the Timer
    t1.attach(&tint1,0.8);

    //Say the System is Ready to Run
    sysled = 1;

    //Final Infinite Loop
    while (1) {
        usCurrentValue = (Sense1.read_u16()&0xFFF);
        ind3 = !ind3;
        wait(0.2);
        printf("\n ADC Val : %f Volts = %d (Decimal Reading)",(usCurrentValue*3.3/4095),usCurrentValue);
    }
}
////////////////////////////////////////////////// 
// Functions

// Interrupt for the Timer
void tint1( void ) {
    //printf("\n Aum ");
    ind2 = !ind2;
    
}
