#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PC_12, PC_11, PC_10, PD_2, "sd"); // mosi miso clk cs
AnalogIn   ain(PA_0);

// define write function
void sdWrite(float a){
    printf("start write SD\r\n");   
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fprintf(fp, "analog measure %f\r\n",a);
    fclose(fp); 
 
    printf("write succesfull\r\n\n");
}

int main() {
    
    // crearte folder
    mkdir("/sd/mydir", 0777);
    
    // create file
    printf("start write SD\r\n");   
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fprintf(fp, "analog measure\r\n");
    fprintf(fp, "==============\r\n");
    fclose(fp);
    
    // write 6 times an analog value
    for(int i=0; i<6; i++){
        sdWrite(ain.read());
        wait(2.0f);
    }
    // read from SD card
    printf("Reading from SD card...");
    fp = fopen("/sd/mydir/sdtest.txt", "r");
    if (fp != NULL) {
        char c = fgetc(fp);
        if (c == 'a')
            printf("success!\n");
        else
            printf("incorrect char (%c)!\n", c);
        fclose(fp);
    } else {
        printf("failed!\n");
    }
    
    

}