/*
 * ControllerScript.h
 * Copyright (c) 2017, ZHAW
 * All rights reserved.
 *
 *  Created on: 07.07.2017
 *      Author: Marcel Honegger
 */

#ifndef CONTROLLER_SCRIPT_H_
#define CONTROLLER_SCRIPT_H_

#include <string>
#include <vector>
#include <mbed.h>
#include "HTTPScript.h"
#include "Controller.h"
#include "LIDAR.h"

using namespace std;

/**
 * This is an application specific implementation of the http script.
 */
class ControllerScript : public HTTPScript {
    
    public:
        
                        //ControllerScript();
                        ControllerScript(DigitalIn& userButton,DigitalOut& myLed, Controller& controller, PwmOut& servo1, PwmOut& servo2, LIDAR& lidar);
        virtual         ~ControllerScript();
        virtual string  call(vector<string> names, vector<string> values);
        bool            test;
        
    private:
        
        uint32_t        counter;
        DigitalIn&      userButton;
        DigitalOut&     myLed;
        Controller&     controller;
        PwmOut&          servo1;
        PwmOut&          servo2;
        LIDAR&          lidar;
        float           camLeftRight;
        float           camUpDown;
        void            start();
        
};

#endif /* CONTROLLER_SCRIPT_H_ */

