/*
 * IndexScript.cpp
 * Copyright (c) 2017, ZHAW
 * All rights reserved.
 *
 *  Created on: 07.07.2017
 *      Author: Marcel Honegger
 */

#include "IndexScript.h"

using namespace std;

/**
 * Creates a custom http script.
 */
IndexScript::IndexScript() : HTTPScript() {}

IndexScript::~IndexScript() {}

/**
 * This method contains the logic to be executed when this http script is called.
 */
string IndexScript::call(vector<string> names, vector<string> values) {
    
    // create response
    
    string response;
    
    response += "  <script type=\"text/javascript\">\r\n";
    response += "  var xmlhttp = null;\r\n";
    response += "  var task = window.setInterval(\"update()\", 500);\r\n";
    response += "  function update() {\r\n";
    response += "    if (window.XMLHttpRequest) {\r\n";
    response += "      xmlhttp = new XMLHttpRequest();\r\n";
    response += "    } else if (window.ActiveXObject) {\r\n";
    response += "      try {\r\n";
    response += "        xmlhttp = new ActiveXObject(\"Msxml2.XMLHTTP\");\r\n";
    response += "      } catch (exception) {\r\n";
    response += "        try {\r\n";
    response += "          xmlhttp = new ActiveXObject(\"Microsoft.XMLHTTP\");\r\n";
    response += "        } catch (exception) {}\r\n";
    response += "      }\r\n";
    response += "    }\r\n";
    response += "    xmlhttp.onreadystatechange = refresh;\r\n";
    response += "    xmlhttp.open(\"GET\", \"/cgi-bin/controller\");\r\n";
    response += "    xmlhttp.send(null);\r\n";
    response += "  }\r\n";
    response += "  function refresh() {\r\n";
    response += "    if (xmlhttp.readyState == 4) {\r\n";
    response += "      var xml = xmlhttp.responseXML;\r\n";
    response += "      var intValues = xml.getElementsByTagName(\"int\");\r\n";
    response += "      var floatValues = xml.getElementsByTagName(\"float\");\r\n";
    response += "      document.getElementById(\"counter\").innerHTML = intValues[0].childNodes[0].nodeValue;\r\n";
    response += "      document.getElementById(\"value\").innerHTML = floatValues[0].childNodes[0].nodeValue;\r\n";
    response += "      drawCoordinates(intValues[0].childNodes[0].nodeValue,intValues[0].childNodes[0].nodeValue);\r\n";
    response += "    }\r\n";
    response += "  }\r\n";
    response += "  function drawCoordinates(x,y){ \r\n";
    response += "      var ctx = document.getElementById(\"canvas\").getContext(\"2d\");\r\n";
    response += "      ctx.clearRect(0, 0, 600, 600);\r\n";
    response += "      ctx.fillStyle = \"#ff2626\"; // Red color\r\n";
    response += "      ctx.beginPath();\r\n";
    response += "      ctx.arc(x, y, 3, 0, Math.PI * 2, true);\r\n";
    response += "      ctx.fill();\r\n";
    response += "  }\r\n"; 

    response += "  </script>\r\n";
    
    response += "  <iframe src=\"dummy.html\" width=\"0\" height=\"0\" name=\"dummy\" scrolling=\"no\" frameborder=\"0\"></iframe>";
    response += "  <h1>Controller</h1>\r\n";
    response += "  <table>\r\n";
    response += "    <tr>\r\n";
    response += "      <td style=\"font-size: 28px;\">Counter:</td>\r\n";
    response += "      <td id=\"counter\" width=\"100\" style=\"font-size: 28px; text-align: right;\">0</td>\r\n";
    response += "    </tr>\r\n";
    response += "    <tr>\r\n";
    response += "      <td style=\"font-size: 28px;\">User button:</td>\r\n";
    response += "      <td id=\"value\" width=\"100\" style=\"font-size: 28px; text-align: right;\">0.000</td>\r\n";
    response += "    </tr>\r\n";
    response += "  </table>\r\n";
    response += "  <form><input type=\"button\" id=\"Forward\" value=\"Forward\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Forward_on=true'; return false\" ontouchend=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Forward_off=true'; return false\" style=\"font-size: 30px; position: absolute; top: 200px; left: 50px; width: 200px; height: 100px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"Backward\" value=\"Backward\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Backward_on=true'; return false\" ontouchend=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Backward_off=true'; return false\" style=\"font-size: 30px; position: absolute; top: 400px; left: 40px; width: 200px; height: 100px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"Right\" value=\"Right\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Right_on=true'; return false\" ontouchend=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Right_off=true'; return false\" style=\"font-size: 30px; position: absolute; top: 300px; left: 1250px; width: 100px; height: 200px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"Left\" value=\"Left\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Left_on=true'; return false\" ontouchend=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?Left_off=true'; return false\" style=\"font-size: 30px; position: absolute; top: 300px; left: 1100px; width: 100px; height: 200px;\"></input></form>";
    
    /*
    // camera buttons
    response += "  <form><input type=\"button\" id=\"C_UP\" value=\"up\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?CAM_up=true'; return false\" ontouchend=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?CAM_up_off=true'; return false\" style=\"font-size: 30px; position: absolute; top: 200px; left: 700px; width: 100px; height: 100px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"C_DOWN\" value=\"down\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?CAM_down=true'; return false\"  style=\"font-size: 30px; position: absolute; top: 400px; left: 700px; width: 100px; height: 100px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"C_RIGHT\" value=\"Right\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?CAM_left=true'; return false\"  style=\"font-size: 30px; position: absolute; top: 300px; left: 800px; width: 100px; height: 100px;\"></input></form>";
    response += "  <form><input type=\"button\" id=\"C_LEFT\" value=\"Left\"   ontouchstart=\"parent.frames[0].location.href='http://192.168.0.100/cgi-bin/controller?CAM_right=true'; return false\"  style=\"font-size: 30px; position: absolute; top: 300px; left: 600px; width: 100px; height: 100px;\"></input></form>";
    */
    
    // Lidar points in canvas
    response += "  <canvas id=\"canvas\" width=\"300\" height=\"300\" style=\"cursor:crosshair; position: absolute; top: 200px; left: 600px;\"></canvas>";
    
    return response;
}

