/*
 * ControllerScript.cpp
 * Copyright (c) 2017, ZHAW
 * All rights reserved.
 *
 *  Created on: 07.07.2017
 *      Author: Marcel Honegger
 */

#include <cstdlib>
#include <stdint.h>
#include "ControllerScript.h"

using namespace std;

inline string bool2String(bool b) {
    
    return string(b ? "true" : "false");
}

inline string int2String(int32_t i) {
    
    char buffer[32];
    sprintf(buffer, "%d", i);
    
    return string(buffer);
}

inline string float2String(float f) {
    
    char buffer[32];
    sprintf(buffer, "%.3f", f);
    
    return string(buffer);
}


/**
 * Creates a custom http script.
 *//*
ControllerScript::ControllerScript() : HTTPScript() {
    
    counter = 0;
}*/

ControllerScript::ControllerScript(DigitalIn& userButton, DigitalOut& myLed, Controller& controller, PwmOut& servo1, PwmOut& servo2, LIDAR& lidar) : userButton(userButton), myLed(myLed),controller(controller),servo1(servo1),servo2(servo2),lidar(lidar), HTTPScript() {
    
    counter = 0;
    test = false;
    myLed = 0;
    camLeftRight = 0.07f;
    camUpDown = 0.05f;
    servo1.write(camLeftRight);
    servo2.write(camUpDown);
}

ControllerScript::~ControllerScript() {}

void ControllerScript::start(){
    test = !test;
    //myLed = !myLed;
}

/**
 * This method contains the logic to be executed when this http script is called.
 */
string ControllerScript::call(vector<string> names, vector<string> values) {
    
    // parse and process arguments
    for (int32_t i = 0; i < min(names.size(), values.size()); i++) {
        // process arguments
        if (names[i].compare("Forward_on") == 0 ) {myLed=1; controller.setTranslationalVelocity(0.2f);}
        if (names[i].compare("Forward_off") == 0 ) {myLed=0; controller.setTranslationalVelocity(0.0f);}
        if (names[i].compare("Backward_on") == 0 ) {myLed=1; controller.setTranslationalVelocity(-0.2f);}
        if (names[i].compare("Backward_off") == 0 ) {myLed=0; controller.setTranslationalVelocity(0.0f);}
        if (names[i].compare("Right_on") == 0 ) {myLed=1; controller.setRotationalVelocity(-1.0f);}
        if (names[i].compare("Right_off") == 0 ) {myLed=0; controller.setRotationalVelocity(0.0f);}
        if (names[i].compare("Left_on") == 0 ) {myLed=1; controller.setRotationalVelocity(1.0f);}
        if (names[i].compare("Left_off") == 0 ) {myLed=0; controller.setRotationalVelocity(0.0f);}
        
        if (names[i].compare("CAM_left") == 0 ) {if(camLeftRight>0.06){camLeftRight -= 0.002f;} servo1.write(camLeftRight);printf("LEFT servo1 = %.3f\r\n",this->camLeftRight);}
        if (names[i].compare("CAM_right") == 0 ) {if(camLeftRight<0.1){camLeftRight += 0.002f;} servo1.write(camLeftRight);printf("RIGHT servo1 = %.3f\r\n",this->camLeftRight);}
        if (names[i].compare("CAM_up") == 0 ) {myLed=1; camUpDown -= 0.005f; servo2.write(camUpDown);printf("UP servo2 = %.3f\r\n",this->camUpDown);}
        if (names[i].compare("CAM_up_off") == 0 ) {myLed=0; servo2.write(camUpDown);printf("UP off servo2 = %.3f\r\n",this->camUpDown);}
        if (names[i].compare("CAM_down") == 0 ) {camUpDown += 0.005f; servo2.write(camUpDown);}
    }
    
    string user;
    if(userButton){
            user = "ON";
        }else{
            user = "OFF";
    }
    
    // increment counter
    
    counter++;
    
    // get lidar measurements
    short d0 = lidar.getDistance(0);
    short d1 = lidar.getDistance(1);
    
    
    
    // create response
    
    string response;
    
    response += "  <controller>\r\n";
    response += "    <counter><int>"+int2String(counter)+"</int></counter>\r\n";
    response += "    <counter><int>"+int2String(d0)+"</int></counter>\r\n";
    response += "    <counter><int>"+int2String(d1)+"</int></counter>\r\n";
    response += "    <value><float>"+user+"</float></value>\r\n"; //<value><float>"+float2String(static_cast<float>(rand())/static_cast<float>(RAND_MAX))+"</float></value>\r\n"
    response += "  </controller>\r\n";
    
    return response;
}

