#ifndef CONTROLLER_H_
#define CONTROLLER_H_
#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "LowpassFilter.h"
#include "ThreadFlag.h"

class Controller
{

public:

    Controller(PwmOut& pwmLeft, PwmOut& pwmRight,
               EncoderCounter& counterLeft, EncoderCounter& counterRight);

    virtual ~Controller();
    void setDesiredSpeedLeft(float desiredSpeedLeft);
    void setDesiredSpeedRight(float desiredSpeedRight);
    float getSpeedLeft();
    float getSpeedRight();

private:

    static const uint32_t   STACK_SIZE = 4096;  // stack size of thread, given in [bytes]
    static const float PERIOD;
    static const float COUNTS_PER_TURN;
    static const float LOWPASS_FILTER_FREQUENCY;
    static const float KN;
    static const float KP;   
    static const float MAX_VOLTAGE;
    static const float MIN_DUTY_CYCLE;
    static const float MAX_DUTY_CYCLE;

    PwmOut&            pwmLeft;
    PwmOut&            pwmRight;
    EncoderCounter&    counterLeft;
    EncoderCounter&    counterRight;
    short              previousValueCounterLeft;
    short              previousValueCounterRight;
    LowpassFilter      speedLeftFilter;
    LowpassFilter      speedRightFilter;
    float              desiredSpeedLeft;
    float              desiredSpeedRight;
    float              actualSpeedLeft;
    float              actualSpeedRight;
    float               actualAngleLeft;
    float               actualAngleRight;
    
    ThreadFlag          threadFlag;
    Thread              thread;
    Ticker              ticker;
    
    void                sendThreadFlag();
    void                run();

};

#endif /* CONTROLLER_H_ */