#include "TextLCD.h"
#include "mbed.h"
#include "BME280.h"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
BME280 sensor(p28, p27);
#else
BME280 sensor(I2C_SDA, I2C_SCL);
#endif
TextLCD lcd(D8, D9, D2, D3, D4, D5,  TextLCD::LCD16x2); // rs, e, d4-d7
int main() {
    
double presion;

    while(1) 
    {
        presion = sensor.getPressure()/10;
        pc.printf("%2.2f C, %04.2f kPa, %2.2f %%\n", sensor.getTemperature(), presion, sensor.getHumidity());
        lcd.cls();
        lcd.printf("%2.2fC %04.2fkPa     %2.2f%%\n", sensor.getTemperature(), presion, sensor.getHumidity());
        wait(0.5);