/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2018 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

#define SENETCO

#define USE_BAND_915_HYBRID
//#define USE_BAND_915
//#define USE_BAND_ARIB_8CH
//#define USE_BAND_868
//#define USE_BAND_433
//#define USE_BAND_470
//#define USE_BAND_780


#define ENABLE_VT100

#ifdef ENABLE_VT100
    #define ROW_MLME_IND            (ROW_END+1)
    #define ROW_MLME_CONF           (ROW_END+2)
    #define ROW_MCPS_IND            (ROW_END+3)
    #define ROW_MCPS_CONF           (ROW_END+4)
    #define ROW_MIC                 (ROW_END+5)
#else
    #define ROW_MIC     0
#endif

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true


#define LORAWAN_DEVICE_EUI       { 0xAB,0xCD,0xEF,0x00,0x00,0x00,0x00,0x27 }

#define LORAWAN_JOIN_EUI         { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 }

#define LORAWAN_ROOT_NWKKEY     { 0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0xaa,0xbb,0xcc,0xdd,0xee,0xff }


#endif // __LORA_COMMISSIONING_H__

